/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.List;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.ConstNode;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.TypeInferringNode;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.expr.ValueValue;

public class LambdaNode
extends TypeInferringNode {
    private final List<Param> params;
    private final Node body;
    private final ThreadLocal<HashMap<String, ValueValue>> frame = new ThreadLocal();

    public LambdaNode(List<Param> params, Node body) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"null params");
        Preconditions.checkArgument((body != null ? 1 : 0) != 0, (Object)"null body");
        this.params = params;
        this.body = body;
        for (Param param : this.params) {
            param.setOwner(this);
        }
    }

    @Override
    public <T> Node resolve(ParseSession session, TypeToken<T> type) {
        MethodHandle invokeHandle;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType invokeMethodType = MethodType.methodType(Object.class, ParseSession.class, Object[].class);
        try {
            invokeHandle = lookup.findVirtual(LambdaNode.class, "invoke", invokeMethodType).bindTo(this);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("internal error", e);
        }
        MethodHandle invokeHandleWithSession = MethodHandles.insertArguments(invokeHandle, 0, new Object[]{session});
        MethodHandle invokeHandleWithSessionAndVarargs = invokeHandleWithSession.asVarargsCollector(Object[].class);
        Object proxy = MethodHandleProxies.asInterfaceInstance(type.getRawType(), invokeHandleWithSessionAndVarargs);
        return new ConstNode(new ConstValue(proxy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(ParseSession session, Object[] args) throws Throwable {
        if ((args != null ? args.length : 0) != this.params.size()) {
            throw new EvalException("internal error: wrong # params");
        }
        int index = 0;
        HashMap<String, ValueValue> paramMap = new HashMap<String, ValueValue>();
        for (Param param : this.params) {
            paramMap.put(param.getName(), new ValueValue(new ConstValue(args[index++])));
        }
        HashMap<String, ValueValue> previousParams = this.frame.get();
        this.frame.set(paramMap);
        try {
            Object object = this.body.evaluate(session).get(session);
            return object;
        }
        finally {
            if (previousParams != null) {
                this.frame.set(previousParams);
            } else {
                this.frame.remove();
            }
        }
    }

    public static class Param
    implements Node {
        private final String name;
        private LambdaNode owner;

        public Param(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private void setOwner(LambdaNode owner) {
            this.owner = owner;
        }

        @Override
        public Value evaluate(ParseSession session) {
            return (Value)((HashMap)this.owner.frame.get()).get(this.name);
        }

        @Override
        public Class<?> getType(ParseSession session) {
            return Object.class;
        }
    }
}

