/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dellroad.stuff.java.Primitive;
import org.dellroad.stuff.string.StringEncoder;
import org.jsimpledb.JTransaction;
import org.jsimpledb.UntypedJObject;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.TypeNotInSchemaVersionException;
import org.jsimpledb.parse.ObjIdParser;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.parse.expr.ClassNode;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.LiteralNode;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.expr.VarNode;
import org.jsimpledb.util.ParseContext;

public class LiteralExprParser
implements Parser<Node> {
    public static final LiteralExprParser INSTANCE = new LiteralExprParser();
    static final String IDENTS_AND_DOTS_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*(?:\\.\\s*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*";
    static final String CLASS_NAME_PATTERN = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*(?:\\.\\s*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*)\\s*(?:(?:\\[\\s*\\]\\s*)+)?";
    private final SpaceParser spaceParser = new SpaceParser();

    @Override
    public Node parse(ParseSession session, ParseContext ctx, boolean complete) {
        int start = ctx.getIndex();
        if (ctx.tryPattern("null(?!\\p{javaJavaIdentifierPart})") != null) {
            return new LiteralNode(null);
        }
        Matcher booleanMatch = ctx.tryPattern("(false|true)(?!\\p{javaJavaIdentifierPart})");
        if (booleanMatch != null) {
            return new LiteralNode(Boolean.valueOf(booleanMatch.group()));
        }
        Matcher classMatch = ctx.tryPattern("((?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*(?:\\.\\s*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*)\\s*(?:(?:\\[\\s*\\]\\s*)+)?)\\.\\s*class(?!\\p{javaJavaIdentifierPart})");
        if (classMatch != null) {
            String className = classMatch.group(1).replaceAll("\\s+", "");
            return ClassNode.parse(ctx, className, true);
        }
        try {
            boolean isLong;
            int radix;
            Matcher matcher = ctx.tryPattern("(?si)(\\+|-|)(?:0x|#)(\\p{XDigit}+)(L)?");
            if (matcher != null) {
                radix = 16;
            } else {
                matcher = ctx.tryPattern("(?si)(\\+|-|)0b([01]+)(L)?");
                if (matcher != null) {
                    radix = 2;
                } else {
                    matcher = ctx.tryPattern("(?si)(\\+|-|)(0[0-7]*)(L)?");
                    if (matcher != null) {
                        radix = 8;
                    } else {
                        matcher = ctx.tryPattern("(?si)(\\+|-|)([1-9][0-9]*)(L)?");
                        if (matcher != null) {
                            radix = 10;
                        } else {
                            throw new IllegalArgumentException("no pattern matched");
                        }
                    }
                }
            }
            String digits = matcher.group(1) + matcher.group(2);
            boolean bl = isLong = matcher.group(3) != null;
            if (ctx.tryPattern("[.\\p{javaJavaIdentifierPart}]") != null) {
                throw new IllegalArgumentException("followed by floating stuff");
            }
            BigInteger big = new BigInteger(digits, radix);
            if (big.bitLength() > (isLong ? 64 : 32)) {
                throw new IllegalArgumentException("bit length = " + big.bitLength());
            }
            Number value = isLong ? (Number)big.longValue() : (Number)big.intValue();
            return new LiteralNode(value);
        }
        catch (IllegalArgumentException e) {
            Matcher charMatch;
            Matcher doubleMatch;
            ctx.setIndex(start);
            Matcher floatMatch = ctx.tryPattern("(" + Primitive.FLOAT.getParsePattern() + ")[fF](?!\\p{javaJavaIdentifierPart})");
            if (floatMatch != null) {
                try {
                    return new LiteralNode(Primitive.FLOAT.parseValue(floatMatch.group(1)));
                }
                catch (IllegalArgumentException e2) {
                    ctx.setIndex(start);
                }
            }
            if ((doubleMatch = ctx.tryPattern("(" + Primitive.DOUBLE.getParsePattern() + ")(?![.\\p{javaJavaIdentifierPart}])")) != null) {
                try {
                    return new LiteralNode(Primitive.DOUBLE.parseValue(doubleMatch.group()));
                }
                catch (IllegalArgumentException e3) {
                    ctx.setIndex(start);
                }
            }
            if ((charMatch = ctx.tryPattern(StringEncoder.ENQUOTE_PATTERN.toString().replaceAll("\"", "'").replaceAll("\\*", ""))) != null) {
                String match = charMatch.group();
                if ((match = match.substring(1, match.length() - 1)).length() > 0 && match.charAt(0) == '\'') {
                    ctx.setIndex(start);
                    throw new ParseException(ctx, "invalid character: contains unescaped single quote");
                }
                if ((match = StringEncoder.decode((String)match.replaceAll(Pattern.quote("\\'"), Matcher.quoteReplacement("'")))).length() != 1) {
                    ctx.setIndex(start);
                    throw new ParseException(ctx, "invalid character: quotes must contain exactly one character");
                }
                return new LiteralNode(Character.valueOf(match.charAt(0)));
            }
            Matcher stringMatch = ctx.tryPattern(StringEncoder.ENQUOTE_PATTERN);
            if (stringMatch != null) {
                return new LiteralNode(StringEncoder.dequote((String)stringMatch.group()));
            }
            if (ctx.tryLiteral("$")) {
                Matcher varMatcher = ctx.tryPattern("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
                if (varMatcher == null) {
                    throw new ParseException(ctx).addCompletions(session.getVars().keySet());
                }
                String name = varMatcher.group();
                if (ctx.isEOF() && complete) {
                    throw new ParseException(ctx).addCompletions(ParseUtil.complete(session.getVars().keySet(), name));
                }
                return new VarNode(name);
            }
            if ((session.getMode().hasCoreAPI() || session.getMode().hasJSimpleDB()) && ctx.tryLiteral("@")) {
                final ObjId id = new ObjIdParser().parse(session, ctx, complete);
                return !session.getMode().hasJSimpleDB() ? new LiteralNode(id) : new Node(){

                    @Override
                    public Value evaluate(ParseSession session) {
                        return new ConstValue(JTransaction.getCurrent().get(id));
                    }

                    @Override
                    public Class<?> getType(ParseSession session) {
                        try {
                            return session.getJSimpleDB().getJClass(id).getType();
                        }
                        catch (TypeNotInSchemaVersionException e) {
                            return UntypedJObject.class;
                        }
                        catch (IllegalArgumentException e) {
                            return Object.class;
                        }
                    }
                };
            }
            throw new ParseException(ctx);
        }
    }
}

