/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractInvokeNode;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.MethodUtil;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;

public class MethodInvokeNode
extends AbstractInvokeNode<Method> {
    private final Class<?> klass;
    private final Node targetNode;
    private final String name;

    public MethodInvokeNode(Class<?> klass, String name, List<Node> paramNodes) {
        this(name, paramNodes, klass, null);
        Preconditions.checkArgument((klass != null ? 1 : 0) != 0, (Object)"null klass");
    }

    public MethodInvokeNode(Node targetNode, String name, List<Node> paramNodes) {
        this(name, paramNodes, null, targetNode);
        Preconditions.checkArgument((targetNode != null ? 1 : 0) != 0, (Object)"null targetNode");
    }

    private MethodInvokeNode(String name, List<Node> paramNodes, Class<?> klass, Node targetNode) {
        super(paramNodes);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        this.klass = klass;
        this.targetNode = targetNode;
        this.name = name;
    }

    @Override
    public Value evaluate(ParseSession session) {
        Object result;
        Object target = this.klass == null ? this.targetNode.evaluate(session).checkNotNull(session, "method " + this.name + "() invocation") : null;
        AbstractInvokeNode.ParamInfo paramInfo = this.evaluateParams(session);
        Method method = MethodUtil.findMatchingMethod(target != null ? target.getClass() : this.klass, this.name, true, paramInfo.getParamTypes(), null, this.klass != null);
        this.fixupVarArgs(paramInfo, method);
        this.fixupTypeInferringNodes(session, paramInfo, method);
        try {
            result = MethodUtil.invokeRefreshed(method, target, paramInfo.getParams());
        }
        catch (Exception e) {
            Exception t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            throw new EvalException("error invoking method `" + method.getName() + "()' on " + (target != null ? "object of type " + target.getClass().getName() : method.getDeclaringClass()) + ": " + t, t);
        }
        return result != null || method.getReturnType() != Void.TYPE ? new ConstValue(result) : Value.NO_VALUE;
    }

    @Override
    public Class<?> getType(ParseSession session) {
        return Object.class;
    }
}

