/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.BeanPropertyValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.LValue;
import org.jsimpledb.parse.expr.MethodUtil;
import org.jsimpledb.parse.expr.Value;

public class MutableBeanPropertyValue
extends BeanPropertyValue
implements LValue {
    protected final Method setter;

    public MutableBeanPropertyValue(Object bean, String name, Method getter, Method setter) {
        super(bean, name, getter);
        Preconditions.checkArgument((setter != null ? 1 : 0) != 0, (Object)"null setter");
        this.setter = setter;
    }

    @Override
    public void set(ParseSession session, Value value) {
        Object obj = value.get(session);
        try {
            MethodUtil.invokeRefreshed(this.setter, this.bean, obj);
        }
        catch (Exception e) {
            Exception t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            throw new EvalException("error writing property `" + this.name + "' from object of type " + this.bean.getClass().getName() + ": " + t, t);
        }
    }
}

