/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import java.util.regex.Matcher;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.parse.expr.BaseExprParser;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Op;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.util.ParseContext;

public class UnaryExprParser
implements Parser<Node> {
    public static final UnaryExprParser INSTANCE = new UnaryExprParser();
    private final SpaceParser spaceParser = new SpaceParser();

    @Override
    public Node parse(ParseSession session, ParseContext ctx, boolean complete) {
        Matcher matcher = ctx.tryPattern("\\+{1,2}|-{1,2}|!|~");
        if (matcher == null) {
            return BaseExprParser.INSTANCE.parse(session, ctx, complete);
        }
        String opsym = matcher.group();
        this.spaceParser.parse(ctx, complete);
        Node arg = this.parse(session, ctx, complete);
        switch (opsym) {
            case "!": {
                return this.createUnaryOpNode(Op.LOGICAL_NOT, arg, Boolean.class);
            }
            case "~": {
                return this.createUnaryOpNode(Op.INVERT, arg, null);
            }
            case "+": {
                return this.createUnaryOpNode(Op.UNARY_PLUS, arg, Number.class);
            }
            case "-": {
                return this.createUnaryOpNode(Op.UNARY_MINUS, arg, Number.class);
            }
            case "++": {
                return this.createPrecrementNode("increment", arg, null, true);
            }
            case "--": {
                return this.createPrecrementNode("decrement", arg, null, false);
            }
        }
        throw new RuntimeException("internal error: " + opsym);
    }

    private Node createUnaryOpNode(final Op op, final Node arg, final Class<?> type) {
        return new Node(){

            @Override
            public Value evaluate(ParseSession session) {
                return op.apply(session, arg.evaluate(session));
            }

            @Override
            public Class<?> getType(ParseSession session) {
                return type != null ? type : arg.getType(session);
            }
        };
    }

    private Node createPrecrementNode(final String operation, final Node node, final Class<?> type, final boolean increment) {
        return new Node(){

            @Override
            public Value evaluate(ParseSession session) {
                return node.evaluate(session).xxcrement(session, "pre-" + operation, increment);
            }

            @Override
            public Class<?> getType(ParseSession session) {
                return type != null ? type : node.getType(session);
            }
        };
    }
}

