/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.func;

import com.google.common.base.Preconditions;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.parse.ObjTypeParser;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractValue;
import org.jsimpledb.parse.expr.ExprParser;
import org.jsimpledb.parse.expr.LiteralNode;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.func.AbstractFunction;
import org.jsimpledb.util.ParseContext;

abstract class AbstractQueryFunction
extends AbstractFunction {
    private final int minValueTypes;
    private final int maxValueTypes;

    protected AbstractQueryFunction(String name, int minValueTypes, int maxValueTypes) {
        super(name);
        Preconditions.checkArgument((minValueTypes >= 1 && maxValueTypes >= minValueTypes ? 1 : 0) != 0, (Object)"invalid min/max");
        this.minValueTypes = minValueTypes;
        this.maxValueTypes = maxValueTypes;
    }

    @Override
    public Object parseParams(ParseSession session, ParseContext ctx, boolean complete) {
        int storageId;
        int typeStart;
        block13: {
            if (ctx.tryLiteral(")")) {
                throw new ParseException(ctx, "at least one parameter required");
            }
            typeStart = ctx.getIndex();
            storageId = -1;
            try {
                storageId = this.parseName(session, ctx, complete);
            }
            catch (ParseException e) {
                if (!complete || e.getCompletions().isEmpty()) break block13;
                throw e;
            }
        }
        if (storageId != -1) {
            ctx.skipWhitespace();
            if (!ctx.tryLiteral(")")) {
                throw new ParseException(ctx, "expected `)'").addCompletion(") ");
            }
            return storageId;
        }
        ctx.setIndex(typeStart);
        Node param1 = null;
        if (session.getMode().hasJSimpleDB()) {
            try {
                ObjType objType = new ObjTypeParser().parse(session, ctx, complete);
                int mark = ctx.getIndex();
                ctx.skipWhitespace();
                if (!ctx.tryLiteral(",")) {
                    throw new ParseException(ctx);
                }
                ctx.setIndex(mark);
                param1 = new LiteralNode(session.getJSimpleDB().getJClass(objType.getStorageId()).getType());
            }
            catch (ParseException e) {
                ctx.setIndex(typeStart);
            }
        }
        if (param1 == null) {
            param1 = ExprParser.INSTANCE.parse(session, ctx, complete);
        }
        ctx.skipWhitespace();
        if (ctx.tryLiteral(")")) {
            return param1;
        }
        if (!session.getMode().hasJSimpleDB()) {
            throw new ParseException(ctx, "expected `)' (JSimpleDB mode required for multiple params)").addCompletion(") ");
        }
        if (!ctx.tryLiteral(",")) {
            throw new ParseException(ctx, "expected `,' between " + this.getName() + "() function parameters").addCompletion(", ");
        }
        this.spaceParser.parse(ctx, complete);
        Node[] valueTypeNodes = this.parseExpressionParams(session, ctx, complete, 1, 1 + this.minValueTypes, 1 + this.maxValueTypes);
        Node[] result = new Node[1 + valueTypeNodes.length];
        result[0] = param1;
        System.arraycopy(valueTypeNodes, 0, result, 1, valueTypeNodes.length);
        return result;
    }

    protected abstract int parseName(ParseSession var1, ParseContext var2, boolean var3);

    @Override
    public Value apply(ParseSession session, Object result) {
        Integer storageId = null;
        if (result instanceof Node) {
            storageId = ((Node)result).evaluate(session).checkIntegral(session, "queryIndex()");
        } else if (result instanceof Integer) {
            storageId = (Integer)result;
        }
        if (storageId != null) {
            return this.apply(session, storageId);
        }
        Node[] params = (Node[])result;
        Class objectType = params[0].evaluate(session).checkType(session, this.getName(), Class.class);
        String fieldName = params[1].evaluate(session).checkType(session, this.getName(), String.class);
        Class[] valueTypes = new Class[params.length - 2];
        for (int i = 0; i < valueTypes.length; ++i) {
            valueTypes[i] = params[2 + i].evaluate(session).checkType(session, this.getName(), Class.class);
        }
        return this.apply(session, objectType, fieldName, valueTypes);
    }

    protected Value apply(ParseSession session, final int storageId) {
        return new AbstractValue(){

            @Override
            public Object get(ParseSession session) {
                if (session.getMode().hasJSimpleDB()) {
                    return JTransaction.getCurrent().queryIndex(storageId);
                }
                return session.getTransaction().queryIndex(storageId);
            }
        };
    }

    protected abstract Value apply(ParseSession var1, Class<?> var2, String var3, Class<?>[] var4);
}

