/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.func;

import com.google.common.base.Preconditions;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.func.AbstractFunction;
import org.jsimpledb.util.ParseContext;

public abstract class SimpleFunction
extends AbstractFunction {
    protected final int minArgs;
    protected final int maxArgs;

    protected SimpleFunction(String name, int minArgs, int maxArgs) {
        super(name);
        Preconditions.checkArgument((minArgs >= 0 && minArgs <= maxArgs ? 1 : 0) != 0, (Object)"invalid minArgs/maxArgs");
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
    }

    public int getMinArgs() {
        return this.minArgs;
    }

    public int getMaxArgs() {
        return this.maxArgs;
    }

    public final Node[] parseParams(ParseSession session, ParseContext ctx, boolean complete) {
        return this.parseExpressionParams(session, ctx, complete, 0, this.minArgs, this.maxArgs);
    }

    @Override
    public final Value apply(ParseSession session, Object info) {
        Node[] params = (Node[])info;
        Value[] values = new Value[params.length];
        for (int i = 0; i < params.length; ++i) {
            values[i] = params[i].evaluate(session);
        }
        return this.apply(session, values);
    }

    protected abstract Value apply(ParseSession var1, Value[] var2);
}

