/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.util;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.jsimpledb.util.ParseContext;

public class TypeTokenParser {
    private final ClassLoader loader;
    private Method newParameterizedTypeMethod;

    public TypeTokenParser() {
        this(null);
    }

    public TypeTokenParser(ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        this.loader = loader;
    }

    public TypeToken<?> parse(String string) throws ClassNotFoundException {
        ParseContext ctx = new ParseContext(string);
        TypeToken<?> token = this.parse(new ParseContext(string));
        ctx.skipWhitespace();
        if (!ctx.isEOF()) {
            throw new IllegalArgumentException("string contains trailing garbage at index " + ctx.getIndex());
        }
        return token;
    }

    public TypeToken<?> parse(ParseContext ctx) throws ClassNotFoundException {
        ArrayList<Type> parameterTypes;
        TypeVariable<Class<?>>[] typeParameters;
        Class<?> cl;
        block4: {
            ctx.skipWhitespace();
            Matcher matcher = ctx.matchPrefix("[^,<>]+");
            String className = matcher.group();
            cl = this.loader.loadClass(className);
            typeParameters = cl.getTypeParameters();
            ctx.skipWhitespace();
            if (ctx.isEOF()) {
                return TypeToken.of(cl);
            }
            ctx.skipWhitespace();
            parameterTypes = new ArrayList<Type>(typeParameters.length);
            if (ctx.peek() == '<') {
                char ch;
                ctx.read();
                do {
                    ctx.skipWhitespace();
                    parameterTypes.add(this.parse(ctx).getType());
                    ctx.skipWhitespace();
                    ch = ctx.read();
                    if (ch == '>') break block4;
                } while (ch == ',');
                throw new IllegalArgumentException("unexpected character `" + ch + "' at index " + ctx.getIndex());
            }
        }
        if (parameterTypes.size() != typeParameters.length) {
            throw new IllegalArgumentException(cl + " has " + typeParameters.length + " generic type parameters but " + parameterTypes.size() + " parameters were supplied");
        }
        return parameterTypes.isEmpty() ? TypeToken.of(cl) : this.newParameterizedType(cl, parameterTypes);
    }

    private <T> TypeToken<? extends T> newParameterizedType(Class<T> target, List<Type> params) {
        Type type;
        try {
            if (this.newParameterizedTypeMethod == null) {
                this.newParameterizedTypeMethod = Class.forName("com.google.common.reflect.Types", false, this.loader).getDeclaredMethod("newParameterizedType", Class.class, Type[].class);
                this.newParameterizedTypeMethod.setAccessible(true);
            }
            type = (Type)this.newParameterizedTypeMethod.invoke(null, target, params.toArray(new Type[params.size()]));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected exception", e);
        }
        return TypeToken.of((Type)type);
    }

    public static void main(String[] args) throws Exception {
        TypeTokenParser parser = new TypeTokenParser();
        for (String arg : args) {
            System.out.println(parser.parse(new ParseContext(arg)));
        }
    }
}

