/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.sqlite;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVImplementation;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.sqlite.SQLiteKVDatabase;

public class SQLiteKVImplementation
extends KVImplementation {
    public String[][] getCommandLineOptions() {
        return new String[][]{{"--sqlite file", "Use SQLite key/value database using the specified file"}, {"--sqlite-exclusive", "Configure SQLite connections for exclusive locking"}, {"--sqlite-pragma pragma", "Specify a PRAGMA for new connections (omit PRAGMA keyword); may be repeated"}};
    }

    public Config parseCommandLineOptions(ArrayDeque<String> options) {
        String pragma;
        String filename = this.parseCommandLineOption(options, "--sqlite");
        if (filename == null) {
            return null;
        }
        Config config = new Config();
        config.setFile(new File(filename));
        config.setExclusiveLocking(this.parseCommandLineFlag(options, "--sqlite-exclusive"));
        while ((pragma = this.parseCommandLineOption(options, "--sqlite-pragma")) != null) {
            config.getPragmas().add(pragma);
        }
        return config;
    }

    public SQLiteKVDatabase createKVDatabase(Object configuration, KVDatabase kvdb, AtomicKVStore kvstore) {
        Config config = (Config)configuration;
        SQLiteKVDatabase sqlite = new SQLiteKVDatabase();
        sqlite.setDatabaseFile(config.getFile());
        sqlite.setExclusiveLocking(config.isExclusiveLocking());
        sqlite.setPragmas(config.getPragmas());
        return sqlite;
    }

    public String getDescription(Object configuration) {
        Config config = (Config)configuration;
        return "SQLite " + config.getFile().getName();
    }

    private static class Config {
        private File file;
        private boolean exclusiveLocking;
        private final ArrayList<String> pragmas = new ArrayList();

        private Config() {
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public boolean isExclusiveLocking() {
            return this.exclusiveLocking;
        }

        public void setExclusiveLocking(boolean exclusiveLocking) {
            this.exclusiveLocking = exclusiveLocking;
        }

        public ArrayList<String> getPragmas() {
            return this.pragmas;
        }
    }
}

