/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import org.jsimpledb.ConvertedIndex3;
import org.jsimpledb.index.Index3;

class Index3Converter<V1, V2, V3, T, WV1, WV2, WV3, WT>
extends Converter<Index3<V1, V2, V3, T>, Index3<WV1, WV2, WV3, WT>> {
    private final Converter<V1, WV1> value1Converter;
    private final Converter<V2, WV2> value2Converter;
    private final Converter<V3, WV3> value3Converter;
    private final Converter<T, WT> targetConverter;

    Index3Converter(Converter<V1, WV1> value1Converter, Converter<V2, WV2> value2Converter, Converter<V3, WV3> value3Converter, Converter<T, WT> targetConverter) {
        Preconditions.checkArgument((value1Converter != null ? 1 : 0) != 0, (Object)"null value1Converter");
        Preconditions.checkArgument((value2Converter != null ? 1 : 0) != 0, (Object)"null value2Converter");
        Preconditions.checkArgument((value3Converter != null ? 1 : 0) != 0, (Object)"null value3Converter");
        Preconditions.checkArgument((targetConverter != null ? 1 : 0) != 0, (Object)"null targetConverter");
        this.value1Converter = value1Converter;
        this.value2Converter = value2Converter;
        this.value3Converter = value3Converter;
        this.targetConverter = targetConverter;
    }

    protected Index3<WV1, WV2, WV3, WT> doForward(Index3<V1, V2, V3, T> index) {
        if (index == null) {
            return null;
        }
        return new ConvertedIndex3(index, this.value1Converter.reverse(), this.value2Converter.reverse(), this.value3Converter.reverse(), this.targetConverter.reverse());
    }

    protected Index3<V1, V2, V3, T> doBackward(Index3<WV1, WV2, WV3, WT> index) {
        if (index == null) {
            return null;
        }
        return new ConvertedIndex3<V1, V2, V3, T, WV1, WV2, WV3, WT>(index, this.value1Converter, this.value2Converter, this.value3Converter, this.targetConverter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Index3Converter that = (Index3Converter)((Object)obj);
        return this.value1Converter.equals(that.value1Converter) && this.value2Converter.equals(that.value2Converter) && this.value3Converter.equals(that.value3Converter) && this.targetConverter.equals(that.targetConverter);
    }

    public int hashCode() {
        return this.value1Converter.hashCode() ^ this.value2Converter.hashCode() ^ this.value3Converter.hashCode() ^ this.targetConverter.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[value1Converter=" + this.value1Converter + ",value2Converter=" + this.value2Converter + ",value3Converter=" + this.value3Converter + ",targetConverter=" + this.targetConverter + "]";
    }
}

