/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import org.jsimpledb.ConvertedIndex;
import org.jsimpledb.index.Index;

class IndexConverter<V, T, WV, WT>
extends Converter<Index<V, T>, Index<WV, WT>> {
    private final Converter<V, WV> valueConverter;
    private final Converter<T, WT> targetConverter;

    IndexConverter(Converter<V, WV> valueConverter, Converter<T, WT> targetConverter) {
        Preconditions.checkArgument((valueConverter != null ? 1 : 0) != 0, (Object)"null valueConverter");
        Preconditions.checkArgument((targetConverter != null ? 1 : 0) != 0, (Object)"null targetConverter");
        this.valueConverter = valueConverter;
        this.targetConverter = targetConverter;
    }

    protected Index<WV, WT> doForward(Index<V, T> index) {
        if (index == null) {
            return null;
        }
        return new ConvertedIndex(index, this.valueConverter.reverse(), this.targetConverter.reverse());
    }

    protected Index<V, T> doBackward(Index<WV, WT> index) {
        if (index == null) {
            return null;
        }
        return new ConvertedIndex<V, T, WV, WT>(index, this.valueConverter, this.targetConverter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        IndexConverter that = (IndexConverter)((Object)obj);
        return this.valueConverter.equals(that.valueConverter) && this.targetConverter.equals(that.targetConverter);
    }

    public int hashCode() {
        return this.valueConverter.hashCode() ^ this.targetConverter.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[valueConverter=" + this.valueConverter + ",targetConverter=" + this.targetConverter + "]";
    }
}

