/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jsimpledb.CompositeIndexInfo;
import org.jsimpledb.IndexInfo;
import org.jsimpledb.JClass;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JCompositeIndex;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.MapValueIndexInfo;
import org.jsimpledb.ReferencePath;
import org.jsimpledb.SimpleFieldIndexInfo;
import org.jsimpledb.Util;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.CoreIndex2;
import org.jsimpledb.core.CoreIndex3;
import org.jsimpledb.core.CoreIndex4;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.type.ReferenceFieldType;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.KeyRanges;

class IndexQueryInfo {
    private static final KeyRange NULL_RANGE = new KeyRange(new byte[]{-1}, null);
    final IndexInfo indexInfo;
    private final Class<?> startType;
    private final ArrayList<KeyRanges> filters = new ArrayList();

    IndexQueryInfo(JSimpleDB jdb, Class<?> startType, String fieldName, Class<?> valueType) {
        this(jdb, startType, fieldName, valueType, (Class<?>)null);
    }

    IndexQueryInfo(JSimpleDB jdb, Class<?> startType, String fieldName, Class<?> valueType, Class<?> keyType) {
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        Preconditions.checkArgument((fieldName != null ? 1 : 0) != 0, (Object)"null fieldName");
        Preconditions.checkArgument((startType != null ? 1 : 0) != 0, (Object)"null startType");
        Preconditions.checkArgument((valueType != null ? 1 : 0) != 0, (Object)"null valueType");
        Preconditions.checkArgument((!startType.isPrimitive() && !startType.isArray() ? 1 : 0) != 0, (Object)("invalid startType " + startType));
        this.startType = startType;
        ReferencePath path = jdb.parseReferencePath(this.startType, fieldName, true, true);
        if (path.getReferenceFields().length > 0) {
            throw new IllegalArgumentException("invalid field name `" + fieldName + "': contains intermediate reference(s)");
        }
        SimpleFieldIndexInfo fieldIndexInfo = jdb.getIndexInfo(path.targetFieldStorageId, keyType != null ? MapValueIndexInfo.class : SimpleFieldIndexInfo.class);
        this.indexInfo = fieldIndexInfo;
        ArrayList<ValueCheck> valueChecks = new ArrayList<ValueCheck>(3);
        valueChecks.add(new ValueCheck("value type", valueType, this.wrapRaw(path.getTargetFieldTypes()), fieldIndexInfo.getFieldType()));
        valueChecks.add(new ValueCheck("target type", startType, path.getTargetTypes()));
        if (keyType != null) {
            MapValueIndexInfo mapValueIndexInfo = (MapValueIndexInfo)fieldIndexInfo;
            valueChecks.add(new ValueCheck("map key type", keyType, this.wrapRaw(this.getTypeTokens(jdb, this.startType, mapValueIndexInfo.getKeyFieldStorageId(), mapValueIndexInfo.getParentStorageId())), mapValueIndexInfo.getKeyFieldType()));
        }
        valueChecks.stream().map(check -> check.checkAndGetKeyRanges(jdb, startType, "index query on field `" + fieldName + "'")).forEach(this.filters::add);
    }

    IndexQueryInfo(JSimpleDB jdb, Class<?> startType, String indexName, Class<?> ... valueTypes) {
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        Preconditions.checkArgument((indexName != null ? 1 : 0) != 0, (Object)"null indexName");
        Preconditions.checkArgument((valueTypes != null ? 1 : 0) != 0, (Object)"null valueTypes");
        Preconditions.checkArgument((!startType.isPrimitive() && !startType.isArray() ? 1 : 0) != 0, (Object)("invalid startType " + startType));
        this.startType = startType;
        CompositeIndexInfo compositeIndexInfo = IndexQueryInfo.findCompositeIndex(jdb, startType, indexName, valueTypes.length);
        this.indexInfo = compositeIndexInfo;
        ArrayList<ValueCheck> valueChecks = new ArrayList<ValueCheck>(valueTypes.length + 1);
        for (int i = 0; i < valueTypes.length; ++i) {
            Class<?> valueType = valueTypes[i];
            valueChecks.add(new ValueCheck("value type #" + (i + 1), valueType, this.wrapRaw(this.getTypeTokens(jdb, this.startType, compositeIndexInfo.getStorageIds().get(i))), compositeIndexInfo.getFieldTypes().get(i)));
        }
        valueChecks.add(new ValueCheck("target type", startType, startType));
        valueChecks.stream().map(check -> check.checkAndGetKeyRanges(jdb, startType, "query on composite index `" + indexName + "'")).forEach(this.filters::add);
    }

    private Set<TypeToken<?>> getTypeTokens(JSimpleDB jdb, Class<?> context, int storageId) {
        return this.getTypeTokens(jdb, context, storageId, 0);
    }

    private Set<TypeToken<?>> getTypeTokens(JSimpleDB jdb, Class<?> context, int storageId, int parentStorageId) {
        HashSet contextFieldTypes = new HashSet();
        for (JClass<?> jclass : jdb.jclasses.values()) {
            if (!context.isAssignableFrom(jclass.type)) continue;
            JSimpleField simpleField = null;
            if (parentStorageId != 0) {
                JComplexField parentField = (JComplexField)jclass.jfields.get(parentStorageId);
                if (parentField != null) {
                    simpleField = parentField.getSubField(storageId);
                }
            } else {
                simpleField = (JSimpleField)jclass.jfields.get(storageId);
            }
            if (simpleField == null) continue;
            contextFieldTypes.add(simpleField.typeToken);
        }
        if (contextFieldTypes.isEmpty()) {
            throw new IllegalArgumentException("no sub-type of " + context + " contains and indexed simple field with storage ID " + storageId);
        }
        return Util.findLowestCommonAncestors(contextFieldTypes);
    }

    private Set<Class<?>> wrapRaw(Set<TypeToken<?>> typeTokens) {
        HashSet classes = new HashSet(typeTokens.size());
        for (TypeToken<?> typeToken : typeTokens) {
            classes.add(typeToken.wrap().getRawType());
        }
        return classes;
    }

    private static CompositeIndexInfo findCompositeIndex(JSimpleDB jdb, Class<?> startType, String indexName, int numValues) {
        CompositeIndexInfo indexInfo = null;
        for (JClass<?> jclass : jdb.getJClasses(startType)) {
            JCompositeIndex index = jclass.jcompositeIndexesByName.get(indexName);
            if (index == null) continue;
            CompositeIndexInfo candidate = jdb.getIndexInfo(index.storageId, CompositeIndexInfo.class);
            if (indexInfo != null && !candidate.equals(indexInfo)) {
                throw new IllegalArgumentException("ambiguous composite index name `" + indexName + "': multiple incompatible composite indexes with that name exist on sub-types of " + startType.getName());
            }
            indexInfo = candidate;
        }
        if (indexInfo == null) {
            throw new IllegalArgumentException("no composite index named `" + indexName + "' exists on any sub-type of " + startType.getName());
        }
        if (numValues != indexInfo.getFieldTypes().size()) {
            throw new IllegalArgumentException("composite index `" + indexName + "' on " + startType.getName() + " has " + indexInfo.getFieldTypes().size() + " fields, not " + numValues);
        }
        return indexInfo;
    }

    public <V, T> CoreIndex<V, T> applyFilters(CoreIndex<V, T> index) {
        for (int i = 0; i < this.filters.size(); ++i) {
            KeyRanges filter = this.filters.get(i);
            if (filter == null || filter.isFull()) continue;
            index = index.filter(i, (KeyFilter)filter);
        }
        return index;
    }

    public <V1, V2, T> CoreIndex2<V1, V2, T> applyFilters(CoreIndex2<V1, V2, T> index) {
        for (int i = 0; i < this.filters.size(); ++i) {
            KeyRanges filter = this.filters.get(i);
            if (filter == null || filter.isFull()) continue;
            index = index.filter(i, (KeyFilter)filter);
        }
        return index;
    }

    public <V1, V2, V3, T> CoreIndex3<V1, V2, V3, T> applyFilters(CoreIndex3<V1, V2, V3, T> index) {
        for (int i = 0; i < this.filters.size(); ++i) {
            KeyRanges filter = this.filters.get(i);
            if (filter == null || filter.isFull()) continue;
            index = index.filter(i, (KeyFilter)filter);
        }
        return index;
    }

    public <V1, V2, V3, V4, T> CoreIndex4<V1, V2, V3, V4, T> applyFilters(CoreIndex4<V1, V2, V3, V4, T> index) {
        for (int i = 0; i < this.filters.size(); ++i) {
            KeyRanges filter = this.filters.get(i);
            if (filter == null || filter.isFull()) continue;
            index = index.filter(i, (KeyFilter)filter);
        }
        return index;
    }

    public String toString() {
        return "IndexQueryInfo[startType=" + this.startType + ",indexInfo=" + this.indexInfo + ",filters=" + this.filters + "]";
    }

    private static class ValueCheck {
        private final String description;
        private final Class<?> actualType;
        private final Set<Class<?>> expectedTypes;
        private final boolean reference;
        private final boolean matchNull;

        ValueCheck(String description, Class<?> actualType, Set<Class<?>> expectedTypes, boolean reference, boolean matchNull) {
            this.description = description;
            this.actualType = actualType;
            this.expectedTypes = expectedTypes;
            this.reference = reference;
            this.matchNull = matchNull;
        }

        ValueCheck(String description, Class<?> actualType, Set<Class<?>> expectedTypes, FieldType<?> fieldType) {
            this(description, actualType, expectedTypes, fieldType instanceof ReferenceFieldType, true);
        }

        ValueCheck(String description, Class<?> actualType, Set<Class<?>> expectedTypes) {
            this(description, actualType, expectedTypes, true, false);
        }

        ValueCheck(String description, Class<?> actualType, Class<?> expectedType) {
            this(description, actualType, Collections.singleton(expectedType));
        }

        public KeyRanges checkAndGetKeyRanges(JSimpleDB jdb, Class<?> startType, String queryDescription) {
            boolean match = this.expectedTypes.contains(this.actualType);
            if (!match) {
                for (Class<?> expectedType : this.expectedTypes) {
                    if (!this.actualType.isAssignableFrom(expectedType) && (!this.reference || !expectedType.isAssignableFrom(this.actualType))) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                StringBuilder expectedTypesDescription = new StringBuilder();
                if (this.expectedTypes.size() == 1) {
                    expectedTypesDescription.append(this.expectedTypes.iterator().next().getName());
                } else {
                    for (Class<?> expectedType : this.expectedTypes) {
                        expectedTypesDescription.append(expectedTypesDescription.length() == 0 ? "one or more of: " : ", ");
                        expectedTypesDescription.append(expectedType.getName());
                    }
                }
                throw new IllegalArgumentException("invalid " + this.description + " " + this.actualType.getName() + " for " + queryDescription + " in " + startType + ": should be a super-type" + (this.reference ? " or sub-type " : "") + " of " + expectedTypesDescription);
            }
            if (!this.reference) {
                return null;
            }
            if (this.actualType.isAssignableFrom(JObject.class)) {
                return null;
            }
            KeyRanges filter = jdb.keyRangesFor(this.actualType);
            if (this.matchNull) {
                filter.add(NULL_RANGE);
            }
            return filter;
        }

        public String toString() {
            return "ValueCheck[description=\"" + this.description + "\",actualType=" + this.actualType.getSimpleName() + ",expectedTypes=" + this.expectedTypes + ",reference=" + this.reference + ",matchNull=" + this.matchNull + "]";
        }
    }
}

