/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.jsimpledb.CompositeIndexInfo;
import org.jsimpledb.IndexInfo;
import org.jsimpledb.JSchemaObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.SchemaCompositeIndex;
import org.jsimpledb.util.ParseContext;

public class JCompositeIndex
extends JSchemaObject {
    final Class<?> declaringType;
    final List<JSimpleField> jfields;
    final boolean unique;
    final List<List<Object>> uniqueExcludes;
    final Comparator<List<Object>> uniqueComparator;

    JCompositeIndex(JSimpleDB jdb, String name, int storageId, Class<?> declaringType, org.jsimpledb.annotation.JCompositeIndex annotation, JSimpleField ... jfields) {
        super(jdb, name, storageId, "composite index `" + name + "' on fields " + Arrays.asList(jfields));
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        Preconditions.checkArgument((declaringType != null ? 1 : 0) != 0, (Object)"null declaringType");
        Preconditions.checkArgument((jfields.length >= 2 && jfields.length <= 4 ? 1 : 0) != 0, (Object)"invalid field count");
        Preconditions.checkArgument((annotation != null ? 1 : 0) != 0, (Object)"null annotation");
        this.declaringType = declaringType;
        this.jfields = Collections.unmodifiableList(Arrays.asList(jfields));
        this.unique = annotation.unique();
        int numExcludes = annotation.uniqueExclude().length;
        if (numExcludes > 0) {
            assert (this.unique);
            this.uniqueExcludes = new ArrayList<List<Object>>(numExcludes);
            int numFields = this.jfields.size();
            for (String string : annotation.uniqueExclude()) {
                ParseContext ctx = new ParseContext(string);
                ArrayList<Object> values = new ArrayList<Object>(numFields);
                for (JSimpleField jfield : this.jfields) {
                    try {
                        values.add(jfield.fieldType.fromParseableString(ctx));
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("invalid uniqueExclude() value `" + string + "': " + e.getMessage(), e);
                    }
                    if (values.size() >= numFields) continue;
                    ctx.skipWhitespace();
                    ctx.expect(',');
                    ctx.skipWhitespace();
                }
                this.uniqueExcludes.add(values);
            }
            Comparator<List<Object>> comparator = null;
            for (int i = 0; i < this.jfields.size(); ++i) {
                comparator = this.addFieldComparator(comparator, i, this.jfields.get((int)i).fieldType);
            }
            this.uniqueComparator = comparator;
            Collections.sort(this.uniqueExcludes, this.uniqueComparator);
        } else {
            this.uniqueExcludes = null;
            this.uniqueComparator = null;
        }
    }

    private <T> Comparator<List<Object>> addFieldComparator(Comparator<List<Object>> comparator, int i, FieldType<T> fieldType) {
        assert (comparator == null == (i == 0));
        Function<List, Object> valueExtractor = list -> fieldType.validate(list.get(i));
        return comparator != null ? comparator.thenComparing(valueExtractor, fieldType) : Comparator.comparing(valueExtractor, fieldType);
    }

    public List<JSimpleField> getJFields() {
        return this.jfields;
    }

    @Override
    IndexInfo toIndexInfo() {
        return new CompositeIndexInfo(this);
    }

    SchemaCompositeIndex toSchemaItem(JSimpleDB jdb) {
        SchemaCompositeIndex schemaIndex = new SchemaCompositeIndex();
        this.initialize(jdb, schemaIndex);
        return schemaIndex;
    }

    void initialize(JSimpleDB jdb, SchemaCompositeIndex schemaIndex) {
        super.initialize(jdb, (AbstractSchemaItem)schemaIndex);
        for (JSimpleField jfield : this.jfields) {
            schemaIndex.getIndexedFields().add(jfield.getStorageId());
        }
    }

    Class<?>[] getQueryInfoValueTypes() {
        Class[] rawTypes = new Class[this.jfields.size()];
        for (int i = 0; i < rawTypes.length; ++i) {
            rawTypes[i] = this.jfields.get((int)i).typeToken.wrap().getRawType();
        }
        return rawTypes;
    }
}

