/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.List;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.Counter;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.UpgradeConversionPolicy;
import org.jsimpledb.asm.ClassWriter;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.CounterSchemaField;

public class JCounterField
extends JField {
    final UpgradeConversionPolicy upgradeConversion;

    JCounterField(JSimpleDB jdb, String name, int storageId, org.jsimpledb.annotation.JField annotation, String description, Method getter) {
        super(jdb, name, storageId, description, getter);
        this.upgradeConversion = annotation.upgradeConversion();
    }

    @Override
    public Counter getValue(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return jobj.getTransaction().readCounterField(jobj.getObjId(), this.storageId, false);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJCounterField(this);
    }

    CounterSchemaField toSchemaItem(JSimpleDB jdb) {
        CounterSchemaField schemaField = new CounterSchemaField();
        this.initialize(jdb, (AbstractSchemaItem)schemaField);
        return schemaField;
    }

    public TypeToken<Counter> getTypeToken() {
        return TypeToken.of(Counter.class);
    }

    @Override
    public Converter<?, ?> getConverter(JTransaction jtx) {
        return null;
    }

    @Override
    boolean supportsChangeNotifications() {
        return false;
    }

    @Override
    <T> void addChangeParameterTypes(List<TypeToken<?>> types, Class<T> targetType) {
        throw new UnsupportedOperationException("counter fields do not support change notifications");
    }

    @Override
    void outputFields(ClassGenerator<?> generator, ClassWriter cw) {
        this.outputCachedValueField(generator, cw);
    }

    @Override
    void outputMethods(ClassGenerator<?> generator, ClassWriter cw) {
        this.outputCachedNonSimpleValueGetterMethod(generator, cw, ClassGenerator.JTRANSACTION_READ_COUNTER_FIELD_METHOD);
    }
}

