/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.List;
import org.jsimpledb.AbstractFieldScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.JFieldScanner;
import org.jsimpledb.annotation.JField;
import org.jsimpledb.annotation.JListField;
import org.jsimpledb.annotation.JSimpleClass;

class JListFieldScanner<T>
extends AbstractFieldScanner<T, JListField> {
    JListFieldScanner(JClass<T> jclass, JSimpleClass jsimpleClass) {
        super(jclass, JListField.class, jsimpleClass);
    }

    @Override
    protected JListField getDefaultAnnotation() {
        return new DefaultJListField(this.jsimpleClass);
    }

    protected boolean includeMethod(Method method, JListField annotation) {
        this.checkNotStatic(method);
        this.checkReturnType(method, List.class);
        this.checkParameterTypes(method, new TypeToken[0]);
        return true;
    }

    @Override
    protected boolean isAutoPropertyCandidate(Method method) {
        return super.isAutoPropertyCandidate(method) && List.class.isAssignableFrom(method.getReturnType());
    }

    private static class DefaultJListField
    implements JListField {
        private JSimpleClass jsimpleClass;

        DefaultJListField(JSimpleClass jsimpleClass) {
            this.jsimpleClass = jsimpleClass;
        }

        public Class<JListField> annotationType() {
            return JListField.class;
        }

        @Override
        public String name() {
            return "";
        }

        @Override
        public int storageId() {
            return 0;
        }

        @Override
        public JField element() {
            return JFieldScanner.getDefaultJField(this.jsimpleClass);
        }
    }
}

