/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import java.util.NavigableSet;
import org.jsimpledb.CopyState;
import org.jsimpledb.JClass;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.util.ObjIdSet;
import org.jsimpledb.util.NavigableSets;

public interface JObject {
    public ObjId getObjId();

    default public int getSchemaVersion() {
        return this.getTransaction().getSchemaVersion(this.getObjId());
    }

    public JTransaction getTransaction();

    default public boolean delete() {
        return this.getTransaction().delete(this);
    }

    default public boolean exists() {
        return this.getTransaction().exists(this.getObjId());
    }

    default public boolean isSnapshot() {
        return this.getTransaction().isSnapshot();
    }

    default public boolean recreate() {
        return this.getTransaction().recreate(this);
    }

    default public void revalidate(Class<?> ... groups) {
        this.getTransaction().revalidate(this.getObjId(), groups);
    }

    default public boolean upgrade() {
        return this.getTransaction().updateSchemaVersion(this);
    }

    default public JObject copyTo(JTransaction dest, CopyState copyState, String ... refPaths) {
        return this.getTransaction().copyTo(dest, this, copyState, refPaths);
    }

    default public JObject copyOut(String ... refPaths) {
        return this.copyTo(this.getTransaction().getSnapshotTransaction(), new CopyState(), refPaths);
    }

    default public JObject copyIn(String ... refPaths) {
        return this.copyTo(JTransaction.getCurrent(), new CopyState(), refPaths);
    }

    default public JObject cascadeCopyTo(JTransaction dest, String cascadeName, boolean clone) {
        return this.cascadeCopyTo(dest, cascadeName, -1, clone);
    }

    default public JObject cascadeCopyTo(JTransaction dest, String cascadeName, int recursionLimit, boolean clone) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        ObjId id = this.getObjId();
        JTransaction jtx = this.getTransaction();
        ObjIdSet ids = jtx.cascadeFindAll(id, cascadeName, recursionLimit);
        CopyState copyState = clone ? new CopyState(dest.createClones(ids)) : new CopyState();
        jtx.copyTo(dest, copyState, ids);
        return dest.get(copyState.getDestinationId(id));
    }

    default public JObject cascadeCopyOut(String cascadeName, boolean clone) {
        return this.cascadeCopyTo(this.getTransaction().getSnapshotTransaction(), cascadeName, clone);
    }

    default public JObject cascadeCopyIn(String cascadeName, boolean clone) {
        return this.cascadeCopyTo(JTransaction.getCurrent(), cascadeName, clone);
    }

    public void resetCachedFieldValues();

    default public <R> NavigableSet<R> findReferring(Class<R> type, String fieldName) {
        NavigableSet set = (NavigableSet)this.getTransaction().queryIndex(type, fieldName, Object.class).asMap().get(this);
        return set != null ? set : NavigableSets.empty();
    }

    default public JClass<?> getJClass() {
        return this.getTransaction().getJSimpleDB().getJClass(this.getObjId());
    }

    public Class<?> getModelClass();
}

