/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.UntypedJObject;
import org.jsimpledb.asm.ClassWriter;
import org.jsimpledb.asm.Label;
import org.jsimpledb.asm.MethodVisitor;
import org.jsimpledb.asm.Type;
import org.jsimpledb.core.DeleteAction;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.type.ReferenceFieldType;
import org.jsimpledb.schema.ReferenceSchemaField;
import org.jsimpledb.schema.SimpleSchemaField;

public class JReferenceField
extends JSimpleField {
    final DeleteAction onDelete;
    final boolean cascadeDelete;
    final boolean allowDeleted;
    final boolean allowDeletedSnapshot;
    final String[] forwardCascades;
    final String[] inverseCascades;

    JReferenceField(JSimpleDB jdb, String name, int storageId, String description, TypeToken<?> typeToken, org.jsimpledb.annotation.JField annotation, Method getter, Method setter) {
        super(jdb, name, storageId, typeToken, (FieldType<?>)new ReferenceFieldType(), true, annotation, description, getter, setter);
        this.onDelete = annotation.onDelete();
        this.cascadeDelete = annotation.cascadeDelete();
        this.allowDeleted = annotation.allowDeleted();
        this.allowDeletedSnapshot = annotation.allowDeletedSnapshot();
        this.forwardCascades = annotation.cascades();
        this.inverseCascades = annotation.inverseCascades();
    }

    @Override
    public JObject getValue(JObject jobj) {
        return (JObject)super.getValue(jobj);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJReferenceField(this);
    }

    public Converter<ObjId, JObject> getConverter(JTransaction jtx) {
        return jtx.referenceConverter.reverse();
    }

    public DeleteAction getOnDelete() {
        return this.onDelete;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public boolean isAllowDeleted() {
        return this.allowDeleted;
    }

    public boolean isAllowDeletedSnapshot() {
        return this.allowDeletedSnapshot;
    }

    public String[] getForwardCascades() {
        return (String[])this.forwardCascades.clone();
    }

    public String[] getInverseCascades() {
        return (String[])this.inverseCascades.clone();
    }

    @Override
    boolean isSameAs(JField that0) {
        if (!super.isSameAs(that0)) {
            return false;
        }
        JReferenceField that = (JReferenceField)that0;
        if (!this.onDelete.equals((Object)that.onDelete)) {
            return false;
        }
        if (this.cascadeDelete != that.cascadeDelete) {
            return false;
        }
        if (this.allowDeleted != that.allowDeleted) {
            return false;
        }
        if (this.allowDeletedSnapshot != that.allowDeletedSnapshot) {
            return false;
        }
        if (!new HashSet<String>(Arrays.asList(this.forwardCascades)).equals(new HashSet<String>(Arrays.asList(that.forwardCascades)))) {
            return false;
        }
        return new HashSet<String>(Arrays.asList(this.inverseCascades)).equals(new HashSet<String>(Arrays.asList(that.inverseCascades)));
    }

    ReferenceSchemaField toSchemaItem(JSimpleDB jdb) {
        ReferenceSchemaField schemaField = new ReferenceSchemaField();
        super.initialize(jdb, (SimpleSchemaField)schemaField);
        schemaField.setOnDelete(this.onDelete);
        schemaField.setCascadeDelete(this.cascadeDelete);
        schemaField.setAllowDeleted(this.allowDeleted);
        schemaField.setAllowDeletedSnapshot(this.allowDeletedSnapshot);
        Class rawType = this.typeToken.getRawType();
        if (!rawType.isAssignableFrom(JObject.class)) {
            assert (!rawType.isAssignableFrom(UntypedJObject.class));
            if (UntypedJObject.class.isAssignableFrom(rawType)) {
                throw new RuntimeException("internal error: " + rawType);
            }
            schemaField.setObjectTypes((NavigableSet)jdb.getJClasses(rawType).stream().map(jclass -> jclass.storageId).collect(Collectors.toCollection(TreeSet::new)));
        }
        return schemaField;
    }

    @Override
    void outputMethods(ClassGenerator<?> generator, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(this.getter.getModifiers() & 5, this.getter.getName(), Type.getMethodDescriptor(this.getter), null, generator.getExceptionNames(this.getter));
        this.outputReadCoreValueBytecode(generator, mv);
        mv.visitInsn(89);
        Label label1 = new Label();
        mv.visitJumpInsn(199, label1);
        mv.visitInsn(87);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitLabel(label1);
        mv.visitFrame(4, 0, new Object[0], 1, new String[]{Type.getInternalName(Object.class)});
        mv.visitTypeInsn(192, Type.getInternalName(ObjId.class));
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$tx", Type.getDescriptor(JTransaction.class));
        mv.visitInsn(95);
        generator.emitInvoke(mv, ClassGenerator.JTRANSACTION_GET_METHOD);
        mv.visitTypeInsn(192, Type.getInternalName(this.getter.getReturnType()));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(this.setter.getModifiers() & 5, this.setter.getName(), Type.getMethodDescriptor(this.setter), null, generator.getExceptionNames(this.setter));
        mv.visitVarInsn(25, 1);
        Label label2 = new Label();
        Label label3 = new Label();
        mv.visitJumpInsn(199, label2);
        mv.visitInsn(1);
        mv.visitJumpInsn(167, label3);
        mv.visitLabel(label2);
        mv.visitFrame(3, 0, new Object[0], 0, new Object[0]);
        mv.visitVarInsn(25, 1);
        generator.emitInvoke(mv, ClassGenerator.JOBJECT_GET_OBJ_ID_METHOD);
        mv.visitLabel(label3);
        mv.visitFrame(4, 0, new Object[0], 1, new String[]{Type.getInternalName(ObjId.class)});
        this.outputWriteCoreValueBytecode(generator, mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

