/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.dellroad.stuff.util.LongMap;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.DefaultStorageIdGenerator;
import org.jsimpledb.IndexInfo;
import org.jsimpledb.IndexQueryInfo;
import org.jsimpledb.IndexQueryInfoKey;
import org.jsimpledb.JClass;
import org.jsimpledb.JCollectionField;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldSwitchAdapter;
import org.jsimpledb.JMapField;
import org.jsimpledb.JObject;
import org.jsimpledb.JReferenceField;
import org.jsimpledb.JSchemaObject;
import org.jsimpledb.JSimpleDBException;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.ReferencePath;
import org.jsimpledb.ReferencePathCache;
import org.jsimpledb.SimpleFieldIndexInfo;
import org.jsimpledb.SnapshotJTransaction;
import org.jsimpledb.StorageIdGenerator;
import org.jsimpledb.UntypedJObject;
import org.jsimpledb.Util;
import org.jsimpledb.ValidationMode;
import org.jsimpledb.annotation.JCompositeIndex;
import org.jsimpledb.annotation.JCompositeIndexes;
import org.jsimpledb.annotation.JSimpleClass;
import org.jsimpledb.core.Database;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.SnapshotTransaction;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.TypeNotInSchemaVersionException;
import org.jsimpledb.core.UnknownFieldException;
import org.jsimpledb.core.UnknownTypeException;
import org.jsimpledb.core.type.ReferenceFieldType;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.kv.simple.SimpleKVDatabase;
import org.jsimpledb.kv.util.NavigableMapKVStore;
import org.jsimpledb.schema.NameIndex;
import org.jsimpledb.schema.SchemaModel;
import org.jsimpledb.schema.SchemaObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSimpleDB {
    public static final String GENERATED_CLASS_NAME_SUFFIX = "$$JSimpleDB";
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final TreeMap<Integer, JClass<?>> jclasses = new TreeMap();
    final HashMap<Class<?>, JClass<?>> jclassesByType = new HashMap();
    final HashMap<Integer, IndexInfo> indexInfoMap = new HashMap();
    final LongMap<JField> typeFieldMap = new LongMap();
    final HashSet<Integer> fieldsRequiringDefaultValidation = new HashSet();
    final ReferencePathCache referencePathCache = new ReferencePathCache(this);
    final ClassGenerator<UntypedJObject> untypedClassGenerator;
    final ArrayList<ClassGenerator<?>> classGenerators;
    final ClassLoader loader;
    final Database db;
    final StorageIdGenerator storageIdGenerator;
    final HashMap<String, List<JReferenceField>> inverseCascadeMap = new HashMap();
    final boolean hasOnCreateMethods;
    final boolean hasOnDeleteMethods;
    final boolean hasOnVersionChangeMethods;
    final boolean hasUpgradeConversions;
    final boolean anyJClassRequiresDefaultValidation;
    final AnnotatedElement elementRequiringJSR303Validation;
    final Transaction.ListenerSet[] listenerSets = new Transaction.ListenerSet[4];
    ValidatorFactory validatorFactory;
    volatile int configuredVersion;
    volatile int actualVersion;
    private final LoadingCache<IndexQueryInfoKey, IndexQueryInfo> indexQueryInfoCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<IndexQueryInfoKey, IndexQueryInfo>(){

        public IndexQueryInfo load(IndexQueryInfoKey key) {
            return key.getIndexQueryInfo(JSimpleDB.this);
        }
    });
    private SchemaModel schemaModel;
    private NameIndex nameIndex;

    public JSimpleDB(Iterable<? extends Class<?>> classes) {
        this(new Database((KVDatabase)new SimpleKVDatabase()), -1, new DefaultStorageIdGenerator(), classes);
    }

    public JSimpleDB(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    /*
     * WARNING - void declaration
     */
    public JSimpleDB(Database database, int version, StorageIdGenerator storageIdGenerator, Iterable<? extends Class<?>> classes) {
        int n;
        int n2;
        int n3;
        JComplexField parentField;
        Object annotation;
        Preconditions.checkArgument((database != null ? 1 : 0) != 0, (Object)"null database");
        Preconditions.checkArgument((version >= -1 ? 1 : 0) != 0, (Object)"invalid schema version");
        Preconditions.checkArgument((classes != null ? 1 : 0) != 0, (Object)"null classes");
        this.db = database;
        this.storageIdGenerator = storageIdGenerator;
        this.loader = AccessController.doPrivileged(new PrivilegedAction<Loader>(){

            @Override
            public Loader run() {
                return new Loader();
            }
        });
        HashSet<void> jsimpleClasses = new HashSet<void>();
        for (Class<?> clazz : classes) {
            void var7_9;
            Class clazz2;
            Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"null class found in classes");
            do {
                if ((annotation = Util.getAnnotation((AnnotatedElement)var7_9, JSimpleClass.class)) == null) continue;
                if (var7_9.isPrimitive() || var7_9.isArray()) {
                    throw new IllegalArgumentException("illegal type " + var7_9 + " for @" + JSimpleClass.class.getSimpleName() + " annotation: not a normal class or interface");
                }
                jsimpleClasses.add(var7_9);
            } while ((clazz2 = var7_9.getSuperclass()) != null);
        }
        for (Class<Object> clazz : jsimpleClasses) {
            void jclass2;
            int n4;
            String string;
            annotation = Util.getAnnotation(clazz, JSimpleClass.class);
            String string2 = string = annotation.name().length() != 0 ? annotation.name() : clazz.getSimpleName();
            if (this.log.isTraceEnabled()) {
                this.log.trace("found @" + JSimpleClass.class.getSimpleName() + " annotation on " + clazz + " defining object type `" + string + "'");
            }
            if ((n4 = annotation.storageId()) == 0) {
                n4 = this.getStorageIdGenerator((Annotation)annotation, clazz).generateClassStorageId(clazz, string);
            }
            try {
                JClass<Object> jclass22 = this.createJClass(string, n4, clazz);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid @" + JSimpleClass.class.getSimpleName() + " annotation on " + clazz + ": " + e, e);
            }
            this.addJClass((JClass<?>)jclass2);
            this.log.debug("added Java model class `" + jclass2.name + "' with storage ID " + jclass2.storageId);
        }
        this.classGenerators = this.jclasses.values().stream().map(jclass -> jclass.classGenerator).collect(Collectors.toCollection(ArrayList::new));
        this.untypedClassGenerator = new ClassGenerator<UntypedJObject>(this, UntypedJObject.class);
        this.classGenerators.add(this.untypedClassGenerator);
        for (JClass jClass : this.jclasses.values()) {
            jClass.createFields(this);
        }
        for (JClass jClass : this.jclasses.values()) {
            for (Class clazz : TypeToken.of(jClass.type).getTypes().rawTypes()) {
                void var10_43;
                JCompositeIndexes container = Util.getAnnotation(clazz, JCompositeIndexes.class);
                if (container != null) {
                    JCompositeIndex[] jCompositeIndexArray = container.value();
                } else {
                    JCompositeIndex annotation2 = Util.getAnnotation(clazz, JCompositeIndex.class);
                    if (annotation2 == null) continue;
                    JCompositeIndex[] jCompositeIndexArray = new JCompositeIndex[]{annotation2};
                }
                for (JCompositeIndex annotation3 : var10_43) {
                    if (annotation3.uniqueExclude().length > 0 && !annotation3.unique()) {
                        throw new IllegalArgumentException("invalid @JCompositeIndex annotation on " + clazz + ": use of uniqueExclude() requires unique = true");
                    }
                    jClass.addCompositeIndex(this, clazz, annotation3);
                }
            }
        }
        for (JClass jClass : this.jclasses.values()) {
            for (JField jField : jClass.jfields.values()) {
                if (!jField.requiresDefaultValidation) continue;
                this.fieldsRequiringDefaultValidation.add(jField.storageId);
            }
        }
        HashMap<Integer, String> descriptionMap = new HashMap<Integer, String>();
        for (JClass<?> jclass4 : this.jclasses.values()) {
            for (JField jField : jclass4.jfields.values()) {
                if (jField instanceof JSimpleField) {
                    JSimpleField simpleField = (JSimpleField)jField;
                    if (!simpleField.indexed) continue;
                    this.addIndexInfo(simpleField, descriptionMap);
                    continue;
                }
                if (!(jField instanceof JComplexField)) continue;
                parentField = (JComplexField)jField;
                for (JSimpleField subField : parentField.getSubFields()) {
                    if (!subField.indexed) continue;
                    this.addIndexInfo(subField, descriptionMap);
                }
            }
            for (org.jsimpledb.JCompositeIndex jCompositeIndex : jclass4.jcompositeIndexes.values()) {
                this.addIndexInfo(jCompositeIndex, descriptionMap);
            }
        }
        for (JClass<?> jclass3 : this.jclasses.values()) {
            for (JField jField : jclass3.jfields.values()) {
                this.typeFieldMap.put(this.getTypeFieldKey(jclass3.storageId, jField.storageId), (Object)jField);
                if (!(jField instanceof JComplexField)) continue;
                parentField = (JComplexField)jField;
                for (JSimpleField subField : parentField.getSubFields()) {
                    this.typeFieldMap.put(this.getTypeFieldKey(jclass3.storageId, subField.storageId), (Object)subField);
                }
            }
        }
        Iterator<JClass<?>> iterator = this.jclasses.values().iterator();
        while (iterator.hasNext()) {
            JClass<?> jclass0;
            final JClass<?> jClass = jclass0 = iterator.next();
            for (JField jfield : jClass.jfields.values()) {
                jfield.visit(new JFieldSwitchAdapter<Void>(){

                    @Override
                    public Void caseJReferenceField(JReferenceField field) {
                        for (String cascadeName : field.forwardCascades) {
                            this.addCascade(jClass.forwardCascadeMap, cascadeName, field);
                        }
                        for (String cascadeName : field.inverseCascades) {
                            this.addCascade(JSimpleDB.this.inverseCascadeMap, cascadeName, field);
                        }
                        return null;
                    }

                    @Override
                    public Void caseJMapField(JMapField field) {
                        if (field.getKeyField() instanceof JReferenceField) {
                            this.caseJReferenceField((JReferenceField)field.getKeyField());
                        }
                        if (field.getValueField() instanceof JReferenceField) {
                            this.caseJReferenceField((JReferenceField)field.getValueField());
                        }
                        return null;
                    }

                    @Override
                    protected Void caseJCollectionField(JCollectionField field) {
                        if (field.getElementField() instanceof JReferenceField) {
                            this.caseJReferenceField((JReferenceField)field.getElementField());
                        }
                        return null;
                    }

                    @Override
                    protected Void caseJField(JField field) {
                        return null;
                    }

                    private void addCascade(Map<String, List<JReferenceField>> map, String cascadeName, JReferenceField field) {
                        if (cascadeName != null) {
                            map.computeIfAbsent(cascadeName, s -> new ArrayList()).add(field);
                        }
                    }
                });
            }
        }
        this.jclasses.values().forEach(JClass::scanAnnotations);
        this.jclasses.values().forEach(JClass::calculateValidationRequirement);
        boolean bl = false;
        AnnotatedElement someElementRequiringJSR303Validation = null;
        for (JClass<?> jClass : this.jclasses.values()) {
            n3 |= jClass.requiresDefaultValidation;
            if (someElementRequiringJSR303Validation != null) continue;
            someElementRequiringJSR303Validation = jClass.elementRequiringJSR303Validation;
        }
        this.anyJClassRequiresDefaultValidation = n3;
        this.elementRequiringJSR303Validation = someElementRequiringJSR303Validation;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean anyOnVersionChangeMethods = false;
        boolean anyUpgradeConversions = false;
        for (JClass<?> jclass7 : this.jclasses.values()) {
            n2 |= !jclass7.onCreateMethods.isEmpty() ? 1 : 0;
            n |= !jclass7.onDeleteMethods.isEmpty() ? 1 : 0;
            anyOnVersionChangeMethods |= !jclass7.onVersionChangeMethods.isEmpty();
            anyUpgradeConversions |= !jclass7.upgradeConversionFields.isEmpty();
        }
        this.hasOnCreateMethods = n2;
        this.hasOnDeleteMethods = n;
        this.hasOnVersionChangeMethods = anyOnVersionChangeMethods;
        this.hasUpgradeConversions = anyUpgradeConversions;
        this.db.validateSchema(this.getSchemaModel());
        this.configuredVersion = version == -1 ? this.schemaModel.autogenerateVersion() : version;
        this.untypedClassGenerator.generateClass();
        for (JClass<?> jclass8 : this.jclasses.values()) {
            jclass8.getClassGenerator().generateClass();
        }
    }

    private <T> JClass<T> createJClass(String name, int storageId, Class<T> type) {
        return new JClass<T>(this, name, storageId, type);
    }

    StorageIdGenerator getStorageIdGenerator(Annotation annotation, AnnotatedElement target) {
        if (this.storageIdGenerator == null) {
            throw new IllegalArgumentException("invalid @" + annotation.annotationType().getSimpleName() + " annotation on " + target + ": no storage ID is given, but storage ID auto-generation is disabled because no " + StorageIdGenerator.class.getSimpleName() + " is configured");
        }
        return this.storageIdGenerator;
    }

    public Database getDatabase() {
        return this.db;
    }

    public int getConfiguredVersion() {
        return this.configuredVersion;
    }

    public void setConfiguredVersion(int version) {
        Preconditions.checkArgument((version >= -1 ? 1 : 0) != 0, (Object)"invalid schema version");
        this.configuredVersion = version == -1 ? this.schemaModel.autogenerateVersion() : version;
    }

    public int getActualVersion() {
        return this.actualVersion;
    }

    @Deprecated
    public static Class<?> getModelClass(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return jobj.getModelClass();
    }

    public JTransaction createTransaction() {
        return this.createTransaction(true, ValidationMode.AUTOMATIC, null);
    }

    public JTransaction createTransaction(boolean allowNewSchema, ValidationMode validationMode) {
        return this.createTransaction(allowNewSchema, validationMode, null);
    }

    public JTransaction createTransaction(boolean allowNewSchema, ValidationMode validationMode, Map<String, ?> kvoptions) {
        return this.createTransaction(this.db.createTransaction(this.getSchemaModel(), this.configuredVersion, allowNewSchema, kvoptions), validationMode);
    }

    public JTransaction createTransaction(KVTransaction kvt, boolean allowNewSchema, ValidationMode validationMode) {
        return this.createTransaction(this.db.createTransaction(kvt, this.getSchemaModel(), this.configuredVersion, allowNewSchema), validationMode);
    }

    private JTransaction createTransaction(Transaction tx, ValidationMode validationMode) {
        assert (tx != null);
        Preconditions.checkArgument((validationMode != null ? 1 : 0) != 0, (Object)"null validationMode");
        this.actualVersion = tx.getSchema().getVersionNumber();
        JTransaction jtx = new JTransaction(this, tx, validationMode);
        tx.addCallback((Transaction.Callback)new CleanupCurrentCallback(jtx));
        return jtx;
    }

    public SnapshotJTransaction createSnapshotTransaction(ValidationMode validationMode) {
        return this.createSnapshotTransaction((KVStore)new NavigableMapKVStore(), true, validationMode);
    }

    public SnapshotJTransaction createSnapshotTransaction(KVStore kvstore, boolean allowNewSchema, ValidationMode validationMode) {
        SnapshotTransaction stx = this.db.createSnapshotTransaction(kvstore, this.getSchemaModel(), this.configuredVersion, allowNewSchema);
        return new SnapshotJTransaction(this, stx, validationMode);
    }

    public SchemaModel getSchemaModel() {
        if (this.schemaModel == null) {
            SchemaModel model = new SchemaModel();
            for (JClass<?> jclass : this.jclasses.values()) {
                SchemaObjectType schemaObjectType = jclass.toSchemaItem(this);
                model.getSchemaObjectTypes().put(schemaObjectType.getStorageId(), schemaObjectType);
            }
            this.schemaModel = model;
            this.schemaModel.lockDown();
            this.log.debug("JSimpleDB schema generated from annotated classes:\n{}", (Object)this.schemaModel);
        }
        return this.schemaModel;
    }

    public NameIndex getNameIndex() {
        if (this.nameIndex == null) {
            this.nameIndex = new NameIndex(this.getSchemaModel());
        }
        return this.nameIndex;
    }

    public SortedMap<Integer, JClass<?>> getJClasses() {
        return Collections.unmodifiableSortedMap(this.jclasses);
    }

    public Map<Class<?>, JClass<?>> getJClassesByType() {
        return Collections.unmodifiableMap(this.jclassesByType);
    }

    public <T> JClass<T> getJClass(Class<T> type) {
        JClass<?> jclass = this.jclassesByType.get(type);
        if (jclass == null) {
            throw new IllegalArgumentException("java model type is not recognized: " + type);
        }
        return jclass;
    }

    public <T> JClass<? super T> findJClass(Class<T> type) {
        for (Class<T> superType = type; superType != null; superType = superType.getSuperclass()) {
            JClass<?> jclass = this.jclassesByType.get(superType);
            if (jclass == null) continue;
            return jclass;
        }
        return null;
    }

    public JClass<?> getJClass(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        JClass<?> jclass = this.jclasses.get(id.getStorageId());
        if (jclass == null) {
            throw new TypeNotInSchemaVersionException(id, this.actualVersion);
        }
        return jclass;
    }

    public JClass<?> getJClass(int storageId) {
        JClass<?> jclass = this.jclasses.get(storageId);
        if (jclass == null) {
            throw new UnknownTypeException(storageId, this.actualVersion);
        }
        return jclass;
    }

    public <T> List<JClass<? extends T>> getJClasses(Class<T> type) {
        return this.jclasses.values().stream().filter(jclass -> type == null || type.isAssignableFrom(jclass.type)).map(jclass -> jclass).collect(Collectors.toList());
    }

    <T extends JField> T getJField(ObjId id, int storageId, Class<T> type) {
        JField jfield = (JField)this.typeFieldMap.get(this.getTypeFieldKey(id.getStorageId(), storageId));
        if (jfield == null) {
            this.getJClass(id.getStorageId()).getJField(storageId, type);
            assert (false);
        }
        try {
            return (T)((JField)type.cast(jfield));
        }
        catch (ClassCastException e) {
            throw new UnknownFieldException(storageId, jfield + "' is not a " + type.getSimpleName().replaceAll("^J(.*)Field$", "").toLowerCase() + " field");
        }
    }

    private long getTypeFieldKey(int typeStorageId, int fieldStorageId) {
        return (long)typeStorageId << 32 | (long)fieldStorageId & 0xFFFFFFFFL;
    }

    KeyRanges keyRangesFor(Class<?> type) {
        if (type == null) {
            return KeyRanges.full();
        }
        ArrayList list = new ArrayList(this.jclasses.size());
        boolean invert = false;
        if (type == UntypedJObject.class) {
            type = null;
            invert = true;
        }
        this.getJClasses(type).stream().map(jclass -> ObjId.getKeyRange((int)jclass.storageId)).forEach(list::add);
        KeyRanges keyRanges = new KeyRanges(list);
        return invert ? keyRanges.inverse() : keyRanges;
    }

    public ReferencePath parseReferencePath(Class<?> startType, String path) {
        return this.parseReferencePath(startType, path, true);
    }

    public ReferencePath parseReferencePath(Class<?> startType, String path, boolean expectTargetField) {
        return this.parseReferencePath(startType, path, expectTargetField, null);
    }

    ReferencePath parseReferencePath(Class<?> startType, String path, boolean expectTargetField, Boolean lastIsSubField) {
        return this.referencePathCache.get(startType, path, expectTargetField, lastIsSubField);
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        Preconditions.checkArgument((validatorFactory != null ? 1 : 0) != 0, (Object)"null validatorFactory");
        this.validatorFactory = validatorFactory;
    }

    ValidatorFactory getValidatorFactory() {
        if (this.validatorFactory != null) {
            return this.validatorFactory;
        }
        if (this.elementRequiringJSR303Validation == null) {
            return null;
        }
        try {
            this.validatorFactory = Validation.buildDefaultValidatorFactory();
        }
        catch (Exception e) {
            throw new JSimpleDBException("JSR 303 validation constraint found on " + this.elementRequiringJSR303Validation + " but creation of default ValidatorFactory failed; is there a JSR 303 validation implementation on the classpath?", e);
        }
        return this.validatorFactory;
    }

    public Iterable<JObject> getReferencedObjects(final JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        ObjId id = jobj.getObjId();
        final ArrayList iterables = new ArrayList();
        for (JField jfield : this.getJClass(id).getJFieldsByStorageId().values()) {
            jfield.visit(new JFieldSwitchAdapter<Void>(){

                @Override
                public Void caseJReferenceField(JReferenceField field) {
                    JObject ref = field.getValue(jobj);
                    if (ref != null) {
                        iterables.add(Collections.singleton(ref));
                    }
                    return null;
                }

                @Override
                public Void caseJMapField(JMapField field) {
                    if (field.getKeyField() instanceof JReferenceField) {
                        iterables.add(Iterables.filter(field.getValue(jobj).keySet(), JObject.class));
                    }
                    if (field.getValueField() instanceof JReferenceField) {
                        iterables.add(Iterables.filter(field.getValue(jobj).values(), JObject.class));
                    }
                    return null;
                }

                @Override
                protected Void caseJCollectionField(JCollectionField field) {
                    if (field.getElementField() instanceof JReferenceField) {
                        iterables.add(Iterables.filter((Iterable)field.getValue(jobj), JObject.class));
                    }
                    return null;
                }

                @Override
                protected Void caseJField(JField field) {
                    return null;
                }
            });
        }
        return Iterables.concat(iterables);
    }

    IndexQueryInfo getIndexQueryInfo(IndexQueryInfoKey key) {
        try {
            return (IndexQueryInfo)this.indexQueryInfoCache.getUnchecked((Object)key);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw e;
        }
    }

    ClassGenerator<UntypedJObject> getUntypedClassGenerator() {
        return this.untypedClassGenerator;
    }

    boolean isReferenceField(int storageId) {
        IndexInfo info = this.indexInfoMap.get(storageId);
        return info instanceof SimpleFieldIndexInfo && ((SimpleFieldIndexInfo)info).getFieldType() instanceof ReferenceFieldType;
    }

    <T extends IndexInfo> T getIndexInfo(int storageId, Class<? extends T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        IndexInfo indexInfo = this.indexInfoMap.get(storageId);
        if (indexInfo == null) {
            throw new IllegalArgumentException("no " + this.describe(type) + " with storage ID " + storageId + " exists in schema version " + this.actualVersion);
        }
        try {
            return (T)((IndexInfo)type.cast(indexInfo));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("no " + this.describe(type) + " with storage ID " + storageId + " exists in schema version " + this.actualVersion + " (found field " + this.describe(type) + " instead)");
        }
    }

    private void addJClass(JClass<?> jclass) {
        JClass<?> other = this.jclasses.get(jclass.storageId);
        if (other != null) {
            throw new IllegalArgumentException("illegal duplicate use of storage ID " + jclass.storageId + " for both " + other + " and " + jclass);
        }
        this.jclasses.put(jclass.storageId, jclass);
        assert (!this.jclassesByType.containsKey(jclass.type));
        this.jclassesByType.put(jclass.type, jclass);
    }

    private void addIndexInfo(JSchemaObject item, Map<Integer, String> descriptionMap) {
        IndexInfo info = item.toIndexInfo();
        int storageId = info.storageId;
        IndexInfo existing = this.indexInfoMap.get(storageId);
        if (existing == null) {
            this.indexInfoMap.put(storageId, info);
            descriptionMap.put(storageId, item.description);
        } else if (!info.equals(existing)) {
            throw new IllegalArgumentException("incompatible duplicate use of storage ID " + item.storageId + " for " + descriptionMap.get(storageId) + " and " + item.description);
        }
    }

    private String describe(Class<? extends IndexInfo> type) {
        return type.getSimpleName().replaceAll("^(.*Index)Info$", "$1").replaceAll("([a-z])([A-Z])", "$1 $2").toLowerCase();
    }

    private static final class CleanupCurrentCallback
    extends Transaction.CallbackAdapter {
        private final JTransaction jtx;

        CleanupCurrentCallback(JTransaction jtx) {
            assert (jtx != null);
            this.jtx = jtx;
        }

        public void afterCompletion(boolean committed) {
            JTransaction current;
            try {
                current = JTransaction.getCurrent();
            }
            catch (IllegalStateException e) {
                return;
            }
            if (current == this.jtx) {
                JTransaction.setCurrent(null);
            }
        }

        public int hashCode() {
            return this.jtx.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            CleanupCurrentCallback that = (CleanupCurrentCallback)((Object)obj);
            return this.jtx.equals(that.jtx);
        }
    }

    private class Loader
    extends ClassLoader {
        Loader() {
            super(Thread.currentThread().getContextClassLoader());
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytes = null;
            for (ClassGenerator<?> generator : JSimpleDB.this.classGenerators) {
                if (!name.equals(generator.getClassName().replace('/', '.'))) continue;
                bytes = generator.generateBytecode();
                break;
            }
            return bytes != null ? this.defineClass(name, bytes, 0, bytes.length) : super.findClass(name);
        }
    }
}

