/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.validation.groups.Default;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.dellroad.stuff.validation.ValidationContext;
import org.dellroad.stuff.validation.ValidationUtil;
import org.jsimpledb.AllChangesListener;
import org.jsimpledb.ComplexSubFieldIndexInfo;
import org.jsimpledb.CompositeIndexInfo;
import org.jsimpledb.ConvertedIndex;
import org.jsimpledb.ConvertedIndex2;
import org.jsimpledb.ConvertedIndex3;
import org.jsimpledb.ConvertedIndex4;
import org.jsimpledb.CopyState;
import org.jsimpledb.Counter;
import org.jsimpledb.DeletedAssignment;
import org.jsimpledb.IndexInfo;
import org.jsimpledb.IndexQueryInfo;
import org.jsimpledb.IndexQueryInfoKey;
import org.jsimpledb.JClass;
import org.jsimpledb.JCompositeIndex;
import org.jsimpledb.JCounterField;
import org.jsimpledb.JField;
import org.jsimpledb.JListField;
import org.jsimpledb.JMapField;
import org.jsimpledb.JObject;
import org.jsimpledb.JObjectCache;
import org.jsimpledb.JReferenceField;
import org.jsimpledb.JSetField;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.ListConverter;
import org.jsimpledb.ListElementIndexInfo;
import org.jsimpledb.MapValueIndexInfo;
import org.jsimpledb.NavigableMapConverter;
import org.jsimpledb.NavigableSetConverter;
import org.jsimpledb.OnChangeScanner;
import org.jsimpledb.OnVersionChangeScanner;
import org.jsimpledb.ReferenceConverter;
import org.jsimpledb.ReferencePath;
import org.jsimpledb.SimpleFieldIndexInfo;
import org.jsimpledb.SnapshotJTransaction;
import org.jsimpledb.UniquenessConstraints;
import org.jsimpledb.UpgradeConversionException;
import org.jsimpledb.UpgradeConversionPolicy;
import org.jsimpledb.Util;
import org.jsimpledb.ValidationException;
import org.jsimpledb.ValidationMode;
import org.jsimpledb.annotation.OnChange;
import org.jsimpledb.annotation.OnCreate;
import org.jsimpledb.annotation.OnDelete;
import org.jsimpledb.annotation.OnValidate;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.CoreIndex2;
import org.jsimpledb.core.CoreIndex3;
import org.jsimpledb.core.CoreIndex4;
import org.jsimpledb.core.CounterField;
import org.jsimpledb.core.CreateListener;
import org.jsimpledb.core.DeleteListener;
import org.jsimpledb.core.DeletedObjectException;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.FieldSwitch;
import org.jsimpledb.core.FieldSwitchAdapter;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.ListField;
import org.jsimpledb.core.MapField;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.ReferenceField;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.SetField;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.StaleTransactionException;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.TypeNotInSchemaVersionException;
import org.jsimpledb.core.UnknownFieldException;
import org.jsimpledb.core.VersionChangeListener;
import org.jsimpledb.core.type.ReferenceFieldType;
import org.jsimpledb.core.util.ObjIdMap;
import org.jsimpledb.core.util.ObjIdSet;
import org.jsimpledb.index.Index;
import org.jsimpledb.index.Index2;
import org.jsimpledb.index.Index3;
import org.jsimpledb.index.Index4;
import org.jsimpledb.kv.KVDatabaseException;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.kv.util.AbstractKVNavigableSet;
import org.jsimpledb.tuple.Tuple2;
import org.jsimpledb.tuple.Tuple3;
import org.jsimpledb.tuple.Tuple4;
import org.jsimpledb.util.CloseableIterator;
import org.jsimpledb.util.ConvertedNavigableMap;
import org.jsimpledb.util.ConvertedNavigableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class JTransaction {
    private static final ThreadLocal<JTransaction> CURRENT = new ThreadLocal();
    private static final Class<?>[] DEFAULT_CLASS_ARRAY = new Class[]{Default.class};
    private static final Class<?>[] DEFAULT_AND_UNIQUENESS_CLASS_ARRAY = new Class[]{Default.class, UniquenessConstraints.class};
    private static final int MAX_UNIQUE_CONFLICTORS = 5;
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final JSimpleDB jdb;
    final Transaction tx;
    final ReferenceConverter<JObject> referenceConverter = new ReferenceConverter<JObject>(this, JObject.class);
    private final ValidationMode validationMode;
    @GuardedBy(value="this")
    private final ObjIdMap<Class<?>[]> validationQueue = new ObjIdMap();
    private final JObjectCache jobjectCache = new JObjectCache(this);
    @GuardedBy(value="this")
    private SnapshotJTransaction snapshotTransaction;
    @GuardedBy(value="this")
    private boolean commitInvoked;

    JTransaction(JSimpleDB jdb, Transaction tx, ValidationMode validationMode) {
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        Preconditions.checkArgument((validationMode != null ? 1 : 0) != 0, (Object)"null validationMode");
        this.jdb = jdb;
        this.tx = tx;
        this.validationMode = validationMode;
        tx.setUserObject((Object)this);
        boolean automaticValidation = validationMode == ValidationMode.AUTOMATIC;
        boolean isSnapshot = this.isSnapshot();
        int listenerSetIndex = (automaticValidation ? 2 : 0) + (isSnapshot ? 0 : 1);
        Transaction.ListenerSet listenerSet = jdb.listenerSets[listenerSetIndex];
        if (listenerSet == null) {
            JTransaction.registerListeners(jdb, tx, automaticValidation, isSnapshot);
            jdb.listenerSets[listenerSetIndex] = tx.snapshotListeners();
        } else {
            tx.setListeners(listenerSet);
        }
    }

    private static void registerListeners(JSimpleDB jdb, Transaction tx, boolean automaticValidation, boolean isSnapshot) {
        if (jdb.hasOnCreateMethods || automaticValidation && jdb.anyJClassRequiresDefaultValidation) {
            tx.addCreateListener((CreateListener)new InternalCreateListener());
        }
        if (jdb.hasOnDeleteMethods) {
            tx.addDeleteListener((DeleteListener)new InternalDeleteListener());
        }
        for (JClass<?> jclass : jdb.jclasses.values()) {
            for (MethodAnnotationScanner.MethodInfo info : jclass.onChangeMethods) {
                if (isSnapshot && !((OnChange)info.getAnnotation()).snapshotTransactions()) continue;
                OnChangeScanner.ChangeMethodInfo changeInfo = (OnChangeScanner.ChangeMethodInfo)info;
                changeInfo.registerChangeListener(tx);
            }
        }
        if (automaticValidation) {
            DefaultValidationListener defaultValidationListener = new DefaultValidationListener();
            jdb.fieldsRequiringDefaultValidation.forEach(storageId -> tx.addFieldChangeListener(storageId.intValue(), new int[0], null, (Object)defaultValidationListener));
        }
        if (jdb.hasOnVersionChangeMethods || jdb.hasUpgradeConversions || automaticValidation && jdb.anyJClassRequiresDefaultValidation) {
            tx.addVersionChangeListener((VersionChangeListener)new InternalVersionChangeListener());
        }
    }

    public static JTransaction getCurrent() {
        JTransaction jtx = CURRENT.get();
        if (jtx == null) {
            throw new IllegalStateException("there is no " + JTransaction.class.getSimpleName() + " associated with the current thread");
        }
        return jtx;
    }

    public static void setCurrent(JTransaction jtx) {
        CURRENT.set(jtx);
    }

    public JSimpleDB getJSimpleDB() {
        return this.jdb;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public <T> NavigableSet<T> getAll(Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        NavigableSet ids = this.tx.getAll();
        KeyRanges keyRanges = this.jdb.keyRangesFor(type);
        if (!keyRanges.isFull()) {
            ids = ((AbstractKVNavigableSet)ids).filterKeys((KeyFilter)keyRanges);
        }
        return new ConvertedNavigableSet(ids, new ReferenceConverter<T>(this, type));
    }

    public <T> NavigableMap<Integer, NavigableSet<T>> queryVersion(Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        CoreIndex index = this.tx.queryVersion();
        KeyRanges keyRanges = this.jdb.keyRangesFor(type);
        if (!keyRanges.isFull()) {
            index = index.filter(1, (KeyFilter)keyRanges);
        }
        return new ConvertedNavigableMap(index.asMap(), Converter.identity(), new NavigableSetConverter(new ReferenceConverter<T>(this, type)));
    }

    public byte[] getKey(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return this.tx.getKey(jobj.getObjId());
    }

    public byte[] getKey(JObject jobj, String fieldName) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        Class type = this.jdb.getJClass((ObjId)jobj.getObjId()).type;
        ReferencePath refPath = this.jdb.parseReferencePath(type, fieldName, true, false);
        if (refPath.getReferenceFields().length > 0) {
            throw new IllegalArgumentException("invalid field name `" + fieldName + "'");
        }
        assert (refPath.getTargetTypes().iterator().next().isInstance(jobj));
        return this.tx.getKey(jobj.getObjId(), refPath.targetFieldStorageId);
    }

    public boolean isSnapshot() {
        return false;
    }

    public synchronized SnapshotJTransaction getSnapshotTransaction() {
        Preconditions.checkArgument((!this.isSnapshot() ? 1 : 0) != 0, (Object)"getSnapshotTransaction() invoked on a snapshot transaction; use createSnapshotTransaction() instead");
        if (this.snapshotTransaction == null) {
            this.snapshotTransaction = this.createSnapshotTransaction(ValidationMode.MANUAL);
        }
        return this.snapshotTransaction;
    }

    public SnapshotJTransaction createSnapshotTransaction(ValidationMode validationMode) {
        return new SnapshotJTransaction(this.jdb, this.tx.createSnapshotTransaction(), validationMode);
    }

    public JObject copyTo(JTransaction dest, JObject jobj, CopyState copyState, String ... refPaths) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        Preconditions.checkArgument((copyState != null ? 1 : 0) != 0, (Object)"null copyState");
        Preconditions.checkArgument((refPaths != null ? 1 : 0) != 0, (Object)"null refPaths");
        JTransaction.registerJObject(jobj);
        ObjId id = jobj.getObjId();
        Class startType = this.jdb.getJClass((ObjId)id).type;
        ArrayList<int[]> pathReferencesList = new ArrayList<int[]>(refPaths.length);
        for (String refPath : refPaths) {
            Preconditions.checkArgument((refPath != null ? 1 : 0) != 0, (Object)"null refPath");
            ReferencePath path = this.jdb.parseReferencePath(startType, refPath, false, true);
            pathReferencesList.add(path.referenceFieldStorageIds);
        }
        copyState.deletedAssignments.clear();
        if (pathReferencesList.isEmpty()) {
            this.copyTo(copyState, dest, id, true, 0, new int[0]);
        }
        for (int[] pathReferences : pathReferencesList) {
            this.copyTo(copyState, dest, id, false, 0, pathReferences);
        }
        copyState.checkDeletedAssignments(this);
        return dest.get(copyState.getDestinationId(id));
    }

    public void copyTo(JTransaction dest, CopyState copyState, Iterable<? extends JObject> jobjs) {
        Preconditions.checkArgument((jobjs != null ? 1 : 0) != 0, (Object)"null jobjs");
        this.copyTo(dest, copyState, Streams.stream(jobjs));
    }

    public void copyTo(JTransaction dest, CopyState copyState, ObjIdSet ids) {
        Preconditions.checkArgument((ids != null ? 1 : 0) != 0, (Object)"null ids");
        this.copyIdStreamTo(dest, copyState, ids.stream());
    }

    public void copyTo(JTransaction dest, CopyState copyState, Stream<? extends JObject> jobjs) {
        this.copyIdStreamTo(dest, copyState, jobjs.filter(jobj -> jobj != null).peek(JTransaction::registerJObject).map(JObject::getObjId));
    }

    void copyIdStreamTo(JTransaction dest, CopyState copyState, Stream<ObjId> ids) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        Preconditions.checkArgument((copyState != null ? 1 : 0) != 0, (Object)"null copyState");
        Preconditions.checkArgument((ids != null ? 1 : 0) != 0, (Object)"null ids");
        copyState.deletedAssignments.clear();
        ids.forEachOrdered(id -> this.copyTo(copyState, dest, (ObjId)id, true, 0, new int[0]));
        copyState.checkDeletedAssignments(this);
    }

    void copyTo(CopyState copyState, JTransaction dest, ObjId srcId, boolean required, int fieldIndex, int[] fields) {
        int[] pathSuffix;
        if (copyState.markCopied(srcId)) {
            JObject dstObject;
            ObjId dstId = copyState.getDestinationId(srcId);
            boolean disableListenerNotifications = copyState.isSuppressNotifications();
            JClass<?> jclass = dest.jdb.jclasses.get(dstId.getStorageId());
            if (!disableListenerNotifications && dest.isSnapshot() && jclass != null) {
                boolean bl = disableListenerNotifications = !jclass.hasSnapshotCreateOrChangeMethods;
            }
            if ((dstObject = dest.jobjectCache.getIfExists(dstId)) != null) {
                dstObject.resetCachedFieldValues();
            }
            ObjIdMap coreDeletedAssignments = new ObjIdMap();
            boolean exists = true;
            try {
                this.tx.copy(srcId, dest.tx, true, !disableListenerNotifications, coreDeletedAssignments, copyState.getObjectIdMap());
            }
            catch (DeletedObjectException e) {
                if (required) {
                    throw e;
                }
                exists = false;
            }
            if (dest.validationMode.equals((Object)ValidationMode.AUTOMATIC) && jclass.requiresDefaultValidation) {
                dest.revalidate(Collections.singleton(dstId), new Class[0]);
            }
            for (Map.Entry entry : coreDeletedAssignments.entrySet()) {
                assert (!copyState.isCopied((ObjId)entry.getKey()));
                copyState.deletedAssignments.put((ObjId)entry.getKey(), (Object)new DeletedAssignment(dstId, (ReferenceField)entry.getValue()));
            }
            if (exists) {
                copyState.deletedAssignments.remove((Object)dstId);
            }
        }
        if (fieldIndex == fields.length) {
            return;
        }
        int[] nArray = pathSuffix = fieldIndex == 0 ? fields : Arrays.copyOfRange(fields, fieldIndex, fields.length);
        if (!copyState.markTraversed(srcId, pathSuffix)) {
            return;
        }
        int storageId = fields[fieldIndex++];
        SimpleFieldIndexInfo info = (SimpleFieldIndexInfo)this.jdb.indexInfoMap.get(storageId);
        assert (info == null || info.getFieldType() instanceof ReferenceFieldType);
        if (info instanceof ComplexSubFieldIndexInfo) {
            ComplexSubFieldIndexInfo subFieldInfo = (ComplexSubFieldIndexInfo)info;
            subFieldInfo.copyRecurse(copyState, this, dest, srcId, fieldIndex, fields);
        } else {
            ObjId referrent = (ObjId)this.tx.readSimpleField(srcId, storageId, false);
            if (referrent != null) {
                this.copyTo(copyState, dest, referrent, false, fieldIndex, fields);
            }
        }
    }

    public ObjIdMap<ObjId> createClones(ObjIdSet ids) {
        Preconditions.checkArgument((ids != null ? 1 : 0) != 0, (Object)"null ids");
        ObjIdMap map = new ObjIdMap(ids.size());
        for (ObjId id : ids) {
            map.put(id, (Object)this.tx.create(id.getStorageId()));
        }
        return map;
    }

    public ObjIdSet cascadeFindAll(ObjId id, String cascadeName, int recursionLimit) {
        ObjIdSet ids = new ObjIdSet();
        this.cascadeFindAll(id, cascadeName, recursionLimit, ids);
        return ids;
    }

    public void cascadeFindAll(ObjId id, String cascadeName, int recursionLimit, ObjIdSet visitedIds) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        Preconditions.checkArgument((recursionLimit >= -1 ? 1 : 0) != 0, (Object)"recursionLimit < -1");
        Preconditions.checkArgument((visitedIds != null ? 1 : 0) != 0, (Object)"null visitedIds");
        ObjIdSet toVisitIds = new ObjIdSet();
        if (visitedIds.add(id)) {
            toVisitIds.add(id);
        }
        if (cascadeName == null) {
            return;
        }
        while (!toVisitIds.isEmpty()) {
            assert (visitedIds.containsAll((Collection)toVisitIds));
            if (recursionLimit != -1 && recursionLimit-- <= 0) break;
            ObjIdSet newIds = new ObjIdSet();
            for (ObjId toVisitId : toVisitIds) {
                this.tx.updateSchemaVersion(toVisitId);
                this.gatherForwardCascadeRefs(toVisitId, cascadeName, visitedIds, newIds);
                this.gatherInverseCascadeRefs(toVisitId, cascadeName, visitedIds, newIds);
            }
            toVisitIds = newIds;
        }
    }

    private void gatherForwardCascadeRefs(ObjId id, String cascadeName, ObjIdSet visitedIds, ObjIdSet toVisitIds) {
        JClass<?> jclass = this.jdb.jclasses.get(id.getStorageId());
        if (jclass == null) {
            return;
        }
        List<JReferenceField> fieldList = jclass.forwardCascadeMap.get(cascadeName);
        if (fieldList == null) {
            return;
        }
        for (JReferenceField field : fieldList) {
            SimpleFieldIndexInfo info = (SimpleFieldIndexInfo)this.jdb.indexInfoMap.get(field.storageId);
            assert (info.getFieldType() instanceof ReferenceFieldType);
            if (info instanceof ComplexSubFieldIndexInfo) {
                ComplexSubFieldIndexInfo subFieldInfo = (ComplexSubFieldIndexInfo)info;
                this.gatherRefs(subFieldInfo.iterateReferences(this.tx, id).iterator(), visitedIds, toVisitIds);
                continue;
            }
            ObjId referrent = (ObjId)this.tx.readSimpleField(id, field.storageId, false);
            if (referrent == null || !visitedIds.add(referrent)) continue;
            toVisitIds.add(referrent);
        }
    }

    private void gatherInverseCascadeRefs(ObjId id, String cascadeName, ObjIdSet visitedIds, ObjIdSet toVisitIds) {
        List<JReferenceField> fieldList = this.jdb.inverseCascadeMap.get(cascadeName);
        if (fieldList == null) {
            return;
        }
        for (JReferenceField field : fieldList) {
            JClass<?> jclass = field.getJClass();
            CoreIndex index = this.tx.queryIndex(field.storageId);
            NavigableSet refs = (NavigableSet)(index = index.filter(1, (KeyFilter)new KeyRanges(ObjId.getKeyRange((int)jclass.storageId)))).asMap().get(id);
            if (refs == null) continue;
            this.gatherRefs(refs.iterator(), visitedIds, toVisitIds);
        }
    }

    private void gatherRefs(Iterator<?> i0, ObjIdSet visitedIds, ObjIdSet toVisitIds) {
        try (CloseableIterator i = CloseableIterator.wrap(i0);){
            while (i.hasNext()) {
                ObjId ref = (ObjId)i.next();
                if (ref == null || !visitedIds.add(ref)) continue;
                toVisitIds.add(ref);
            }
        }
    }

    public JObject get(ObjId id) {
        return this.jobjectCache.get(id);
    }

    public <T> T get(ObjId id, Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        return type.cast(this.get(id));
    }

    public <T extends JObject> T get(T jobj) {
        return (T)((JObject)jobj.getModelClass().cast(this.get(jobj.getObjId())));
    }

    public <T> T create(Class<T> type) {
        return this.create(this.jdb.getJClass(type));
    }

    public <T> T create(JClass<T> jclass) {
        ObjId id = this.tx.create(jclass.storageId);
        return jclass.getType().cast(this.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(JObject jobj) {
        JTransaction.registerJObject(jobj);
        ObjId id = jobj.getObjId();
        boolean deleted = this.tx.delete(id);
        if (deleted) {
            JTransaction jTransaction = this;
            synchronized (jTransaction) {
                this.validationQueue.remove((Object)id);
            }
        }
        if (deleted) {
            jobj.resetCachedFieldValues();
        }
        return deleted;
    }

    public boolean exists(ObjId id) {
        return this.tx.exists(id);
    }

    public boolean recreate(JObject jobj) {
        JTransaction.registerJObject(jobj);
        return this.tx.create(jobj.getObjId());
    }

    public void revalidate(ObjId id, Class<?> ... groups) {
        if (!this.tx.exists(id)) {
            throw new DeletedObjectException(this.tx, id);
        }
        this.revalidate(Collections.singleton(id), groups);
    }

    public synchronized void resetValidationQueue() {
        if (!this.tx.isValid()) {
            throw new StaleTransactionException(this.tx);
        }
        this.validationQueue.clear();
    }

    private synchronized void revalidate(Collection<? extends ObjId> ids, Class<?> ... groups) {
        if (!this.tx.isValid()) {
            throw new StaleTransactionException(this.tx);
        }
        Preconditions.checkArgument((groups != null ? 1 : 0) != 0, (Object)"null groups");
        for (Class<?> group : groups) {
            Preconditions.checkArgument((group != null ? 1 : 0) != 0, (Object)"null group");
        }
        if (this.validationMode == ValidationMode.DISABLED) {
            return;
        }
        if (groups.length == 0 || Arrays.equals(groups, DEFAULT_CLASS_ARRAY)) {
            groups = DEFAULT_CLASS_ARRAY;
        }
        for (ObjId objId : ids) {
            Class[] existingGroups = (Class[])this.validationQueue.get((Object)objId);
            if (existingGroups == null) {
                this.validationQueue.put(objId, groups);
                continue;
            }
            if (existingGroups == groups) continue;
            HashSet<Class> newGroups = new HashSet<Class>(Arrays.asList(existingGroups));
            newGroups.addAll(Arrays.asList(groups));
            this.validationQueue.put(objId, (Object)newGroups.toArray(new Class[newGroups.size()]));
        }
    }

    public int getSchemaVersion(ObjId id) {
        return this.tx.getSchemaVersion(id);
    }

    public boolean updateSchemaVersion(JObject jobj) {
        JTransaction.registerJObject(jobj);
        return this.tx.updateSchemaVersion(jobj.getObjId());
    }

    public static void registerJObject(JObject jobj) {
        jobj.getTransaction().jobjectCache.register(jobj);
    }

    public Object readSimpleField(ObjId id, int storageId, boolean updateVersion) {
        return this.convert(this.jdb.getJField(id, storageId, JSimpleField.class).getConverter(this), this.tx.readSimpleField(id, storageId, updateVersion));
    }

    public void writeSimpleField(JObject jobj, int storageId, Object value, boolean updateVersion) {
        JTransaction.registerJObject(jobj);
        ObjId id = jobj.getObjId();
        Converter<?, ?> converter = this.jdb.getJField(id, storageId, JSimpleField.class).getConverter(this);
        if (converter != null) {
            value = this.convert(converter.reverse(), value);
        }
        this.tx.writeSimpleField(id, storageId, value, updateVersion);
    }

    public Counter readCounterField(ObjId id, int storageId, boolean updateVersion) {
        this.jdb.getJField(id, storageId, JCounterField.class);
        if (updateVersion) {
            this.tx.updateSchemaVersion(id);
        }
        return new Counter(this.tx, id, storageId, updateVersion);
    }

    public NavigableSet<?> readSetField(ObjId id, int storageId, boolean updateVersion) {
        return (NavigableSet)this.convert(this.jdb.getJField(id, storageId, JSetField.class).getConverter(this), this.tx.readSetField(id, storageId, updateVersion));
    }

    public List<?> readListField(ObjId id, int storageId, boolean updateVersion) {
        return (List)this.convert(this.jdb.getJField(id, storageId, JListField.class).getConverter(this), this.tx.readListField(id, storageId, updateVersion));
    }

    public NavigableMap<?, ?> readMapField(ObjId id, int storageId, boolean updateVersion) {
        return (NavigableMap)this.convert(this.jdb.getJField(id, storageId, JMapField.class).getConverter(this), this.tx.readMapField(id, storageId, updateVersion));
    }

    public NavigableSet<JObject> followReferencePath(ReferencePath path, Iterable<? extends JObject> startObjects) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"null path");
        Preconditions.checkArgument((startObjects != null ? 1 : 0) != 0, (Object)"null startObjects");
        NavigableSet ids = this.tx.followReferencePath(Iterables.transform(startObjects, this.referenceConverter), path.getReferenceFields(), path.getPathKeyRanges());
        return new ConvertedNavigableSet(ids, this.referenceConverter);
    }

    public NavigableSet<JObject> invertReferencePath(ReferencePath path, Iterable<? extends JObject> targetObjects) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"null path");
        Preconditions.checkArgument((targetObjects != null ? 1 : 0) != 0, (Object)"null targetObjects");
        NavigableSet ids = this.tx.invertReferencePath(path.getReferenceFields(), path.getPathKeyRanges(), Iterables.transform(targetObjects, this.referenceConverter));
        return new ConvertedNavigableSet(ids, this.referenceConverter);
    }

    public <V, T> Index<V, T> queryIndex(Class<T> targetType, String fieldName, Class<V> valueType) {
        IndexQueryInfo info = this.jdb.getIndexQueryInfo(new IndexQueryInfoKey(fieldName, false, targetType, valueType));
        assert (info.indexInfo instanceof SimpleFieldIndexInfo);
        SimpleFieldIndexInfo indexInfo = (SimpleFieldIndexInfo)info.indexInfo;
        CoreIndex index = info.applyFilters(this.tx.queryIndex(indexInfo.storageId));
        Converter valueConverter = indexInfo.getConverter(this).reverse();
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex(index, valueConverter, targetConverter);
    }

    public <V, T> Index2<V, T, Integer> queryListElementIndex(Class<T> targetType, String fieldName, Class<V> valueType) {
        IndexQueryInfo info = this.jdb.getIndexQueryInfo(new IndexQueryInfoKey(fieldName, false, targetType, valueType));
        if (!(info.indexInfo instanceof ListElementIndexInfo)) {
            throw new IllegalArgumentException("field `" + fieldName + "' is not a list element sub-field");
        }
        ListElementIndexInfo indexInfo = (ListElementIndexInfo)info.indexInfo;
        CoreIndex2 index = info.applyFilters(this.tx.queryListElementIndex(indexInfo.storageId));
        Converter valueConverter = indexInfo.getConverter(this).reverse();
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex2(index, valueConverter, targetConverter, Converter.identity());
    }

    public <V, T, K> Index2<V, T, K> queryMapValueIndex(Class<T> targetType, String fieldName, Class<V> valueType, Class<K> keyType) {
        IndexQueryInfo info = this.jdb.getIndexQueryInfo(new IndexQueryInfoKey(fieldName, false, targetType, valueType, keyType));
        if (!(info.indexInfo instanceof MapValueIndexInfo)) {
            throw new IllegalArgumentException("field `" + fieldName + "' is not a map value sub-field");
        }
        MapValueIndexInfo indexInfo = (MapValueIndexInfo)info.indexInfo;
        CoreIndex2 index = info.applyFilters(this.tx.queryMapValueIndex(indexInfo.storageId));
        Converter valueConverter = indexInfo.getConverter(this).reverse();
        Converter keyConverter = indexInfo.getKeyConverter(this).reverse();
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex2(index, valueConverter, targetConverter, keyConverter);
    }

    public <V1, V2, T> Index2<V1, V2, T> queryCompositeIndex(Class<T> targetType, String indexName, Class<V1> value1Type, Class<V2> value2Type) {
        IndexQueryInfo info = this.jdb.getIndexQueryInfo(new IndexQueryInfoKey(indexName, true, targetType, value1Type, value2Type));
        CompositeIndexInfo indexInfo = (CompositeIndexInfo)info.indexInfo;
        CoreIndex2 index = info.applyFilters(this.tx.queryCompositeIndex2(indexInfo.storageId));
        Converter value1Converter = indexInfo.getConverter(this, 0).reverse();
        Converter value2Converter = indexInfo.getConverter(this, 1).reverse();
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex2(index, value1Converter, value2Converter, targetConverter);
    }

    public <V1, V2, V3, T> Index3<V1, V2, V3, T> queryCompositeIndex(Class<T> targetType, String indexName, Class<V1> value1Type, Class<V2> value2Type, Class<V3> value3Type) {
        IndexQueryInfo info = this.jdb.getIndexQueryInfo(new IndexQueryInfoKey(indexName, true, targetType, value1Type, value2Type, value3Type));
        CompositeIndexInfo indexInfo = (CompositeIndexInfo)info.indexInfo;
        CoreIndex3 index = info.applyFilters(this.tx.queryCompositeIndex3(indexInfo.storageId));
        Converter value1Converter = indexInfo.getConverter(this, 0).reverse();
        Converter value2Converter = indexInfo.getConverter(this, 1).reverse();
        Converter value3Converter = indexInfo.getConverter(this, 2).reverse();
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex3(index, value1Converter, value2Converter, value3Converter, targetConverter);
    }

    public <V1, V2, V3, V4, T> Index4<V1, V2, V3, V4, T> queryCompositeIndex(Class<T> targetType, String indexName, Class<V1> value1Type, Class<V2> value2Type, Class<V3> value3Type, Class<V4> value4Type) {
        IndexQueryInfo info = this.jdb.getIndexQueryInfo(new IndexQueryInfoKey(indexName, true, targetType, value1Type, value2Type, value3Type, value4Type));
        CompositeIndexInfo indexInfo = (CompositeIndexInfo)info.indexInfo;
        CoreIndex4 index = info.applyFilters(this.tx.queryCompositeIndex4(indexInfo.storageId));
        Converter value1Converter = indexInfo.getConverter(this, 0).reverse();
        Converter value2Converter = indexInfo.getConverter(this, 1).reverse();
        Converter value3Converter = indexInfo.getConverter(this, 2).reverse();
        Converter value4Converter = indexInfo.getConverter(this, 3).reverse();
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex4(index, value1Converter, value2Converter, value3Converter, value4Converter, targetConverter);
    }

    public Object queryIndex(int storageId) {
        IndexInfo indexInfo = this.jdb.indexInfoMap.get(storageId);
        if (indexInfo == null) {
            throw new IllegalArgumentException("no composite index or simple indexed field exists with storage ID " + storageId);
        }
        if (indexInfo instanceof CompositeIndexInfo) {
            CompositeIndexInfo compositeInfo = (CompositeIndexInfo)indexInfo;
            switch (compositeInfo.getStorageIds().size()) {
                case 2: {
                    Converter value1Converter = compositeInfo.getConverter(this, 0).reverse();
                    Converter value2Converter = compositeInfo.getConverter(this, 1).reverse();
                    return new ConvertedIndex2(this.tx.queryCompositeIndex2(indexInfo.storageId), value1Converter, value2Converter, this.referenceConverter);
                }
                case 3: {
                    Converter value1Converter = compositeInfo.getConverter(this, 0).reverse();
                    Converter value2Converter = compositeInfo.getConverter(this, 1).reverse();
                    Converter value3Converter = compositeInfo.getConverter(this, 2).reverse();
                    return new ConvertedIndex3(this.tx.queryCompositeIndex3(indexInfo.storageId), value1Converter, value2Converter, value3Converter, this.referenceConverter);
                }
                case 4: {
                    Converter value1Converter = compositeInfo.getConverter(this, 0).reverse();
                    Converter value2Converter = compositeInfo.getConverter(this, 1).reverse();
                    Converter value3Converter = compositeInfo.getConverter(this, 2).reverse();
                    Converter value4Converter = compositeInfo.getConverter(this, 3).reverse();
                    return new ConvertedIndex4(this.tx.queryCompositeIndex4(indexInfo.storageId), value1Converter, value2Converter, value3Converter, value4Converter, this.referenceConverter);
                }
            }
            throw new RuntimeException("internal error");
        }
        return ((SimpleFieldIndexInfo)indexInfo).toIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() {
        if (!this.tx.isValid()) {
            throw new StaleTransactionException(this.tx);
        }
        JTransaction jTransaction = this;
        synchronized (jTransaction) {
            if (this.commitInvoked) {
                throw new IllegalStateException("commit() invoked re-entrantly");
            }
            this.commitInvoked = true;
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            this.tx.rollback();
            throw e;
        }
        this.tx.commit();
    }

    public void rollback() {
        this.tx.rollback();
    }

    public boolean isValid() {
        return this.tx.isValid();
    }

    public void validate() {
        if (!this.tx.isValid()) {
            throw new StaleTransactionException(this.tx);
        }
        if (this.validationMode == ValidationMode.DISABLED) {
            return;
        }
        this.performAction(this::doValidate);
    }

    public void performAction(Runnable action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"null action");
        JTransaction previous = CURRENT.get();
        CURRENT.set(this);
        try {
            action.run();
        }
        finally {
            CURRENT.set(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doValidate() {
        validatorFactory = this.jdb.getValidatorFactory();
        validator = validatorFactory != null ? validatorFactory.getValidator() : null;
        block10: while (true) {
            var3_3 = this;
            synchronized (var3_3) {
                entry = this.validationQueue.removeOne();
                if (entry == null) {
                    return;
                }
                id = (ObjId)entry.getKey();
                validationGroups = (Class[])entry.getValue();
                if (!JTransaction.$assertionsDisabled && id == null) {
                    throw new AssertionError();
                }
                if (!JTransaction.$assertionsDisabled && validationGroups == null) {
                    throw new AssertionError();
                }
            }
            if (!this.tx.exists(id)) continue;
            jobj = this.get(id);
            jclass = this.jdb.jclasses.get(id.getStorageId());
            if (jclass == null) {
                return;
            }
            if (validator != null) {
                try {
                    violations = new ValidationContext((Object)jobj, validationGroups).validate(validator);
                }
                catch (RuntimeException e) {
                    rootCause = Throwables.getRootCause((Throwable)e);
                    if (rootCause instanceof KVDatabaseException) {
                        throw (KVDatabaseException)rootCause;
                    }
                    throw e;
                }
                if (!violations.isEmpty()) {
                    throw new ValidationException(jobj, violations, "validation error for object " + id + " of type `" + this.jdb.jclasses.get((Object)Integer.valueOf((int)id.getStorageId())).name + "':\n" + ValidationUtil.describe((Set)violations));
                }
            }
            for (MethodAnnotationScanner.MethodInfo info : jclass.onValidateMethods) {
                methodGroups = ((OnValidate)info.getAnnotation()).groups();
                if (methodGroups.length == 0) {
                    methodGroups = JTransaction.DEFAULT_CLASS_ARRAY;
                }
                if (!Util.isAnyGroupBeingValidated(methodGroups, validationGroups)) continue;
                Util.invoke(info.getMethod(), jobj, new Object[0]);
            }
            if (jclass.uniqueConstraintFields.isEmpty() && jclass.uniqueConstraintCompositeIndexes.isEmpty() || !Util.isAnyGroupBeingValidated(JTransaction.DEFAULT_AND_UNIQUENESS_CLASS_ARRAY, validationGroups)) continue;
            for (JSimpleField jfield : jclass.uniqueConstraintFields) {
                if (!JTransaction.$assertionsDisabled && !jfield.indexed) {
                    throw new AssertionError();
                }
                if (!JTransaction.$assertionsDisabled && !jfield.unique) {
                    throw new AssertionError();
                }
                value = this.tx.readSimpleField(id, jfield.storageId, false);
                if (jfield.uniqueExcludes != null && Collections.binarySearch(jfield.uniqueExcludes, value, jfield.fieldType) >= 0 || (conflictors = this.findUniqueConflictors(id, (NavigableSet)(index = (info = this.jdb.getIndexQueryInfo(new IndexQueryInfoKey(jfield.name, false, jfield.getter.getDeclaringClass(), new Class[]{jfield.typeToken.wrap().getRawType()}))).applyFilters(this.tx.queryIndex(jfield.storageId))).asMap().get(value))).isEmpty()) continue;
                throw new ValidationException(jobj, "uniqueness constraint on " + jfield + " failed for object " + id + ": field value " + value + " is also shared by object(s) " + conflictors);
            }
            var7_7 = jclass.uniqueConstraintCompositeIndexes.iterator();
            while (true) {
                if (var7_7.hasNext()) ** break;
                continue block10;
                index = (JCompositeIndex)var7_7.next();
                if (!JTransaction.$assertionsDisabled && !index.unique) {
                    throw new AssertionError();
                }
                numFields = index.jfields.size();
                values = new ArrayList<Object>(numFields);
                index = index.jfields.iterator();
                while (index.hasNext()) {
                    jfield = index.next();
                    values.add(this.tx.readSimpleField(id, jfield.storageId, false));
                }
                if (index.uniqueExcludes != null && Collections.binarySearch(index.uniqueExcludes, values, index.uniqueComparator) >= 0) continue;
                info = this.jdb.getIndexQueryInfo(new IndexQueryInfoKey(index.name, true, index.declaringType, index.getQueryInfoValueTypes()));
                indexInfo = (CompositeIndexInfo)info.indexInfo;
                switch (numFields) {
                    case 2: {
                        coreIndex2 = this.tx.queryCompositeIndex2(indexInfo.storageId);
                        ids = (NavigableSet)info.applyFilters(coreIndex2).asMap().get(new Tuple2(values.get(0), values.get(1)));
                        break;
                    }
                    case 3: {
                        coreIndex3 = this.tx.queryCompositeIndex3(indexInfo.storageId);
                        ids = (NavigableSet)info.applyFilters(coreIndex3).asMap().get(new Tuple3(values.get(0), values.get(1), values.get(2)));
                        break;
                    }
                    case 4: {
                        coreIndex4 = this.tx.queryCompositeIndex4(indexInfo.storageId);
                        ids = (NavigableSet)info.applyFilters(coreIndex4).asMap().get(new Tuple4(values.get(0), values.get(1), values.get(2), values.get(3)));
                        break;
                    }
                    default: {
                        throw new RuntimeException("internal error");
                    }
                }
                if (!(conflictors = this.findUniqueConflictors(id, ids)).isEmpty()) break block10;
            }
            break;
        }
        throw new ValidationException(jobj, "uniqueness constraint on composite index `" + index.name + "' failed for object " + id + ": field value combination " + values + " is also shared by object(s) " + conflictors);
    }

    private ArrayList<ObjId> findUniqueConflictors(ObjId id, NavigableSet<ObjId> ids) {
        ArrayList<ObjId> conflictors = new ArrayList<ObjId>(5);
        for (ObjId conflictor : ids) {
            if (conflictor.equals((Object)id)) continue;
            conflictors.add(conflictor);
            if (conflictors.size() < 5) continue;
            break;
        }
        return conflictors;
    }

    private void doOnCreate(ObjId id) {
        JClass<?> jclass;
        try {
            jclass = this.jdb.getJClass(id);
        }
        catch (TypeNotInSchemaVersionException e) {
            return;
        }
        if (this.validationMode == ValidationMode.AUTOMATIC && jclass.requiresDefaultValidation) {
            this.revalidate(Collections.singleton(id), new Class[0]);
        }
        JObject jobj = null;
        for (MethodAnnotationScanner.MethodInfo info : jclass.onCreateMethods) {
            if (this.isSnapshot() && !((OnCreate)info.getAnnotation()).snapshotTransactions()) continue;
            if (jobj == null) {
                jobj = this.get(id);
            }
            Util.invoke(info.getMethod(), jobj, new Object[0]);
        }
    }

    private void doOnDelete(ObjId id) {
        JClass<?> jclass;
        try {
            jclass = this.jdb.getJClass(id);
        }
        catch (TypeNotInSchemaVersionException e) {
            return;
        }
        JObject jobj = null;
        for (MethodAnnotationScanner.MethodInfo info : jclass.onDeleteMethods) {
            if (this.isSnapshot() && !((OnDelete)info.getAnnotation()).snapshotTransactions()) continue;
            if (jobj == null) {
                jobj = this.get(id);
            }
            Util.invoke(info.getMethod(), jobj, new Object[0]);
        }
    }

    private void doOnVersionChange(ObjId id, int oldVersion, int newVersion, Map<Integer, Object> oldValues) {
        JClass<?> jclass;
        try {
            jclass = this.jdb.getJClass(id);
        }
        catch (TypeNotInSchemaVersionException e) {
            return;
        }
        if (this.validationMode == ValidationMode.AUTOMATIC && jclass.requiresDefaultValidation) {
            this.revalidate(Collections.singleton(id), new Class[0]);
        }
        if (jclass.upgradeConversionFields.isEmpty() && jclass.onVersionChangeMethods.isEmpty()) {
            return;
        }
        Schema oldSchema = this.tx.getSchemas().getVersion(oldVersion);
        Schema newSchema = this.tx.getSchema();
        ObjType oldObjType = oldSchema.getObjType(id.getStorageId());
        ObjType newObjType = newSchema.getObjType(id.getStorageId());
        for (JField jfield0 : jclass.upgradeConversionFields) {
            JField jfield;
            Field oldField0;
            int storageId2 = jfield0.getStorageId();
            try {
                oldField0 = oldObjType.getField(storageId2);
            }
            catch (UnknownFieldException e) {
                continue;
            }
            Object oldValue2 = oldValues.get(storageId2);
            if (jfield0 instanceof JCounterField) {
                SimpleField oldField;
                FieldType oldFieldType;
                jfield = (JCounterField)jfield0;
                assert (jfield.upgradeConversion.isConvertsValues());
                if (oldField0 instanceof CounterField) continue;
                if (oldField0 instanceof SimpleField && Number.class.isAssignableFrom((oldFieldType = (oldField = (SimpleField)oldField0).getFieldType()).getTypeToken().wrap().getRawType())) {
                    Number value = (Number)oldValue2;
                    if (value == null) continue;
                    this.tx.writeCounterField(id, storageId2, value.longValue(), false);
                    continue;
                }
                if (!jfield.upgradeConversion.isRequireConversion()) continue;
                throw new UpgradeConversionException(id, storageId2, "conversion from the previous schema version's " + (oldValue2 != null ? "non-numeric " : "null ") + oldField0 + " to " + jfield + " is not supported, but the upgrade conversion policy is configured as " + (Object)((Object)jfield.upgradeConversion));
            }
            jfield = (JSimpleField)jfield0;
            assert (((JSimpleField)jfield).upgradeConversion.isConvertsValues());
            SimpleField newField = (SimpleField)newObjType.getField(storageId2);
            if (oldField0 instanceof CounterField) {
                this.doConvertAndSetField(id, oldField0, this.tx.getDatabase().getFieldTypeRegistry().getFieldType(TypeToken.of(Long.TYPE)), newField, oldValue2, ((JSimpleField)jfield).upgradeConversion);
                continue;
            }
            if (!(oldField0 instanceof SimpleField)) continue;
            SimpleField oldField = (SimpleField)oldField0;
            this.convertAndSetField(id, oldField, newField, oldValue2, ((JSimpleField)jfield).upgradeConversion);
        }
        if (jclass.onVersionChangeMethods.isEmpty()) {
            return;
        }
        JObject jobj = null;
        Map oldValuesByStorageId = Maps.transformEntries(oldValues, (storageId, oldValue) -> this.convertOldVersionValue(id, oldObjType.getField(storageId.intValue()), oldValue));
        SortedMap oldValuesByName = Maps.transformValues((SortedMap)oldObjType.getFieldsByName(), field -> oldValuesByStorageId.get(field.getStorageId()));
        for (MethodAnnotationScanner.MethodInfo info0 : jclass.onVersionChangeMethods) {
            OnVersionChangeScanner.VersionChangeMethodInfo info = (OnVersionChangeScanner.VersionChangeMethodInfo)info0;
            if (jobj == null) {
                jobj = this.get(id);
            }
            info.invoke(jobj, oldVersion, newVersion, oldValuesByStorageId, oldValuesByName);
        }
    }

    private <OT, NT> void convertAndSetField(ObjId id, SimpleField<OT> oldField, SimpleField<NT> newField, Object oldValue, UpgradeConversionPolicy policy) {
        assert (policy.isConvertsValues());
        FieldType oldFieldType = oldField.getFieldType();
        FieldType newFieldType = newField.getFieldType();
        if (newFieldType.equals((Object)oldFieldType)) {
            return;
        }
        this.doConvertAndSetField(id, (Field<?>)oldField, (FieldType<OT>)oldFieldType, newField, oldValue, policy);
    }

    private <OT, NT> void doConvertAndSetField(ObjId id, Field<?> oldField, FieldType<OT> oldFieldType, SimpleField<NT> newField, Object oldValue0, UpgradeConversionPolicy policy) {
        Object newValue;
        Object oldValue = oldFieldType.validate(oldValue0);
        FieldType newFieldType = newField.getFieldType();
        try {
            newValue = newFieldType.convert(oldFieldType, oldValue);
        }
        catch (IllegalArgumentException e) {
            if (policy.isRequireConversion()) {
                throw new UpgradeConversionException(id, newField.getStorageId(), "the value " + oldFieldType.toString(oldValue) + " in the previous schema version's " + oldField + " could not be converted type to the new field type " + newFieldType + ", but the upgrade conversion policy is configured as " + (Object)((Object)policy), e);
            }
            return;
        }
        newField.setValue(this.tx, id, newValue);
    }

    private <X, Y> Y convert(Converter<X, Y> converter, Object value) {
        return (Y)(converter != null ? converter.convert(value) : value);
    }

    private Object convertOldVersionValue(ObjId id, Field<?> field, Object value) {
        if (value == null) {
            return null;
        }
        return this.convert((Converter)field.visit((FieldSwitch)new OldVersionValueConverterBuilder()), value);
    }

    private static class DefaultValidationListener
    implements AllChangesListener {
        private DefaultValidationListener() {
        }

        public <T> void onSimpleFieldChange(Transaction tx, ObjId id, SimpleField<T> field, int[] path, NavigableSet<ObjId> referrers, T oldValue, T newValue) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        public <E> void onSetFieldAdd(Transaction tx, ObjId id, SetField<E> field, int[] path, NavigableSet<ObjId> referrers, E value) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        public <E> void onSetFieldRemove(Transaction tx, ObjId id, SetField<E> field, int[] path, NavigableSet<ObjId> referrers, E value) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        public void onSetFieldClear(Transaction tx, ObjId id, SetField<?> field, int[] path, NavigableSet<ObjId> referrers) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        public <E> void onListFieldAdd(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E value) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        public <E> void onListFieldRemove(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E value) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        public <E> void onListFieldReplace(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E oldValue, E newValue) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        public void onListFieldClear(Transaction tx, ObjId id, ListField<?> field, int[] path, NavigableSet<ObjId> referrers) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        public <K, V> void onMapFieldAdd(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V value) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        public <K, V> void onMapFieldRemove(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V value) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        public <K, V> void onMapFieldReplace(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V oldValue, V newValue) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        public void onMapFieldClear(Transaction tx, ObjId id, MapField<?, ?> field, int[] path, NavigableSet<ObjId> referrers) {
            this.revalidateIfNeeded(tx, id, (Field<?>)field, referrers);
        }

        private void revalidateIfNeeded(Transaction tx, ObjId id, Field<?> field, NavigableSet<ObjId> referrers) {
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            JField jfield = jtx.jdb.getJField(id, field.getStorageId(), JField.class);
            if (jfield.requiresDefaultValidation) {
                jtx.revalidate(referrers, new Class[0]);
            }
        }
    }

    private class OldVersionValueConverterBuilder
    extends FieldSwitchAdapter<Converter<?, ?>> {
        private OldVersionValueConverterBuilder() {
        }

        public Converter<?, ?> caseReferenceField(ReferenceField field) {
            return JTransaction.this.referenceConverter.reverse();
        }

        public Converter<?, ?> caseSimpleField(SimpleField field) {
            return null;
        }

        public <E> Converter<?, ?> caseSetField(SetField<E> field) {
            Converter elementConverter = (Converter)field.getElementField().visit((FieldSwitch)this);
            return elementConverter != null ? new NavigableSetConverter(elementConverter) : null;
        }

        public <E> Converter<?, ?> caseListField(ListField<E> field) {
            Converter elementConverter = (Converter)field.getElementField().visit((FieldSwitch)this);
            return elementConverter != null ? new ListConverter(elementConverter) : null;
        }

        public <K, V> Converter<?, ?> caseMapField(MapField<K, V> field) {
            Converter keyConverter = (Converter)field.getKeyField().visit((FieldSwitch)this);
            Converter valueConverter = (Converter)field.getValueField().visit((FieldSwitch)this);
            if (keyConverter != null || valueConverter != null) {
                if (keyConverter == null) {
                    keyConverter = Converter.identity();
                }
                if (valueConverter == null) {
                    valueConverter = Converter.identity();
                }
                return new NavigableMapConverter(keyConverter, valueConverter);
            }
            return null;
        }

        public Converter<?, ?> caseCounterField(CounterField field) {
            return null;
        }
    }

    private static class InternalVersionChangeListener
    implements VersionChangeListener {
        private InternalVersionChangeListener() {
        }

        public void onVersionChange(Transaction tx, ObjId id, int oldVersion, int newVersion, Map<Integer, Object> oldValues) {
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            jtx.doOnVersionChange(id, oldVersion, newVersion, oldValues);
        }
    }

    private static class InternalDeleteListener
    implements DeleteListener {
        private InternalDeleteListener() {
        }

        public void onDelete(Transaction tx, ObjId id) {
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            jtx.doOnDelete(id);
        }
    }

    private static class InternalCreateListener
    implements CreateListener {
        private InternalCreateListener() {
        }

        public void onCreate(Transaction tx, ObjId id) {
            JTransaction jtx = (JTransaction)tx.getUserObject();
            assert (jtx != null && jtx.tx == tx);
            jtx.doOnCreate(id);
        }
    }
}

