/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import java.util.Objects;
import org.jsimpledb.ComplexSubFieldIndexInfo;
import org.jsimpledb.ConvertedIndex2;
import org.jsimpledb.ConverterProvider;
import org.jsimpledb.JEnumField;
import org.jsimpledb.JMapField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.type.ReferenceFieldType;

class MapValueIndexInfo
extends ComplexSubFieldIndexInfo {
    private final int keyFieldStorageId;
    private final FieldType<?> keyFieldType;
    private final Class<? extends Enum<?>> keyEnumType;
    private final ConverterProvider keyConverterProvider;

    MapValueIndexInfo(JMapField jfield) {
        super(jfield.valueField);
        this.keyFieldStorageId = jfield.keyField.storageId;
        this.keyFieldType = jfield.keyField.fieldType.genericizeForIndex();
        this.keyEnumType = jfield.keyField instanceof JEnumField ? ((JEnumField)jfield.keyField).getTypeToken().getRawType() : null;
        this.keyConverterProvider = ConverterProvider.identityForNull(jfield.keyField::getConverter);
    }

    public int getKeyFieldStorageId() {
        return this.keyFieldStorageId;
    }

    public FieldType<?> getKeyFieldType() {
        return this.keyFieldType;
    }

    public Converter<?, ?> getKeyConverter(JTransaction jtx) {
        return this.keyConverterProvider.getConverter(jtx);
    }

    @Override
    public Object toIndex(JTransaction jtx) {
        return new ConvertedIndex2(jtx.tx.queryMapValueIndex(this.storageId), this.getConverter(jtx), jtx.referenceConverter, this.getKeyConverter(jtx));
    }

    @Override
    protected Iterable<?> iterateReferences(Transaction tx, ObjId id) {
        assert (this.getFieldType() instanceof ReferenceFieldType);
        return tx.readMapField(id, this.getParentStorageId(), false).values();
    }

    @Override
    protected String toStringPrefix() {
        return super.toStringPrefix() + ",keyFieldStorageId=" + this.keyFieldStorageId + ",keyFieldType=" + this.keyFieldType + (this.keyEnumType != null ? ",keyEnumType=" + this.keyEnumType : "");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MapValueIndexInfo that = (MapValueIndexInfo)obj;
        return this.keyFieldStorageId == that.keyFieldStorageId && this.keyFieldType.equals(that.keyFieldType) && Objects.equals(this.keyEnumType, that.keyEnumType);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.keyFieldStorageId ^ this.keyFieldType.hashCode() ^ Objects.hashCode(this.keyEnumType);
    }
}

