/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.reflect.TypeToken;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jsimpledb.JClass;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JField;
import org.jsimpledb.JReferenceField;
import org.jsimpledb.JSchemaObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.UntypedJObject;
import org.jsimpledb.Util;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.schema.SchemaObjectType;
import org.jsimpledb.util.ParseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencePath {
    private static final String IDENT = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final String IDENT_ID = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:#[0-9]+)?";
    private static final String IDENT_ID_1OR2 = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:#[0-9]+)?(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:#[0-9]+)?)?";
    private static final String IDENTS = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*";
    private static final String FWD_STEP = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:#[0-9]+)?)";
    private static final String REV_STEP = "\\^((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*):(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:#[0-9]+)?(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:#[0-9]+)?)?))\\^";
    final JSimpleDB jdb;
    final Class<?> startType;
    final ArrayList<Set<Class<?>>> pathTypes;
    final Set<TypeToken<?>> targetFieldTypes;
    final int targetFieldStorageId;
    final int targetSuperFieldStorageId;
    final int[] referenceFieldStorageIds;
    final Set<Cursor> cursors;
    final String path;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile KeyRanges[] pathKeyRanges;

    ReferencePath(JSimpleDB jdb, Class<?> startType, String path, boolean withTargetField, Boolean lastIsSubField) {
        List<JClass<?>> startJClasses;
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        Preconditions.checkArgument((startType != null ? 1 : 0) != 0, (Object)"null startType");
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"null path");
        String errorPrefix = "invalid path `" + path + "': ";
        this.jdb = jdb;
        this.startType = startType;
        this.path = path;
        if (this.log.isTraceEnabled()) {
            this.log.trace("RefPath: START startType=" + startType.getName() + " path=\"" + path + "\" withTargetField=" + withTargetField + " lastIsSubField=" + lastIsSubField);
        }
        ArrayDeque<String> fieldNames = new ArrayDeque<String>();
        ParseContext ctx = new ParseContext(path);
        while (!ctx.isEOF()) {
            Matcher matcher;
            if (ctx.getIndex() > 0) {
                ctx.expect('.');
            }
            if ((matcher = ctx.tryPattern(FWD_STEP)) == null && (matcher = ctx.tryPattern(REV_STEP)) == null) {
                throw new IllegalArgumentException(errorPrefix + "invalid path starting at `" + ParseContext.truncate((String)ctx.getInput(), (int)32) + "'");
            }
            fieldNames.add(matcher.group());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("RefPath: fieldNames=" + fieldNames);
        }
        if ((startJClasses = this.jdb.getJClasses(this.startType)).isEmpty()) {
            throw new IllegalArgumentException(errorPrefix + "no model type is an instance of path start type " + this.startType.getName());
        }
        HashSet<Cursor> remainingCursors = new HashSet<Cursor>();
        startJClasses.stream().map(jclass -> new Cursor((JClass)jclass, jclass.getType(), fieldNames)).forEach(remainingCursors::add);
        if (this.startType.isAssignableFrom(UntypedJObject.class)) {
            remainingCursors.add(new Cursor(null, UntypedJObject.class, fieldNames));
        }
        IllegalArgumentException error = null;
        HashSet<Cursor> completedCursors = new HashSet<Cursor>();
        while (!remainingCursors.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("RefPath: remainingCursors=" + remainingCursors);
            }
            HashSet previouslyRemainingCursors = new HashSet(remainingCursors);
            remainingCursors.clear();
            for (Cursor cursor : previouslyRemainingCursors) {
                Set<Cursor> newCursors;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("RefPath: processing remainingCursor " + cursor);
                }
                if (!withTargetField && !cursor.hasMoreFieldNames()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("RefPath: remainingCursor " + cursor + " is completed");
                    }
                    completedCursors.add(cursor);
                    continue;
                }
                try {
                    newCursors = cursor.identifyNextField(withTargetField, lastIsSubField);
                }
                catch (IllegalArgumentException e) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("RefPath: identifyNextField() on " + cursor + " failed: " + e.getMessage());
                    }
                    error = e;
                    continue;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("RefPath: identifyNextField() on " + cursor + " succeeded: newCursors=" + newCursors);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("RefPath: after identifyNextField(), newCursors=" + newCursors);
                }
                Iterator<Cursor> i = newCursors.iterator();
                while (i.hasNext()) {
                    Cursor newCursor = i.next();
                    if (!withTargetField || newCursor.hasMoreFieldNames()) continue;
                    if (newCursor.isReverseStep()) {
                        throw new IllegalArgumentException("Invalid reference path: missing target field");
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("RefPath: newCursor " + cursor + " is completed");
                    }
                    completedCursors.add(newCursor);
                    i.remove();
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("RefPath: after identifyNextField(), remaining newCursors=" + newCursors);
                }
                for (Cursor newCursor : newCursors) {
                    Set<Cursor> dereferencedCursors;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("RefPath: invoking stepThroughReference() on " + newCursor);
                    }
                    try {
                        dereferencedCursors = newCursor.stepThroughReference();
                    }
                    catch (IllegalArgumentException e) {
                        error = e;
                        continue;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("RefPath: stepThroughReference() returned " + dereferencedCursors);
                    }
                    remainingCursors.addAll(dereferencedCursors);
                }
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("RefPath: remainingCursors=" + remainingCursors + " completedCursors=" + completedCursors);
        }
        if (completedCursors.isEmpty()) {
            throw error;
        }
        ArrayList<Integer> referenceFieldList = ((Cursor)completedCursors.iterator().next()).getReferenceFields();
        for (Cursor cursor : completedCursors) {
            if (cursor.getReferenceFields().equals(referenceFieldList)) continue;
            throw new IllegalArgumentException(errorPrefix + "path is ambiguous due to traversal of fields with different types");
        }
        if (withTargetField) {
            Set targetFieldStorageIds = completedCursors.stream().map(Cursor::getField).map(JSchemaObject::getStorageId).collect(Collectors.toSet());
            Set targetSuperFieldStorageIds = completedCursors.stream().map(Cursor::getSuperField).map(sf -> sf != null ? sf.storageId : 0).collect(Collectors.toSet());
            if (targetFieldStorageIds.size() != 1 || targetSuperFieldStorageIds.size() != 1) {
                throw new IllegalArgumentException(errorPrefix + "the target field `" + (String)fieldNames.pollLast() + "' is ambiguous: " + completedCursors.stream().map(Cursor::getField).collect(Collectors.toSet()));
            }
            Set targetFieldTypesSet = completedCursors.stream().map(Cursor::getField).map(JField::getTypeToken).collect(Collectors.toSet());
            this.targetFieldTypes = Collections.unmodifiableSet(targetFieldTypesSet);
            this.targetFieldStorageId = (Integer)targetFieldStorageIds.iterator().next();
            this.targetSuperFieldStorageId = (Integer)targetSuperFieldStorageIds.iterator().next();
        } else {
            this.targetFieldTypes = null;
            this.targetFieldStorageId = 0;
            this.targetSuperFieldStorageId = 0;
        }
        this.pathTypes = new ArrayList(referenceFieldList.size() + 1);
        for (int i = 0; i <= referenceFieldList.size(); ++i) {
            HashSet types = new HashSet();
            for (Cursor cursor : completedCursors) {
                Class<?> type = cursor.getPathTypes().get(i);
                types.add(type);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("RefPath: added " + type + " to pathTypes[" + i + "] from " + cursor);
            }
            this.pathTypes.add(ReferencePath.minimizeAndSeal(types));
        }
        assert (this.pathTypes.size() == referenceFieldList.size() + 1);
        this.referenceFieldStorageIds = Ints.toArray(referenceFieldList);
        this.cursors = completedCursors;
        if (this.log.isTraceEnabled()) {
            this.log.trace("RefPath: DONE: targetFieldStorageId=" + this.targetFieldStorageId + " targetSuperFieldStorageId=" + this.targetSuperFieldStorageId + " targetFieldTypes=" + this.targetFieldTypes + " references=" + referenceFieldList + " cursors=" + this.cursors + " pathTypes=" + this.pathTypes);
        }
    }

    public Class<?> getStartType() {
        return this.startType;
    }

    public Class<?> getTargetType() {
        return Util.findLowestCommonAncestorOfClasses(this.getTargetTypes()).getRawType();
    }

    public Set<Class<?>> getTargetTypes() {
        return this.getPathTypes().get(this.pathTypes.size() - 1);
    }

    public List<Set<Class<?>>> getPathTypes() {
        return Collections.unmodifiableList(this.pathTypes);
    }

    KeyRanges[] getPathKeyRanges() {
        if (this.pathKeyRanges == null) {
            int numJClasses = this.jdb.jclasses.size();
            KeyRanges[] array = new KeyRanges[this.pathTypes.size()];
            for (int i = 0; i < this.pathTypes.size(); ++i) {
                HashSet jclasses = new HashSet();
                Set<Class<?>> types = this.pathTypes.get(i);
                for (Class<?> type : types) {
                    jclasses.addAll(this.jdb.getJClasses(type));
                }
                if (jclasses.size() == numJClasses && this.isAnyAssignableFrom(types, UntypedJObject.class)) continue;
                ArrayList<KeyRange> ranges = new ArrayList<KeyRange>(jclasses.size());
                for (JClass jClass : jclasses) {
                    ranges.add(ObjId.getKeyRange((int)jClass.storageId));
                }
                array[i] = new KeyRanges(ranges);
            }
            this.pathKeyRanges = array;
        }
        return this.pathKeyRanges;
    }

    private boolean isAnyAssignableFrom(Iterable<? extends Class<?>> tos, Class<?> from) {
        for (Class<?> to : tos) {
            if (!to.isAssignableFrom(from)) continue;
            return true;
        }
        return false;
    }

    public Set<TypeToken<?>> getTargetFieldTypes() {
        return this.targetFieldTypes;
    }

    public int getTargetField() {
        return this.targetFieldStorageId;
    }

    public int getTargetSuperField() {
        return this.targetSuperFieldStorageId;
    }

    public int[] getReferenceFields() {
        return (int[])this.referenceFieldStorageIds.clone();
    }

    public String toString() {
        return this.path;
    }

    private JField findField(JClass<?> jclass, ArrayDeque<String> fieldNames, Boolean lastIsSubField) {
        String searchName;
        Preconditions.checkArgument((jclass != null ? 1 : 0) != 0, (Object)"null jclass");
        Preconditions.checkArgument((fieldNames != null ? 1 : 0) != 0, (Object)"null fieldNames");
        Preconditions.checkArgument((!fieldNames.isEmpty() ? 1 : 0) != 0, (Object)"empty reference path");
        if (this.log.isTraceEnabled()) {
            this.log.trace("RefPath.findField(): jclass=" + jclass + " fieldNames=" + fieldNames + " lastIsSubField=" + lastIsSubField);
        }
        String fieldName = fieldNames.removeFirst();
        String description = "field `" + fieldName + "' in " + jclass.getType();
        int hash = fieldName.indexOf(35);
        int explicitStorageId = 0;
        if (hash != -1) {
            try {
                explicitStorageId = Integer.parseInt(fieldName.substring(hash + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid field name `" + fieldName + "'");
            }
            searchName = fieldName.substring(0, hash);
        } else {
            searchName = fieldName;
        }
        JField matchingField = jclass.jfieldsByName.get(searchName);
        if (matchingField == null || explicitStorageId != 0 && matchingField.storageId != explicitStorageId) {
            throw new IllegalArgumentException("there is no field named `" + searchName + "'" + (explicitStorageId != 0 ? " with storage ID " + explicitStorageId : "") + " in " + jclass.getType());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("RefPath.findField(): found field " + matchingField + " in " + jclass.getType());
        }
        JComplexField superField = null;
        if (matchingField instanceof JComplexField) {
            superField = (JComplexField)matchingField;
            if (this.log.isTraceEnabled()) {
                this.log.trace("RefPath.findField(): field is a complex field");
            }
            if (fieldNames.isEmpty()) {
                if (Boolean.TRUE.equals(lastIsSubField)) {
                    StringBuilder buf = new StringBuilder();
                    for (JSimpleField subField : superField.getSubFields()) {
                        if (buf.length() == 0) {
                            buf.append("path may not end on complex ").append(description).append("; a sub-field must be specified (e.g., ");
                        } else {
                            buf.append(" or ");
                        }
                        buf.append('`').append(matchingField.name).append('.').append(subField.name).append('\'');
                    }
                    buf.append(")");
                    throw new IllegalArgumentException(buf.toString());
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("RefPath.findField(): ended on complex field; result=" + matchingField);
                }
                return matchingField;
            }
            String subFieldName = fieldNames.removeFirst();
            description = "sub-field `" + subFieldName + "' of complex " + description;
            try {
                matchingField = superField.getSubField(subFieldName);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid " + description + ": " + e.getMessage(), e);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("RefPath.findField(): also stepping through sub-field [" + searchName + "." + subFieldName + "] to reach " + matchingField);
            }
        } else if (this.log.isTraceEnabled()) {
            if (matchingField instanceof JSimpleField) {
                JSimpleField simpleField = (JSimpleField)matchingField;
                this.log.trace("RefPath.findField(): field is a simple field of type " + simpleField.getTypeToken());
            } else {
                this.log.trace("RefPath.findField(): field is " + matchingField);
            }
        }
        if (fieldNames.isEmpty() && superField != null && Boolean.FALSE.equals(lastIsSubField)) {
            throw new IllegalArgumentException("path may not end on " + description + "; instead, specify the complex field itself");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("RefPath.findField(): result=" + matchingField);
        }
        return matchingField;
    }

    private static Set<Class<?>> minimizeAndSeal(Set<Class<?>> types) {
        HashSet<Class> minimalTypes = new HashSet<Class>(types.size());
        for (TypeToken<?> typeToken : Util.findLowestCommonAncestorsOfClasses(types)) {
            minimalTypes.add(typeToken.getRawType());
        }
        return Collections.unmodifiableSet(minimalTypes);
    }

    private static ArrayList<Class<?>> arrayListOf(Class<?> type) {
        ArrayList list = new ArrayList(1);
        list.add(type);
        return list;
    }

    private static <T> ArrayList<T> copyAndAppend(List<T> original, T elem) {
        ArrayList<T> list = new ArrayList<T>(original.size() + 1);
        list.addAll(original);
        list.add(elem);
        return list;
    }

    final class Cursor {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final ArrayList<Integer> referenceFields = new ArrayList();
        private final ArrayList<Class<?>> pathTypes = new ArrayList();
        private final JClass<?> jclass;
        private final JField jfield;
        private final ArrayDeque<String> fieldNames;
        private final boolean reverseStep;

        private Cursor(JClass<?> jclass, Class<?> startType, ArrayDeque<String> fieldNames) {
            this(new ArrayList<Integer>(0), ReferencePath.arrayListOf(startType), jclass, null, fieldNames, false);
        }

        private Cursor(ArrayList<Integer> referenceFields, ArrayList<Class<?>> pathTypes, JClass<?> jclass, JField jfield, ArrayDeque<String> fieldNames, boolean reverseStep) {
            assert (pathTypes.size() == referenceFields.size() + 1);
            this.referenceFields.addAll(referenceFields);
            this.pathTypes.addAll(pathTypes);
            this.jclass = jclass;
            this.jfield = jfield;
            this.fieldNames = fieldNames.clone();
            this.reverseStep = reverseStep;
        }

        public ArrayList<Integer> getReferenceFields() {
            return this.referenceFields;
        }

        public ArrayList<Class<?>> getPathTypes() {
            return this.pathTypes;
        }

        public int getNumRefs() {
            return this.referenceFields.size();
        }

        public JClass<?> getJClass() {
            return this.jclass;
        }

        public JField getField() {
            return this.jfield;
        }

        public JComplexField getSuperField() {
            return this.jfield instanceof JSimpleField ? ((JSimpleField)this.jfield).getParentField() : null;
        }

        public boolean hasMoreFieldNames() {
            return !this.fieldNames.isEmpty();
        }

        public boolean isReverseStep() {
            return this.reverseStep;
        }

        public Class<?> getFieldTargetType() {
            Preconditions.checkState((this.jfield != null ? 1 : 0) != 0, (Object)"have not yet stepped through field");
            return this.reverseStep ? this.jfield.getJClass().type : (this.jfield instanceof JReferenceField ? ((JReferenceField)this.jfield).typeToken.getRawType() : null);
        }

        public Set<Cursor> identifyNextField(boolean withTargetField, Boolean lastIsSubField) {
            Preconditions.checkArgument((!this.fieldNames.isEmpty() ? 1 : 0) != 0, (Object)"empty reference path");
            Preconditions.checkState((this.jfield == null ? 1 : 0) != 0, (Object)"already stepped through field");
            Object remainingFieldNames = this.fieldNames.clone();
            String step = (String)((ArrayDeque)remainingFieldNames).peekFirst();
            HashSet<Cursor> newCursors = new HashSet<Cursor>(3);
            Matcher reverseMatcher = Pattern.compile(ReferencePath.REV_STEP).matcher(step);
            if (reverseMatcher.matches()) {
                Class<UntypedJObject> type;
                SchemaObjectType schemaType;
                if (withTargetField && ((ArrayDeque)remainingFieldNames).isEmpty()) {
                    throw new IllegalArgumentException("Invalid reference path: missing target field after last step `" + step + "'");
                }
                String typeName = reverseMatcher.group(2);
                String fieldName = reverseMatcher.group(3);
                ((ArrayDeque)remainingFieldNames).removeFirst();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("RefPath.identifyNextField(): reverse step `" + step + "' -> type `" + typeName + "' field `" + fieldName + "'");
                }
                if ((schemaType = ReferencePath.this.jdb.getNameIndex().getSchemaObjectType(typeName)) != null) {
                    type = ReferencePath.this.jdb.getJClass(schemaType.getStorageId()).getType();
                } else {
                    try {
                        type = Class.forName(typeName, false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Unknown type `" + typeName + "' in reference path reverse traversal step `" + step + "'");
                    }
                }
                List<JClass<?>> jclasses = ReferencePath.this.jdb.getJClasses(type);
                if (type.isAssignableFrom(UntypedJObject.class)) {
                    ArrayList jclasses2 = new ArrayList(jclasses.size() + 1);
                    jclasses2.addAll(jclasses);
                    jclasses2.add(null);
                    jclasses = jclasses2;
                }
                if (jclasses.isEmpty()) {
                    throw new IllegalArgumentException("Invalid type `" + typeName + "' in reference path reverse traversal step `" + step + "': no schema model types are assignable to `" + typeName + "'");
                }
                for (JClass<?> nextJClass : jclasses) {
                    JField nextJField;
                    if (nextJClass == null) continue;
                    ArrayDeque<String> stepFieldNames = new ArrayDeque<String>(Arrays.asList(fieldName.split("\\.")));
                    try {
                        nextJField = ReferencePath.this.findField(nextJClass, stepFieldNames, true);
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    newCursors.add(new Cursor(this.referenceFields, this.pathTypes, nextJClass, nextJField, (ArrayDeque<String>)remainingFieldNames, true));
                }
                if (newCursors.isEmpty()) {
                    throw new IllegalArgumentException("Invalid reference path reverse traversal step `" + step + "': field `" + fieldName + "' does not exist in " + (schemaType == null ? "any model type assignable to " : "") + "`" + typeName + "'");
                }
            } else {
                assert (Pattern.compile(ReferencePath.FWD_STEP).matcher(step).matches()) : "`" + step + "' is not a forward step";
                if (this.jclass != null) {
                    JField nextJField = ReferencePath.this.findField(this.jclass, (ArrayDeque)remainingFieldNames, lastIsSubField);
                    newCursors.add(new Cursor(this.referenceFields, this.pathTypes, this.jclass, nextJField, (ArrayDeque<String>)remainingFieldNames, false));
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("RefPath.identifyNextField(): result=" + newCursors);
            }
            return newCursors;
        }

        public Set<Cursor> stepThroughReference() {
            Class targetType;
            if (this.log.isTraceEnabled()) {
                this.log.trace("RefPath.stepThroughReference(): this=" + this);
            }
            Preconditions.checkState((this.jfield != null ? 1 : 0) != 0, (Object)"have not yet stepped through field");
            assert (this.jfield != null);
            assert (this.reverseStep || this.jfield.parent == this.jclass || this.jfield instanceof JSimpleField && ((JSimpleField)this.jfield).getParentField().parent == this.jclass);
            Preconditions.checkArgument((boolean)(this.jfield instanceof JReferenceField), (Object)(this.jfield + " is not a reference field"));
            int stepStorageId = this.reverseStep ? -this.jfield.storageId : this.jfield.storageId;
            ArrayList newReferenceFields = ReferencePath.copyAndAppend(this.referenceFields, stepStorageId);
            Class clazz = targetType = this.reverseStep ? this.jfield.getJClass().type : ((JReferenceField)this.jfield).typeToken.getRawType();
            if (this.log.isTraceEnabled()) {
                this.log.trace("RefPath.stepThroughReference(): targetType=" + targetType + " -> " + ReferencePath.this.jdb.getJClasses(targetType));
            }
            HashSet<Cursor> newCursors = new HashSet<Cursor>();
            for (JClass targetJClass : ReferencePath.this.jdb.getJClasses(targetType)) {
                ArrayList newPathTypes = ReferencePath.copyAndAppend(this.pathTypes, targetJClass.getType());
                newCursors.add(new Cursor(newReferenceFields, newPathTypes, targetJClass, null, this.fieldNames, false));
            }
            if (targetType.isAssignableFrom(UntypedJObject.class)) {
                ArrayList newPathTypes = ReferencePath.copyAndAppend(this.pathTypes, UntypedJObject.class);
                newCursors.add(new Cursor(newReferenceFields, newPathTypes, null, null, this.fieldNames, false));
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("RefPath.stepThroughReference(): result=" + newCursors);
            }
            return newCursors;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Cursor that = (Cursor)obj;
            return this.referenceFields.equals(that.referenceFields) && this.pathTypes.equals(that.pathTypes) && Objects.equals(this.jclass, that.jclass) && Objects.equals(this.jfield, that.jfield) && this.reverseStep == that.reverseStep;
        }

        public int hashCode() {
            return this.referenceFields.hashCode() ^ this.pathTypes.hashCode() ^ Objects.hashCode(this.jclass) ^ Objects.hashCode(this.jfield) ^ (this.reverseStep ? 1 : 0);
        }

        public String toString() {
            return "Cursor[jclass=" + this.jclass + (this.jfield != null ? ",jfield=" + this.jfield : "") + (!this.fieldNames.isEmpty() ? ",fieldNames=" + this.fieldNames : "") + (!this.referenceFields.isEmpty() ? ",refs=" + this.referenceFields : "") + (!this.pathTypes.isEmpty() ? ",pathTypes=" + this.pathTypes : "") + (this.reverseStep ? ",reverseStep" : "") + "]";
        }
    }
}

