/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.ReferencePath;

class ReferencePathCache {
    private final JSimpleDB jdb;
    private final LoadingCache<Key, ReferencePath> cache;

    ReferencePathCache(JSimpleDB jdb) {
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        this.jdb = jdb;
        this.cache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<Key, ReferencePath>(){

            public ReferencePath load(Key key) {
                return new ReferencePath(ReferencePathCache.this.jdb, key.getStartType(), key.getPath(), key.isWithTargetField(), key.isLastIsSubField());
            }
        });
    }

    public ReferencePath get(Class<?> startType, String path, boolean withTargetField, Boolean lastIsSubField) {
        Throwable cause;
        try {
            return (ReferencePath)this.cache.get((Object)new Key(startType, path, withTargetField, lastIsSubField));
        }
        catch (ExecutionException e) {
            cause = e.getCause() != null ? e.getCause() : e;
        }
        catch (UncheckedExecutionException e) {
            cause = e.getCause() != null ? e.getCause() : e;
        }
        Throwables.throwIfUnchecked((Throwable)cause);
        throw new RuntimeException("internal error", cause);
    }

    private static class Key {
        private final Class<?> startType;
        private final String path;
        private final boolean withTargetField;
        private final Boolean lastIsSubField;

        Key(Class<?> startType, String path, boolean withTargetField, Boolean lastIsSubField) {
            this.startType = startType;
            this.path = path;
            this.withTargetField = withTargetField;
            this.lastIsSubField = lastIsSubField;
        }

        public Class<?> getStartType() {
            return this.startType;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isWithTargetField() {
            return this.withTargetField;
        }

        public Boolean isLastIsSubField() {
            return this.lastIsSubField;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Key that = (Key)obj;
            return this.startType.equals(that.startType) && this.path.equals(that.path) && this.withTargetField == that.withTargetField && Objects.equals(this.lastIsSubField, that.lastIsSubField);
        }

        public int hashCode() {
            return this.startType.hashCode() ^ this.path.hashCode() ^ (this.withTargetField ? 1 : 0) ^ Objects.hashCode(this.lastIsSubField);
        }
    }
}

