/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import java.util.Objects;
import org.jsimpledb.ConvertedIndex;
import org.jsimpledb.ConverterProvider;
import org.jsimpledb.IndexInfo;
import org.jsimpledb.JEnumField;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.FieldType;

abstract class SimpleFieldIndexInfo
extends IndexInfo
implements ConverterProvider {
    private final FieldType<?> fieldType;
    private final Class<? extends Enum<?>> enumType;
    private final ConverterProvider converterProvider;

    SimpleFieldIndexInfo(JSimpleField jfield) {
        super(jfield.storageId);
        assert (jfield.indexed);
        this.fieldType = jfield.fieldType.genericizeForIndex();
        this.enumType = jfield instanceof JEnumField ? ((JEnumField)jfield).getTypeToken().getRawType() : null;
        this.converterProvider = ConverterProvider.identityForNull(jfield::getConverter);
    }

    public FieldType<?> getFieldType() {
        return this.fieldType;
    }

    public Class<? extends Enum<?>> getEnumType() {
        return this.enumType;
    }

    @Override
    public Converter<?, ?> getConverter(JTransaction jtx) {
        return this.converterProvider.getConverter(jtx);
    }

    public Object toIndex(JTransaction jtx) {
        return new ConvertedIndex(jtx.tx.queryIndex(this.storageId), this.getConverter(jtx), jtx.referenceConverter);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SimpleFieldIndexInfo that = (SimpleFieldIndexInfo)obj;
        return this.fieldType.equals(that.fieldType) && Objects.equals(this.enumType, that.enumType);
    }

    public String toString() {
        return this.toStringPrefix() + "]";
    }

    protected String toStringPrefix() {
        return this.getClass().getSimpleName() + "[storageId=" + this.getStorageId() + ",fieldType=" + this.getFieldType() + (this.enumType != null ? ",enumType=" + this.enumType : "");
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.fieldType.hashCode() ^ Objects.hashCode(this.enumType);
    }
}

