/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.change;

import java.util.Objects;
import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.change.ChangeSwitch;
import org.jsimpledb.change.MapFieldChange;

public class MapFieldAdd<T, K, V>
extends MapFieldChange<T> {
    private final K key;
    private final V value;

    public MapFieldAdd(T jobj, int storageId, String fieldName, K key, V value) {
        super(jobj, storageId, fieldName);
        this.key = key;
        this.value = value;
    }

    @Override
    public <R> R visit(ChangeSwitch<R> target) {
        return target.caseMapFieldAdd(this);
    }

    @Override
    public void apply(JTransaction jtx, JObject jobj) {
        jtx.readMapField(jobj.getObjId(), this.getStorageId(), false).put(this.key, this.value);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MapFieldAdd that = (MapFieldAdd)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
    }

    public String toString() {
        return "MapFieldAdd[object=" + this.getObject() + ",field=\"" + this.getFieldName() + "\",key=" + this.key + ",value=" + this.value + "]";
    }
}

