/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.change;

import java.util.Objects;
import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.change.ChangeSwitch;
import org.jsimpledb.change.MapFieldChange;

public class MapFieldReplace<T, K, V>
extends MapFieldChange<T> {
    private final K key;
    private final V oldValue;
    private final V newValue;

    public MapFieldReplace(T jobj, int storageId, String fieldName, K key, V oldValue, V newValue) {
        super(jobj, storageId, fieldName);
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public <R> R visit(ChangeSwitch<R> target) {
        return target.caseMapFieldReplace(this);
    }

    @Override
    public void apply(JTransaction jtx, JObject jobj) {
        jtx.readMapField(jobj.getObjId(), this.getStorageId(), false).put(this.key, this.newValue);
    }

    public K getKey() {
        return this.key;
    }

    public V getOldValue() {
        return this.oldValue;
    }

    public V getNewValue() {
        return this.newValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MapFieldReplace that = (MapFieldReplace)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.key) ^ Objects.hashCode(this.oldValue) ^ Objects.hashCode(this.newValue);
    }

    public String toString() {
        return "MapFieldReplace[object=" + this.getObject() + ",field=\"" + this.getFieldName() + "\",key=" + this.key + ",oldValue=" + this.oldValue + ",newValue=" + this.newValue + "]";
    }
}

