/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mysql;

import com.mysql.cj.jdbc.exceptions.MySQLTimeoutException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.mysql.MySQLKVTransaction;
import org.jsimpledb.kv.sql.SQLKVDatabase;
import org.jsimpledb.kv.sql.SQLKVTransaction;

public class MySQLKVDatabase
extends SQLKVDatabase {
    public static final int INNODB_NORMAL_INDEX_SIZE = 767;
    public static final int INNODB_LARGE_INDEX_SIZE = 3072;
    private static final int DEFAULT_LOCK_TIMEOUT = 3;
    private boolean innodbLargePrefix;
    private int lockTimeout = 3;

    public void setInnodbLargePrefix(boolean innodbLargePrefix) {
        this.innodbLargePrefix = innodbLargePrefix;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    protected void initializeDatabaseIfNecessary(Connection connection) throws SQLException {
        int indexSize = this.innodbLargePrefix ? 3072 : 767;
        String rowFormat = this.innodbLargePrefix ? " ROW_FORMAT=DYNAMIC" : "";
        String sql = "CREATE TABLE IF NOT EXISTS " + this.quote(this.getTableName()) + " (\n  " + this.quote(this.getKeyColumnName()) + " VARBINARY(" + indexSize + ") NOT NULL,\n  " + this.quote(this.getValueColumnName()) + " LONGBLOB NOT NULL,\n  PRIMARY KEY(" + this.quote(this.getKeyColumnName()) + ")\n) ENGINE=InnoDB default charset=utf8 collate=utf8_bin" + rowFormat;
        try (Statement statement = connection.createStatement();){
            this.log.debug("auto-creating table `" + this.getTableName() + "' if not already existing:\n{}", (Object)sql);
            statement.execute(sql);
        }
    }

    protected void configureConnection(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("SET innodb_lock_wait_timeout = " + this.lockTimeout);
            statement.execute("SET SESSION sql_mode = 'TRADITIONAL'");
        }
    }

    protected SQLKVTransaction createSQLKVTransaction(Connection connection) throws SQLException {
        return new MySQLKVTransaction(this, connection);
    }

    public String quote(String name) {
        return "`" + name + "`";
    }

    public String limitSingleRow(String sql) {
        return sql + " LIMIT 1";
    }

    public KVTransactionException wrapException(SQLKVTransaction tx, SQLException e) {
        switch (e.getErrorCode()) {
            case 1205: {
                return new RetryTransactionException((KVTransaction)tx, (Throwable)e);
            }
            case 1213: {
                return new RetryTransactionException((KVTransaction)tx, (Throwable)e);
            }
        }
        if (e instanceof MySQLTimeoutException) {
            return new RetryTransactionException((KVTransaction)tx, (Throwable)e);
        }
        return super.wrapException(tx, e);
    }
}

