/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.array;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.util.ByteUtil;

class ArrayKVFinder {
    private final ByteBuffer indx;
    private final ByteBuffer keys;
    private final ByteBuffer vals;
    private final int size;

    ArrayKVFinder(ByteBuffer indx, ByteBuffer keys, ByteBuffer vals) {
        Preconditions.checkArgument((indx.capacity() % 8 == 0 ? 1 : 0) != 0, (Object)"index size is not a multiple of 8");
        this.indx = indx.duplicate();
        this.keys = keys.duplicate();
        this.vals = vals.duplicate();
        this.indx.limit(this.indx.capacity());
        this.keys.limit(this.keys.capacity());
        this.vals.limit(this.vals.capacity());
        this.size = this.indx.capacity() / 8;
    }

    public int find(byte[] searchKey) {
        int min = 0;
        int max = this.size;
        byte[] prevMin = null;
        byte[] prevMax = null;
        while (min < max) {
            int mid = min + (max - 1) >>> 1;
            byte[] midKey = this.readKey(mid);
            assert (prevMin == null || ByteUtil.compare((byte[])searchKey, prevMin) > 0);
            assert (prevMax == null || ByteUtil.compare((byte[])searchKey, prevMax) < 0);
            int diff = ByteUtil.compare((byte[])searchKey, (byte[])midKey);
            if (diff == 0) {
                return mid;
            }
            if (diff < 0) {
                prevMax = midKey;
                max = mid;
                continue;
            }
            prevMin = midKey;
            min = mid + 1;
        }
        return ~min;
    }

    public byte[] readKey(int index) {
        int nextOffset;
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index < 0");
        Preconditions.checkArgument((index < this.size ? 1 : 0) != 0, (Object)"index >= size");
        int baseIndex = index & 0xFFFFFFE0;
        int baseKeyOffset = this.indx.getInt(baseIndex * 8);
        if (index == baseIndex) {
            int length = index + 1 < this.size ? this.indx.getInt((index + 1) * 8) & 0xFFFFFF : this.keys.capacity() - baseKeyOffset;
            return this.get(this.keys, baseKeyOffset, new byte[length], 0, length);
        }
        int encodedValue = this.indx.getInt(index * 8);
        int prefixLen = encodedValue >>> 24;
        int suffixOffset = baseKeyOffset + (encodedValue & 0xFFFFFF);
        int nextIndex = index + 1;
        if (nextIndex < this.size) {
            nextOffset = this.indx.getInt(nextIndex * 8);
            if ((nextIndex & 0x1F) != 0) {
                nextOffset = baseKeyOffset + (nextOffset & 0xFFFFFF);
            }
        } else {
            nextOffset = this.keys.capacity();
        }
        int suffixLen = nextOffset - suffixOffset;
        byte[] key = new byte[prefixLen + suffixLen];
        if (prefixLen > 0) {
            this.get(this.keys, baseKeyOffset, key, 0, prefixLen);
        }
        assert (suffixLen > 0);
        return this.get(this.keys, suffixOffset, key, prefixLen, suffixLen);
    }

    public byte[] readValue(int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index < 0");
        Preconditions.checkArgument((index < this.size ? 1 : 0) != 0, (Object)"index >= size");
        int dataOffset = this.indx.getInt(index * 8 + 4);
        int nextOffset = index + 1 < this.size ? this.indx.getInt((index + 1) * 8 + 4) : this.vals.capacity();
        int length = nextOffset - dataOffset;
        return this.get(this.vals, dataOffset, new byte[length], 0, length);
    }

    public KVPair readKV(int index) {
        return new KVPair(this.readKey(index), this.readValue(index));
    }

    protected byte[] get(ByteBuffer buf, int position, byte[] dest, int off, int len) {
        if (buf.hasArray()) {
            System.arraycopy(buf.array(), buf.arrayOffset() + position, dest, off, len);
        } else if (len < 128) {
            while (len-- > 0) {
                dest[off++] = buf.get(position++);
            }
        } else {
            ((ByteBuffer)buf.duplicate().position(position)).get(dest, off, len);
        }
        return dest;
    }
}

