/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.array;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.util.ByteUtil;

public class ArrayKVWriter
implements Closeable {
    private static final int BUFFER_SIZE = 0x100000;
    private static final int MERGE_KV = 1;
    private static final int MERGE_PUT = 2;
    private static final int MERGE_ADJUST = 4;
    private final BufferedOutputStream indxOutput;
    private final BufferedOutputStream keysOutput;
    private final BufferedOutputStream valsOutput;
    private int keysLength;
    private int valsLength;
    private int nextIndex;
    private byte[] prevKey;
    private byte[] baseKey;
    private int baseKeyOffset;
    private boolean closed;

    public ArrayKVWriter(OutputStream indxOutput, OutputStream keysOutput, OutputStream valsOutput) {
        Preconditions.checkArgument((indxOutput != null ? 1 : 0) != 0, (Object)"null indxOutput");
        Preconditions.checkArgument((keysOutput != null ? 1 : 0) != 0, (Object)"null keysOutput");
        Preconditions.checkArgument((valsOutput != null ? 1 : 0) != 0, (Object)"null valsOutput");
        this.indxOutput = new BufferedOutputStream(indxOutput, 0x100000);
        this.keysOutput = new BufferedOutputStream(keysOutput, 0x100000);
        this.valsOutput = new BufferedOutputStream(valsOutput, 0x100000);
    }

    public int getIndxLength() {
        return this.nextIndex * 8;
    }

    public int getKeysLength() {
        return this.keysLength;
    }

    public int getValsLength() {
        return this.valsLength;
    }

    public void writeKV(byte[] key, byte[] val) throws IOException {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        Preconditions.checkArgument((val != null ? 1 : 0) != 0, (Object)"null value");
        Preconditions.checkArgument((this.prevKey == null || ByteUtil.compare((byte[])key, (byte[])this.prevKey) > 0 ? 1 : 0) != 0, (Object)"key <= previous key");
        Preconditions.checkState((this.nextIndex * 8 + 8 > 0 ? 1 : 0) != 0, (Object)"too much index data");
        Preconditions.checkState((this.keysLength == 0 || this.keysLength + key.length > 0 ? 1 : 0) != 0, (Object)"too much key data");
        Preconditions.checkState((this.valsLength == 0 || this.valsLength + val.length > 0 ? 1 : 0) != 0, (Object)"too much value data");
        if ((this.nextIndex & 0x1F) == 0) {
            this.writeIndxValue(this.keysLength);
            this.baseKeyOffset = this.keysLength;
            this.baseKey = this.cloneOrCopy(this.baseKey, key);
            this.keysOutput.write(key);
            this.keysLength += key.length;
        } else {
            int prefixLength;
            int maxPrefixLength = Math.min(Math.min(this.baseKey.length, key.length), 255);
            for (prefixLength = 0; prefixLength < maxPrefixLength && key[prefixLength] == this.baseKey[prefixLength]; ++prefixLength) {
            }
            int suffixLength = key.length - prefixLength;
            assert (suffixLength > 0);
            int suffixRelativeOffset = this.keysLength - this.baseKeyOffset;
            Preconditions.checkState(((suffixRelativeOffset & 0xFF000000) == 0 ? 1 : 0) != 0, (Object)"key(s) too long");
            this.writeIndxValue(prefixLength << 24 | suffixRelativeOffset);
            this.keysOutput.write(key, prefixLength, suffixLength);
            this.keysLength += suffixLength;
        }
        this.writeIndxValue(this.valsLength);
        this.valsOutput.write(val);
        this.valsLength += val.length;
        this.prevKey = this.cloneOrCopy(this.prevKey, key);
        ++this.nextIndex;
    }

    public void writeMerged(KVStore kvstore, Iterator<KVPair> kvIterator, Mutations mutations) throws IOException {
        Preconditions.checkArgument((kvstore != null ? 1 : 0) != 0, (Object)"null kvstore");
        Preconditions.checkArgument((kvIterator != null ? 1 : 0) != 0, (Object)"null kvIterator");
        Preconditions.checkArgument((mutations != null ? 1 : 0) != 0, (Object)"null mutations");
        Iterator removeIterator = mutations.getRemoveRanges().iterator();
        Iterator putIterator = mutations.getPutPairs().iterator();
        Iterator adjustIterator = mutations.getAdjustPairs().iterator();
        KVPair kv = kvIterator.hasNext() ? kvIterator.next() : null;
        KeyRange remove = removeIterator.hasNext() ? (KeyRange)removeIterator.next() : null;
        Map.Entry put = putIterator.hasNext() ? (Map.Entry)putIterator.next() : null;
        Map.Entry adjust = adjustIterator.hasNext() ? (Map.Entry)adjustIterator.next() : null;
        while (true) {
            KeyRange next;
            byte[] removeMax;
            byte[] key = null;
            if (kv != null) {
                key = kv.getKey();
            }
            if (put != null && (key == null || ByteUtil.compare((byte[])((byte[])put.getKey()), (byte[])key) < 0)) {
                key = (byte[])put.getKey();
            }
            if (adjust != null && (key == null || ByteUtil.compare((byte[])((byte[])adjust.getKey()), (byte[])key) < 0)) {
                key = (byte[])adjust.getKey();
            }
            if (key == null) break;
            int inputs = 0;
            if (kv != null && Arrays.equals(kv.getKey(), key)) {
                inputs |= 1;
            }
            if (put != null && Arrays.equals((byte[])put.getKey(), key)) {
                inputs |= 2;
            }
            if (adjust != null && Arrays.equals((byte[])adjust.getKey(), key)) {
                inputs |= 4;
            }
            while (remove != null && (removeMax = remove.getMax()) != null && ByteUtil.compare((byte[])removeMax, (byte[])key) <= 0) {
                KeyRange keyRange = next = removeIterator.hasNext() ? (KeyRange)removeIterator.next() : null;
                assert (next == null || ByteUtil.compare((byte[])next.getMin(), (byte[])removeMax) > 0);
                remove = next;
            }
            boolean removed = remove != null && ByteUtil.compare((byte[])remove.getMin(), (byte[])key) <= 0;
            switch (inputs) {
                case 0: {
                    break;
                }
                case 1: {
                    if (removed) break;
                    this.writeKV(kv.getKey(), kv.getValue());
                    break;
                }
                case 2: 
                case 3: {
                    this.writeKV((byte[])put.getKey(), (byte[])put.getValue());
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (removed) break;
                }
                case 6: 
                case 7: {
                    long counter;
                    byte[] encodedCount = (inputs & 2) != 0 ? (byte[])put.getValue() : kv.getValue();
                    try {
                        counter = kvstore.decodeCounter(encodedCount);
                    }
                    catch (IllegalArgumentException e) {
                        break;
                    }
                    byte[] value = kvstore.encodeCounter(counter + (Long)adjust.getValue());
                    this.writeKV(key, value);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if ((inputs & 1) != 0) {
                assert (kv != null);
                KVPair kVPair = next = kvIterator.hasNext() ? kvIterator.next() : null;
                assert (next == null || ByteUtil.compare((byte[])next.getKey(), (byte[])kv.getKey()) > 0);
                kv = next;
            }
            if ((inputs & 2) != 0) {
                assert (put != null);
                Map.Entry entry = next = putIterator.hasNext() ? (Map.Entry)putIterator.next() : null;
                assert (next == null || ByteUtil.compare((byte[])((byte[])next.getKey()), (byte[])((byte[])put.getKey())) > 0);
                put = next;
            }
            if ((inputs & 4) == 0) continue;
            assert (adjust != null);
            Map.Entry entry = next = adjustIterator.hasNext() ? (Map.Entry)adjustIterator.next() : null;
            assert (next == null || ByteUtil.compare((byte[])((byte[])next.getKey()), (byte[])((byte[])adjust.getKey())) > 0);
            adjust = next;
        }
        for (Iterator i : new Iterator[]{removeIterator, putIterator, adjustIterator}) {
            if (!(i instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)i)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void writeIndxValue(int offset) throws IOException {
        this.indxOutput.write(offset >> 24);
        this.indxOutput.write(offset >> 16);
        this.indxOutput.write(offset >> 8);
        this.indxOutput.write(offset);
    }

    public void flush() throws IOException {
        this.indxOutput.flush();
        this.keysOutput.flush();
        this.valsOutput.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.indxOutput.close();
        this.keysOutput.close();
        this.valsOutput.close();
    }

    private byte[] cloneOrCopy(byte[] dest, byte[] src) {
        assert (src != null);
        if (dest == null || dest.length != src.length) {
            return (byte[])src.clone();
        }
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }
}

