/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.raft.RaftKVTransaction;
import org.jsimpledb.kv.raft.Role;
import org.jsimpledb.kv.raft.Service;

abstract class AbstractTransactionService
extends Service {
    protected final RaftKVTransaction tx;

    AbstractTransactionService(Role role, RaftKVTransaction tx, String desc) {
        super(role, desc);
        assert (tx != null);
        this.tx = tx;
    }

    @Override
    public final void run() {
        assert (Thread.holdsLock(this.role.raft));
        try {
            this.doRun();
        }
        catch (KVTransactionException e) {
            this.role.raft.fail(this.tx, e);
        }
        catch (Exception e) {
            this.role.raft.error("error performing " + this.getClass().getSimpleName() + " on " + this.tx, e);
            this.role.raft.fail(this.tx, new KVTransactionException((KVTransaction)this.tx, (Throwable)e));
        }
    }

    protected abstract void doRun();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractTransactionService that = (AbstractTransactionService)obj;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }
}

