/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

class FileWriter
extends FilterOutputStream {
    private final File file;
    private final FileOutputStream fileOutput;
    private final boolean disableSync;
    private long length;

    FileWriter(File file, boolean disableSync) throws IOException {
        super(null);
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"null file");
        this.file = file;
        this.fileOutput = new FileOutputStream(file);
        this.out = new BufferedOutputStream(this.fileOutput, 4096);
        this.disableSync = disableSync;
    }

    public File getFile() {
        return this.file;
    }

    public FileOutputStream getFileOutputStream() {
        return this.fileOutput;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public void write(int value) throws IOException {
        this.out.write(value);
        ++this.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.length += (long)len;
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        if (!this.disableSync) {
            this.fileOutput.getChannel().force(false);
        }
        this.out.close();
    }
}

