/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import java.util.Comparator;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.concurrent.GuardedBy;
import org.jsimpledb.kv.raft.LogEntry;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.SnapshotTransmit;
import org.jsimpledb.kv.raft.Timer;
import org.jsimpledb.kv.raft.Timestamp;

public class Follower {
    public static final Comparator<Follower> SORT_BY_IDENTITY = Comparator.comparing(Follower::getIdentity);
    private final RaftKVDatabase raft;
    private final String identity;
    private final String address;
    @GuardedBy(value="raft")
    private Timer updateTimer;
    @GuardedBy(value="raft")
    private final HashSet<LogEntry> skipDataLogEntries = new HashSet();
    @GuardedBy(value="raft")
    private final TreeSet<Timestamp> commitLeaseTimeouts = new TreeSet();
    @GuardedBy(value="raft")
    private long nextIndex;
    @GuardedBy(value="raft")
    private long matchIndex;
    @GuardedBy(value="raft")
    private long leaderCommit;
    @GuardedBy(value="raft")
    private Timestamp leaderTimestamp;
    @GuardedBy(value="raft")
    private Timestamp snapshotTimestamp;
    @GuardedBy(value="raft")
    private boolean synced;
    @GuardedBy(value="raft")
    private SnapshotTransmit snapshotTransmit;

    Follower(RaftKVDatabase raft, String identity, String address, long lastLogIndex) {
        assert (raft != null);
        assert (identity != null);
        assert (address != null);
        assert (lastLogIndex >= 0L);
        this.raft = raft;
        this.identity = identity;
        this.address = address;
        this.nextIndex = lastLogIndex + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdentity() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.identity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAddress() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.address;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextIndex() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.nextIndex;
        }
    }

    void setNextIndex(long nextIndex) {
        assert (Thread.holdsLock(this.raft));
        this.nextIndex = nextIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMatchIndex() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.matchIndex;
        }
    }

    void setMatchIndex(long matchIndex) {
        assert (Thread.holdsLock(this.raft));
        this.matchIndex = matchIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getLeaderTimestamp() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.leaderTimestamp;
        }
    }

    void setLeaderTimestamp(Timestamp leaderTimestamp) {
        assert (Thread.holdsLock(this.raft));
        this.leaderTimestamp = leaderTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getSnapshotTimestamp() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.snapshotTimestamp;
        }
    }

    void setSnapshotTimestamp(Timestamp snapshotTimestamp) {
        assert (Thread.holdsLock(this.raft));
        this.snapshotTimestamp = snapshotTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLeaderCommit() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.leaderCommit;
        }
    }

    void setLeaderCommit(long leaderCommit) {
        assert (Thread.holdsLock(this.raft));
        this.leaderCommit = leaderCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSynced() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.synced;
        }
    }

    void setSynced(boolean synced) {
        assert (Thread.holdsLock(this.raft));
        this.synced = synced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReceivingSnapshot() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.snapshotTransmit != null;
        }
    }

    boolean hasLogEntry(long index) {
        assert (Thread.holdsLock(this.raft));
        return this.matchIndex >= index && this.raft.isClusterMember(this.identity);
    }

    SnapshotTransmit getSnapshotTransmit() {
        assert (Thread.holdsLock(this.raft));
        return this.snapshotTransmit;
    }

    void setSnapshotTransmit(SnapshotTransmit snapshotTransmit) {
        assert (Thread.holdsLock(this.raft));
        this.snapshotTransmit = snapshotTransmit;
    }

    Set<LogEntry> getSkipDataLogEntries() {
        assert (Thread.holdsLock(this.raft));
        return this.skipDataLogEntries;
    }

    NavigableSet<Timestamp> getCommitLeaseTimeouts() {
        assert (Thread.holdsLock(this.raft));
        return this.commitLeaseTimeouts;
    }

    Timer getUpdateTimer() {
        assert (Thread.holdsLock(this.raft));
        return this.updateTimer;
    }

    void setUpdateTimer(Timer updateTimer) {
        assert (Thread.holdsLock(this.raft));
        this.updateTimer = updateTimer;
    }

    void updateNow() {
        assert (Thread.holdsLock(this.raft));
        this.updateTimer.timeoutNow();
    }

    void cancelSnapshotTransmit() {
        assert (Thread.holdsLock(this.raft));
        if (this.snapshotTransmit != null) {
            this.matchIndex = Math.min(this.matchIndex, this.snapshotTransmit.getSnapshotIndex());
            this.snapshotTransmit.close();
            this.snapshotTransmit = null;
            this.synced = false;
        }
    }

    void cleanup() {
        assert (Thread.holdsLock(this.raft));
        this.cancelSnapshotTransmit();
        this.updateTimer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.getClass().getSimpleName() + "[identity=\"" + this.identity + "\",nextIndex=" + this.nextIndex + ",matchIndex=" + this.matchIndex + ",leaderCommit=" + this.leaderCommit + (this.leaderTimestamp != null ? ",leaderTimestamp=" + String.format("%+dms", this.leaderTimestamp.offsetFromNow()) : "") + ",synced=" + this.synced + (!this.skipDataLogEntries.isEmpty() ? ",skipDataLogEntries=" + this.skipDataLogEntries : "") + (this.snapshotTransmit != null ? ",snapshotTransmit=" + this.snapshotTransmit : "") + "]";
        }
    }
}

