/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;
import org.dellroad.stuff.io.ByteBufferInputStream;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.kv.mvcc.Reads;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.raft.Follower;
import org.jsimpledb.kv.raft.FollowerRole;
import org.jsimpledb.kv.raft.LogEntry;
import org.jsimpledb.kv.raft.MostRecentView;
import org.jsimpledb.kv.raft.NewLogEntry;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.RaftKVTransaction;
import org.jsimpledb.kv.raft.Role;
import org.jsimpledb.kv.raft.Service;
import org.jsimpledb.kv.raft.SnapshotTransmit;
import org.jsimpledb.kv.raft.Timer;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.msg.AppendRequest;
import org.jsimpledb.kv.raft.msg.AppendResponse;
import org.jsimpledb.kv.raft.msg.CommitRequest;
import org.jsimpledb.kv.raft.msg.CommitResponse;
import org.jsimpledb.kv.raft.msg.GrantVote;
import org.jsimpledb.kv.raft.msg.InstallSnapshot;
import org.jsimpledb.kv.raft.msg.Message;
import org.jsimpledb.kv.raft.msg.RequestVote;

public class LeaderRole
extends Role {
    private static final int TIMESTAMP_SCRUB_INTERVAL = 86400000;
    @GuardedBy(value="raft")
    private final HashMap<String, Follower> followerMap = new HashMap();
    @GuardedBy(value="raft")
    private Timestamp leaseTimeout;
    private final Service updateLeaderCommitIndexService = new Service(this, "update leader commitIndex"){

        @Override
        public void run() {
            LeaderRole.this.updateLeaderCommitIndex();
        }
    };
    private final Service updateLeaseTimeoutService = new Service(this, "update lease timeout"){

        @Override
        public void run() {
            LeaderRole.this.updateLeaseTimeout();
        }
    };
    private final Service updateKnownFollowersService = new Service(this, "update known followers"){

        @Override
        public void run() {
            LeaderRole.this.updateKnownFollowers();
        }
    };
    private final Timer checkApplyTimer = new Timer(this.raft, "check apply entries", new Service(this, "check apply entries"){

        @Override
        public void run() {
            LeaderRole.this.checkApplyEntries();
        }
    });
    private final Timer timestampScrubTimer = new Timer(this.raft, "scrub timestamps", new Service(this, "scrub timestamps"){

        @Override
        public void run() {
            LeaderRole.this.scrubTimestamps();
        }
    });

    LeaderRole(RaftKVDatabase raft) {
        super(raft);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Follower> getFollowers() {
        ArrayList<Follower> list;
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            list = new ArrayList<Follower>(this.followerMap.values());
        }
        Collections.sort(list, Follower.SORT_BY_IDENTITY);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getLeaseTimeout() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.leaseTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepDown() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            Preconditions.checkState((this.raft.role == this ? 1 : 0) != 0, (Object)"role is no longer active");
            this.debug("stepping down as leader due to invocation of stepDown()");
            this.raft.changeRole(new FollowerRole(this.raft));
        }
    }

    @Override
    void setup() {
        LogEntry logEntry;
        assert (Thread.holdsLock(this.raft));
        super.setup();
        if (this.log.isDebugEnabled()) {
            this.debug("entering leader role in term " + this.raft.currentTerm);
        }
        this.updateKnownFollowers();
        try {
            logEntry = this.applyNewLogEntry(new NewLogEntry(this.raft, new LogEntry.Data(new Writes(), null)));
        }
        catch (Exception e) {
            this.error("error attempting to apply initial log entry", e);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.debug("added log entry " + logEntry + " to commit at the beginning of my new term");
        }
        this.rebaseTransactions();
        if (!this.raft.raftLog.isEmpty()) {
            this.checkApplyTimer.timeoutAfter(this.raft.heartbeatTimeout);
        }
        this.timestampScrubTimer.timeoutAfter(86400000);
    }

    @Override
    void shutdown() {
        assert (Thread.holdsLock(this.raft));
        this.followerMap.values().forEach(Follower::cleanup);
        this.checkApplyTimer.cancel();
        this.timestampScrubTimer.cancel();
        super.shutdown();
    }

    @Override
    void outputQueueEmpty(String address) {
        assert (Thread.holdsLock(this.raft));
        this.followerMap.values().stream().filter(follower -> follower.getAddress().equals(address)).forEach(follower -> {
            if (this.log.isTraceEnabled()) {
                this.trace("updating peer \"" + follower.getIdentity() + "\" after queue empty notification");
            }
            this.raft.requestService(new UpdateFollowerService((Follower)follower));
        });
    }

    @Override
    void applyCommittedLogEntries() {
        assert (Thread.holdsLock(this.raft));
        super.applyCommittedLogEntries();
        if (this.raft.raftLog.isEmpty() && this.checkApplyTimer.isRunning()) {
            this.checkApplyTimer.cancel();
        }
    }

    @Override
    boolean roleMayApplyLogEntry(LogEntry logEntry) {
        assert (Thread.holdsLock(this.raft));
        for (Follower follower : this.followerMap.values()) {
            SnapshotTransmit snapshotTransmit = follower.getSnapshotTransmit();
            if (snapshotTransmit == null || snapshotTransmit.getSnapshotIndex() >= logEntry.getIndex() || snapshotTransmit.getAge() >= RaftKVDatabase.MAX_SNAPSHOT_TRANSMIT_AGE) continue;
            if (this.log.isTraceEnabled()) {
                this.trace("delaying application of " + logEntry + " because of in-progress snapshot install of " + snapshotTransmit.getSnapshotIndex() + "t" + snapshotTransmit.getSnapshotTerm() + " to " + follower);
            }
            return false;
        }
        int maxLogEntryAge = this.raft.maxFollowerAckHeartbeats * this.raft.heartbeatTimeout;
        if (logEntry.getAge() < maxLogEntryAge) {
            Timestamp minLeaderTimestamp = new Timestamp().offset(-maxLogEntryAge);
            for (Follower follower : this.followerMap.values()) {
                Timestamp leaderTimestamp;
                if (follower.getMatchIndex() >= logEntry.getIndex() || (leaderTimestamp = follower.getLeaderTimestamp()) == null || leaderTimestamp.compareTo(minLeaderTimestamp) <= 0) continue;
                if (this.log.isTraceEnabled()) {
                    this.trace("delaying application of " + logEntry + " (age " + logEntry.getAge() + " < " + maxLogEntryAge + ") because of slow " + follower);
                }
                return false;
            }
        }
        return true;
    }

    private void checkApplyEntries() {
        assert (Thread.holdsLock(this.raft));
        this.raft.requestService(this.checkWaitingTransactionsService);
        this.raft.requestService(this.applyCommittedLogEntriesService);
        if (!this.raft.raftLog.isEmpty()) {
            this.checkApplyTimer.timeoutAfter(this.raft.heartbeatTimeout);
        }
    }

    private void updateLeaderCommitIndex() {
        assert (Thread.holdsLock(this.raft));
        int totalCount = this.raft.currentConfig.size();
        int requiredCount = totalCount / 2 + 1;
        int startingCount = this.raft.isClusterMember() ? 1 : 0;
        long maxCommitIndex = this.raft.commitIndex;
        int commitCount = -1;
        for (long index = this.raft.commitIndex + 1L; index <= this.raft.getLastLogIndex(); ++index) {
            int count = startingCount + this.countFollowersWithLogEntry(index);
            long term = this.raft.getLogTermAtIndex(index);
            if (count < totalCount && term != this.raft.currentTerm) continue;
            if (count < requiredCount) {
                if (term < this.raft.currentTerm) continue;
                break;
            }
            maxCommitIndex = index;
            commitCount = count;
        }
        if (maxCommitIndex > this.raft.commitIndex) {
            if (this.log.isDebugEnabled()) {
                this.debug("advancing commit index from " + this.raft.commitIndex + " -> " + maxCommitIndex + " based on " + commitCount + "/" + totalCount + " nodes having received " + this.raft.getLogEntryAtIndex(maxCommitIndex));
            }
            this.raft.commitIndex = maxCommitIndex;
            this.checkCommittables();
            this.raft.requestService(this.checkReadyTransactionsService);
            this.raft.requestService(this.checkWaitingTransactionsService);
            this.raft.requestService(this.triggerKeyWatchesService);
            this.raft.requestService(this.applyCommittedLogEntriesService);
            this.updateAllSynchronizedFollowersNow();
            if (!this.raft.isClusterMember() && this.raft.commitIndex >= this.findMostRecentConfigChange()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("stepping down as leader of cluster (no longer a member)");
                }
                this.stepDown();
            }
        }
    }

    private int countFollowersWithLogEntry(long index) {
        assert (index <= this.raft.getLastLogIndex());
        int nodesWithLogEntry = 0;
        for (Follower follower : this.followerMap.values()) {
            if (!follower.hasLogEntry(index)) continue;
            ++nodesWithLogEntry;
        }
        return nodesWithLogEntry;
    }

    private void updateLeaseTimeout() {
        assert (Thread.holdsLock(this.raft));
        int numFollowers = this.followerMap.size();
        if (numFollowers == 0) {
            return;
        }
        Timestamp[] leaderTimestamps = new Timestamp[this.raft.currentConfig.size()];
        int index = 0;
        if (this.raft.isClusterMember()) {
            leaderTimestamps[index++] = new Timestamp();
        }
        for (Follower follower : this.followerMap.values()) {
            if (!this.raft.isClusterMember(follower.getIdentity())) continue;
            leaderTimestamps[index++] = follower.getLeaderTimestamp();
        }
        Arrays.sort(leaderTimestamps, Timestamp.NULL_FIRST_SORT);
        Timestamp newLeaseTimeout = leaderTimestamps[(leaderTimestamps.length + 1) / 2].offset((int)((float)this.raft.minElectionTimeout * 0.99f - 1.0f));
        if (Timestamp.NULL_FIRST_SORT.compare(newLeaseTimeout, this.leaseTimeout) > 0) {
            assert (newLeaseTimeout != null);
            if (this.log.isTraceEnabled()) {
                this.trace("updating my lease timeout from " + this.leaseTimeout + " -> " + newLeaseTimeout);
            }
            this.leaseTimeout = newLeaseTimeout;
            for (Follower follower : this.followerMap.values()) {
                NavigableSet<Timestamp> timeouts = follower.getCommitLeaseTimeouts().headSet(this.leaseTimeout, true);
                if (timeouts.isEmpty()) continue;
                follower.updateNow();
                timeouts.clear();
            }
        }
    }

    private void scrubTimestamps() {
        assert (Thread.holdsLock(this.raft));
        if (this.log.isTraceEnabled()) {
            this.trace("scrubbing timestamps");
        }
        for (Follower follower : this.followerMap.values()) {
            Timestamp snapshotTimestamp;
            Timestamp leaderTimestamp = follower.getLeaderTimestamp();
            if (leaderTimestamp != null && leaderTimestamp.isRolloverDanger()) {
                if (this.log.isDebugEnabled()) {
                    this.debug("scrubbing " + follower + " leader timestamp " + leaderTimestamp);
                }
                follower.setLeaderTimestamp(null);
            }
            if ((snapshotTimestamp = follower.getSnapshotTimestamp()) != null && snapshotTimestamp.isRolloverDanger()) {
                if (this.log.isDebugEnabled()) {
                    this.debug("scrubbing " + follower + " snapshot timestamp " + snapshotTimestamp);
                }
                follower.setSnapshotTimestamp(null);
            }
            Iterator<Timestamp> i = follower.getCommitLeaseTimeouts().iterator();
            while (i.hasNext()) {
                Timestamp leaseTimestamp = i.next();
                if (!leaseTimestamp.isRolloverDanger()) continue;
                if (this.log.isDebugEnabled()) {
                    this.debug("scrubbing " + follower + " commit lease timestamp " + leaseTimestamp);
                }
                i.remove();
            }
        }
        if (this.leaseTimeout != null && this.leaseTimeout.isRolloverDanger()) {
            if (this.log.isDebugEnabled()) {
                this.debug("scrubbing leader lease timestamp " + this.leaseTimeout);
            }
            this.leaseTimeout = null;
        }
    }

    private void updateKnownFollowers() {
        assert (Thread.holdsLock(this.raft));
        HashSet<String> adds = new HashSet<String>(this.raft.currentConfig.keySet());
        adds.removeAll(this.followerMap.keySet());
        adds.remove(this.raft.identity);
        HashSet<String> dels = new HashSet<String>(this.followerMap.keySet());
        dels.removeAll(this.raft.currentConfig.keySet());
        for (Follower follower : this.followerMap.values()) {
            String peer = follower.getIdentity();
            if (!dels.contains(peer)) continue;
            String node = follower.getIdentity();
            long index = this.findMostRecentConfigChangeMatching(configChange -> configChange[0].equals(node) && configChange[1] == null);
            if (follower.getMatchIndex() >= index) continue;
            dels.remove(peer);
        }
        for (String peer : adds) {
            String address = this.raft.currentConfig.get(peer);
            Follower follower = new Follower(this.raft, peer, address, this.raft.getLastLogIndex());
            if (this.log.isDebugEnabled()) {
                this.debug("adding new follower \"" + peer + "\" at " + address);
            }
            follower.setUpdateTimer(new Timer(this.raft, "update timer for \"" + peer + "\"", new UpdateFollowerService(follower)));
            this.followerMap.put(peer, follower);
            follower.updateNow();
        }
        for (String peer : dels) {
            Follower follower = this.followerMap.remove(peer);
            if (this.log.isDebugEnabled()) {
                this.debug("removing old follower \"" + peer + "\"");
            }
            follower.cleanup();
        }
    }

    private void updateFollower(Follower follower) {
        AppendRequest msg;
        long nextIndex;
        assert (Thread.holdsLock(this.raft));
        String peer = follower.getIdentity();
        SnapshotTransmit snapshotTransmit = follower.getSnapshotTransmit();
        if (snapshotTransmit != null && snapshotTransmit.getSnapshotIndex() < this.raft.lastAppliedIndex) {
            if (this.log.isDebugEnabled()) {
                this.debug("aborting stale snapshot install for " + follower);
            }
            follower.cancelSnapshotTransmit();
            follower.updateNow();
        }
        if (this.raft.isTransmitting(follower.getAddress())) {
            if (this.log.isTraceEnabled()) {
                this.trace("no update for \"" + peer + "\": output queue still not empty");
            }
            return;
        }
        snapshotTransmit = follower.getSnapshotTransmit();
        if (snapshotTransmit != null) {
            long pairIndex = snapshotTransmit.getPairIndex();
            ByteBuffer chunk = snapshotTransmit.getNextChunk();
            boolean synced = true;
            if (chunk != null) {
                InstallSnapshot msg2 = new InstallSnapshot(this.raft.clusterId, this.raft.identity, peer, this.raft.currentTerm, snapshotTransmit.getSnapshotTerm(), snapshotTransmit.getSnapshotIndex(), pairIndex, pairIndex == 0L ? snapshotTransmit.getSnapshotConfig() : null, !snapshotTransmit.hasMoreChunks(), chunk);
                if (this.raft.sendMessage(msg2)) {
                    follower.setSnapshotTimestamp(new Timestamp());
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.debug("canceling snapshot install for " + follower + " due to failure to send " + msg2);
                }
                synced = false;
            }
            if (synced && this.log.isDebugEnabled()) {
                this.debug("completed snapshot install for out-of-date " + follower);
            }
            follower.cancelSnapshotTransmit();
            follower.setNextIndex(snapshotTransmit.getSnapshotIndex() + 1L);
            follower.setSynced(synced);
            follower.updateNow();
            this.raft.requestService(new UpdateFollowerService(follower));
            return;
        }
        if (!follower.getUpdateTimer().pollForTimeout()) {
            boolean waitForTimerToExpire = true;
            if (follower.isSynced() && (follower.getLeaderCommit() != this.raft.commitIndex || follower.getNextIndex() <= this.raft.getLastLogIndex())) {
                waitForTimerToExpire = false;
            }
            if (waitForTimerToExpire) {
                if (this.log.isTraceEnabled()) {
                    this.trace("no update for \"" + follower.getIdentity() + "\": timer not expired yet, and follower is " + (follower.isSynced() ? "up to date" : "not synced"));
                }
                return;
            }
        }
        if ((nextIndex = follower.getNextIndex()) <= this.raft.lastAppliedIndex) {
            MostRecentView view = new MostRecentView(this.raft, this.raft.commitIndex);
            follower.setSnapshotTransmit(new SnapshotTransmit(view.getTerm(), view.getIndex(), view.getConfig(), view.getSnapshot(), (KVStore)view.getView()));
            if (this.log.isDebugEnabled()) {
                this.debug("started snapshot install for out-of-date " + follower);
            }
            this.raft.requestService(new UpdateFollowerService(follower));
            return;
        }
        follower.getUpdateTimer().timeoutAfter(this.raft.heartbeatTimeout);
        if (!follower.isSynced() || nextIndex > this.raft.getLastLogIndex()) {
            msg = new AppendRequest(this.raft.clusterId, this.raft.identity, peer, this.raft.currentTerm, new Timestamp(), this.leaseTimeout, this.raft.commitIndex, this.raft.getLogTermAtIndex(nextIndex - 1L), nextIndex - 1L);
        } else {
            LogEntry logEntry = this.raft.getLogEntryAtIndex(nextIndex);
            ByteBuffer mutationData = null;
            if (!follower.getSkipDataLogEntries().remove(logEntry)) {
                try {
                    mutationData = logEntry.getContent();
                }
                catch (IOException e) {
                    this.error("error reading log file " + logEntry.getFile(), e);
                    return;
                }
            }
            msg = new AppendRequest(this.raft.clusterId, this.raft.identity, peer, this.raft.currentTerm, new Timestamp(), this.leaseTimeout, this.raft.commitIndex, this.raft.getLogTermAtIndex(nextIndex - 1L), nextIndex - 1L, logEntry.getTerm(), mutationData);
        }
        boolean sent = this.raft.sendMessage(msg);
        if (sent && !msg.isProbe()) {
            assert (follower.isSynced());
            follower.setNextIndex(Math.min(follower.getNextIndex(), this.raft.getLastLogIndex()) + 1L);
        }
        if (sent) {
            follower.setLeaderCommit(msg.getLeaderCommit());
        }
    }

    private void updateAllSynchronizedFollowersNow() {
        assert (Thread.holdsLock(this.raft));
        this.followerMap.values().stream().filter(Follower::isSynced).forEach(Follower::updateNow);
    }

    @Override
    void handleLinearizableReadOnlyChange(RaftKVTransaction tx) {
        super.handleLinearizableReadOnlyChange(tx);
        if (!tx.hasCommitInfo()) {
            tx.setCommitInfo(this.raft.getLastLogTerm(), this.raft.getLastLogIndex(), this.getCurrentCommitMinLeaseTimeout());
            this.checkCommittable(tx);
        }
    }

    @Override
    void checkReadyTransactionNeedingCommitInfo(RaftKVTransaction tx) {
        LogEntry logEntry;
        super.checkReadyTransactionNeedingCommitInfo(tx);
        if (!tx.addsLogEntry()) {
            if (tx.hasCommitInfo()) {
                this.advanceReadyTransaction(tx);
                return;
            }
            this.advanceReadyTransactionWithCommitInfo(tx, this.raft.getLastLogTerm(), this.raft.getLastLogIndex(), this.getCurrentCommitMinLeaseTimeout());
            return;
        }
        assert (!tx.isReadOnly());
        assert (tx.isRebasable()) : "fail tx " + tx;
        assert (!tx.isCommittable());
        assert (!tx.hasCommitInfo());
        assert (this.checkRebasableAndCommittableUpToDate(tx));
        if (tx.getConfigChange() != null && !this.mayApplyNewConfigChange()) {
            return;
        }
        try {
            logEntry = this.applyNewLogEntry(new NewLogEntry(tx));
        }
        catch (IllegalStateException e) {
            throw new RetryTransactionException((KVTransaction)tx, e.getMessage());
        }
        catch (Exception e) {
            throw new KVTransactionException((KVTransaction)tx, "error attempting to persist transaction", (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.debug("added log entry " + logEntry + " for local transaction " + tx);
        }
        this.advanceReadyTransactionWithCommitInfo(tx, logEntry.getTerm(), logEntry.getIndex(), null);
        this.rebaseTransactions();
    }

    private boolean mayApplyNewConfigChange() {
        assert (Thread.holdsLock(this.raft));
        assert (this.raft.commitIndex >= this.raft.lastAppliedIndex);
        if (this.raft.getLogTermAtIndex(this.raft.commitIndex) < this.raft.currentTerm) {
            return false;
        }
        for (int i = (int)(this.raft.commitIndex - this.raft.lastAppliedIndex) + 1; i < this.raft.raftLog.size(); ++i) {
            if (this.raft.raftLog.get(i).getConfigChange() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    Timestamp getLeaderLeaseTimeout() {
        return this.leaseTimeout;
    }

    private Timestamp getCurrentCommitMinLeaseTimeout() {
        return this.isLeaderLeaseActiveNow() ? null : new Timestamp();
    }

    @Override
    void caseAppendRequest(AppendRequest msg, NewLogEntry newLogEntry) {
        assert (Thread.holdsLock(this.raft));
        this.failDuplicateLeader(msg);
    }

    @Override
    void caseAppendResponse(AppendResponse msg) {
        assert (Thread.holdsLock(this.raft));
        Follower follower = this.findFollower(msg);
        if (follower == null) {
            return;
        }
        if (follower.getLeaderTimestamp() == null || msg.getLeaderTimestamp().compareTo(follower.getLeaderTimestamp()) > 0) {
            follower.setLeaderTimestamp(msg.getLeaderTimestamp());
            this.raft.requestService(this.updateLeaseTimeoutService);
        }
        if (follower.getSnapshotTransmit() != null) {
            if (this.log.isTraceEnabled()) {
                this.trace("rec'd " + msg + " while sending snapshot install; ignoring");
            }
            return;
        }
        if (follower.getSnapshotTimestamp() != null && msg.getLeaderTimestamp().compareTo(follower.getSnapshotTimestamp()) < 0) {
            if (this.log.isTraceEnabled()) {
                this.trace("rec'd " + msg + " sent prior to snapshot install; ignoring");
            }
            return;
        }
        boolean updateFollowerAgain = false;
        if (msg.getMatchIndex() > follower.getMatchIndex()) {
            follower.setMatchIndex(msg.getMatchIndex());
            this.raft.requestService(this.updateLeaderCommitIndexService);
            if (!this.raft.isClusterMember(follower.getIdentity())) {
                this.raft.requestService(this.updateKnownFollowersService);
            }
        }
        boolean wasSynced = follower.isSynced();
        long previousNextIndex = follower.getNextIndex();
        if (!msg.isSuccess()) {
            follower.setNextIndex(Math.max(follower.getNextIndex() - 1L, 1L));
        }
        follower.setSynced(msg.isSuccess());
        if (follower.isSynced() != wasSynced) {
            if (this.log.isDebugEnabled()) {
                this.debug("sync status of \"" + follower.getIdentity() + "\" changed -> " + (!follower.isSynced() ? "not " : "") + "synced");
            }
            updateFollowerAgain = true;
        }
        follower.setNextIndex(Math.max(follower.getNextIndex(), follower.getMatchIndex() + 1L));
        follower.setNextIndex(Math.min(msg.getLastLogIndex() + 1L, follower.getNextIndex()));
        updateFollowerAgain |= follower.getNextIndex() != previousNextIndex;
        if (this.log.isTraceEnabled()) {
            this.trace("updated follower: " + follower + ", update again = " + updateFollowerAgain);
        }
        if (updateFollowerAgain) {
            this.raft.requestService(new UpdateFollowerService(follower));
        }
    }

    @Override
    void caseCommitRequest(CommitRequest msg, NewLogEntry newLogEntry) {
        assert (Thread.holdsLock(this.raft));
        Follower follower = this.findFollower(msg);
        if (follower == null) {
            return;
        }
        ByteBuffer readsData = msg.getReadsData();
        if (readsData != null) {
            Reads reads;
            try {
                reads = new Reads((InputStream)new ByteBufferInputStream(msg.getReadsData()));
            }
            catch (Exception e) {
                this.error("error decoding reads data in " + msg, e);
                this.raft.sendMessage(new CommitResponse(this.raft.clusterId, this.raft.identity, msg.getSenderId(), this.raft.currentTerm, msg.getTxId(), "error decoding reads data: " + e));
                return;
            }
            String conflictMsg = this.checkConflicts(msg.getBaseTerm(), msg.getBaseIndex(), reads, this.raft.dumpConflicts ? msg.getSenderId() + " txId=" + msg.getTxId() : null);
            if (conflictMsg != null) {
                if (this.log.isDebugEnabled()) {
                    this.debug("commit request " + msg + " failed due to conflict: " + conflictMsg);
                }
                this.raft.sendMessage(new CommitResponse(this.raft.clusterId, this.raft.identity, msg.getSenderId(), this.raft.currentTerm, msg.getTxId(), conflictMsg));
                return;
            }
        }
        if (msg.isReadOnly()) {
            assert (newLogEntry == null);
            Timestamp minimumLeaseTimeout = this.getCurrentCommitMinLeaseTimeout();
            if (minimumLeaseTimeout != null) {
                follower.getCommitLeaseTimeouts().add(minimumLeaseTimeout);
                this.updateAllSynchronizedFollowersNow();
            }
            this.raft.sendMessage(new CommitResponse(this.raft.clusterId, this.raft.identity, msg.getSenderId(), this.raft.currentTerm, msg.getTxId(), this.raft.getLastLogTerm(), this.raft.getLastLogIndex(), minimumLeaseTimeout));
        } else {
            LogEntry logEntry;
            assert (newLogEntry != null);
            try {
                logEntry = this.applyNewLogEntry(newLogEntry);
            }
            catch (Exception e) {
                if (!(e instanceof IllegalStateException)) {
                    this.error("error appending new log entry for " + msg, e);
                } else if (this.log.isDebugEnabled()) {
                    this.debug("error appending new log entry for " + msg + ": " + e);
                }
                this.raft.sendMessage(new CommitResponse(this.raft.clusterId, this.raft.identity, msg.getSenderId(), this.raft.currentTerm, msg.getTxId(), e.getMessage() != null ? e.getMessage() : "" + e));
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.debug("added log entry " + logEntry + " for rec'd " + msg);
            }
            this.rebaseTransactions();
            follower.getSkipDataLogEntries().add(logEntry);
            this.raft.sendMessage(new CommitResponse(this.raft.clusterId, this.raft.identity, msg.getSenderId(), this.raft.currentTerm, msg.getTxId(), logEntry.getTerm(), logEntry.getIndex()));
        }
    }

    @Override
    void caseCommitResponse(CommitResponse msg) {
        assert (Thread.holdsLock(this.raft));
        this.failDuplicateLeader(msg);
    }

    @Override
    void caseInstallSnapshot(InstallSnapshot msg) {
        assert (Thread.holdsLock(this.raft));
        this.failDuplicateLeader(msg);
    }

    @Override
    void caseRequestVote(RequestVote msg) {
        assert (Thread.holdsLock(this.raft));
        if (this.log.isDebugEnabled()) {
            this.debug("ignoring " + msg + " rec'd while in " + this);
        }
    }

    @Override
    void caseGrantVote(GrantVote msg) {
        assert (Thread.holdsLock(this.raft));
        if (this.log.isDebugEnabled()) {
            this.debug("ignoring " + msg + " rec'd while in " + this);
        }
    }

    private void failDuplicateLeader(Message msg) {
        assert (Thread.holdsLock(this.raft));
        boolean defer = this.raft.identity.compareTo(msg.getSenderId()) <= 0;
        this.error("detected a duplicate leader in " + msg + " - should never happen; possible inconsistent cluster configuration on " + msg.getSenderId() + " (mine: " + this.raft.currentConfig + "); " + (defer ? "reverting to follower" : "ignoring"));
        if (defer) {
            this.raft.changeRole(new FollowerRole(this.raft, msg.getSenderId(), this.raft.returnAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.toStringPrefix() + ",followerMap=" + this.followerMap + "]";
        }
    }

    @Override
    boolean checkState() {
        assert (Thread.holdsLock(this.raft));
        assert (this.checkApplyTimer.isRunning() == !this.raft.raftLog.isEmpty());
        for (Follower follower : this.followerMap.values()) {
            assert (follower.getNextIndex() <= this.raft.getLastLogIndex() + 1L);
            assert (follower.getMatchIndex() <= this.raft.getLastLogIndex() + 1L);
            assert (follower.getLeaderCommit() <= this.raft.commitIndex);
            assert (follower.getUpdateTimer().isRunning() || follower.getSnapshotTransmit() != null);
        }
        assert (this.timestampScrubTimer.isRunning());
        return true;
    }

    private long findMostRecentConfigChange() {
        return this.findMostRecentConfigChangeMatching(configChange -> true);
    }

    private long findMostRecentConfigChangeMatching(Predicate<String[]> predicate) {
        assert (Thread.holdsLock(this.raft));
        for (long index = this.raft.getLastLogIndex(); index > this.raft.lastAppliedIndex; --index) {
            String[] configChange = this.raft.getLogEntryAtIndex(index).getConfigChange();
            if (configChange == null || !predicate.test(configChange)) continue;
            return index;
        }
        return 0L;
    }

    private LogEntry applyNewLogEntry(NewLogEntry newLogEntry) throws Exception {
        assert (Thread.holdsLock(this.raft));
        String[] configChange = newLogEntry.getData().getConfigChange();
        if (configChange != null) {
            String lastNode;
            if (!this.mayApplyNewConfigChange()) {
                throw new IllegalStateException("config change cannot be safely applied at this time");
            }
            if (this.raft.currentConfig.size() == 1 && configChange[1] == null && configChange[0].equals(lastNode = this.raft.currentConfig.keySet().iterator().next())) {
                throw new IllegalArgumentException("can't remove the last node in a cluster (\"" + lastNode + "\")");
            }
        }
        LogEntry logEntry = this.raft.appendLogEntry(this.raft.currentTerm, newLogEntry);
        if (configChange != null) {
            this.raft.requestService(this.updateKnownFollowersService);
        }
        if (configChange != null || this.followerMap.isEmpty()) {
            this.raft.requestService(this.updateLeaderCommitIndexService);
        }
        this.updateAllSynchronizedFollowersNow();
        if (!this.checkApplyTimer.isRunning()) {
            this.checkApplyTimer.timeoutAfter(this.raft.heartbeatTimeout);
        }
        return logEntry;
    }

    private String checkConflicts(long baseTerm, long baseIndex, Reads reads, String dumpDescription) {
        assert (Thread.holdsLock(this.raft));
        long minIndex = this.raft.lastAppliedIndex;
        long maxIndex = this.raft.getLastLogIndex();
        if (baseIndex < minIndex) {
            return "transaction is too old: base index " + baseIndex + " < last applied log index " + minIndex;
        }
        if (baseIndex > maxIndex) {
            return "transaction is too new: base index " + baseIndex + " > most recent log index " + maxIndex;
        }
        long actualBaseTerm = this.raft.getLogTermAtIndex(baseIndex);
        if (baseTerm != actualBaseTerm) {
            return "transaction is based on an overwritten log entry with index " + baseIndex + " and term " + baseTerm + " != " + actualBaseTerm;
        }
        for (long index = baseIndex + 1L; index <= maxIndex; ++index) {
            LogEntry logEntry = this.raft.getLogEntryAtIndex(index);
            if (!reads.isConflict((Mutations)logEntry.getWrites())) continue;
            if (dumpDescription != null) {
                this.dumpConflicts(reads, logEntry, dumpDescription);
            }
            return "writes of committed transaction at index " + index + " conflict with transaction reads from transaction base index " + baseIndex;
        }
        return null;
    }

    private Follower findFollower(Message msg) {
        assert (Thread.holdsLock(this.raft));
        Follower follower = this.followerMap.get(msg.getSenderId());
        if (follower == null) {
            this.warn("rec'd " + msg + " from unknown follower \"" + msg.getSenderId() + "\", ignoring");
        }
        return follower;
    }

    private class UpdateFollowerService
    extends Service {
        private final Follower follower;

        UpdateFollowerService(Follower follower) {
            super(LeaderRole.this, "update follower \"" + follower.getIdentity() + "\"");
            this.follower = follower;
        }

        @Override
        public void run() {
            LeaderRole.this.updateFollower(this.follower);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            UpdateFollowerService that = (UpdateFollowerService)obj;
            return this.follower.equals(that.follower);
        }

        public int hashCode() {
            return this.follower.hashCode();
        }
    }
}

