/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.Util;

public class LogEntry {
    public static final Comparator<LogEntry> SORT_BY_INDEX = Comparator.comparingLong(LogEntry::getIndex);
    static final String LOG_FILE_PREFIX = "log-";
    static final String LOG_FILE_SUFFIX = ".bin";
    static final Pattern LOG_FILE_PATTERN = Pattern.compile(Pattern.quote("log-") + "([0-9]{19})-([0-9]{19})" + Pattern.quote(".bin"));
    private final Timestamp createTime = new Timestamp();
    private final long term;
    private final long index;
    private final Writes writes;
    private final String[] configChange;
    private final long fileSize;
    private final File file;
    private ByteBuffer content;

    LogEntry(long term, long index, File logDir, Data data, long fileSize) {
        Preconditions.checkArgument((term > 0L ? 1 : 0) != 0, (Object)"bogus term");
        Preconditions.checkArgument((index > 0L ? 1 : 0) != 0, (Object)"bogus index");
        Preconditions.checkArgument((logDir != null ? 1 : 0) != 0, (Object)"null logDir");
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"null data");
        Preconditions.checkArgument((fileSize > 0L ? 1 : 0) != 0, (Object)"invalid fileSize");
        this.term = term;
        this.index = index;
        this.writes = data.getWrites();
        this.configChange = data.getConfigChange();
        this.fileSize = fileSize;
        this.file = new File(logDir, String.format("%s%019d-%019d%s", LOG_FILE_PREFIX, this.getIndex(), this.getTerm(), LOG_FILE_SUFFIX));
    }

    public int getAge() {
        return -this.createTime.offsetFromNow();
    }

    public long getTerm() {
        return this.term;
    }

    public long getIndex() {
        return this.index;
    }

    Writes getWrites() {
        return this.writes;
    }

    public String[] getConfigChange() {
        return this.configChange != null ? (String[])this.configChange.clone() : null;
    }

    boolean applyConfigChange(Map<String, String> config) {
        if (this.configChange == null) {
            return false;
        }
        return this.configChange[1] != null ? !this.configChange[1].equals(config.put(this.configChange[0], this.configChange[1])) : config.remove(this.configChange[0]) != null;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public File getFile() {
        return this.file;
    }

    ByteBuffer getContent() throws IOException {
        if (this.content == null) {
            this.content = Util.readFile(this.getFile(), this.fileSize);
        }
        return this.content.asReadOnlyBuffer();
    }

    static LogEntry fromFile(File file) throws IOException {
        Data data;
        Matcher matcher = LOG_FILE_PATTERN.matcher(file.getName());
        if (!matcher.matches()) {
            throw new IOException("invalid log file name `" + file.getName() + "'");
        }
        long index = Long.parseLong(matcher.group(1), 10);
        long term = Long.parseLong(matcher.group(2), 10);
        long fileLength = Util.getLength(file);
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file), 4096);){
            data = LogEntry.readData(input);
        }
        return new LogEntry(term, index, file.getParentFile(), data, fileLength);
    }

    static Data readData(InputStream input) throws IOException {
        String[] configChange;
        Writes writes;
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        try {
            writes = Writes.deserialize((InputStream)input, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("log entry input contains invalid content", e);
        }
        DataInputStream data = new DataInputStream(input);
        if (data.readBoolean()) {
            configChange = new String[2];
            configChange[0] = data.readUTF();
            if (data.readBoolean()) {
                configChange[1] = data.readUTF();
            }
        } else {
            configChange = null;
        }
        if (input.read() != -1) {
            throw new IOException("log entry input contains trailing garbage");
        }
        return new Data(writes, configChange);
    }

    static void writeData(OutputStream output, Data data) throws IOException {
        Preconditions.checkArgument((output != null ? 1 : 0) != 0, (Object)"null output");
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"null data");
        data.getWrites().serialize(output);
        DataOutputStream dataOutput = new DataOutputStream(output);
        String[] configChange = data.getConfigChange();
        dataOutput.writeBoolean(configChange != null);
        if (configChange != null) {
            dataOutput.writeUTF(configChange[0]);
            dataOutput.writeBoolean(configChange[1] != null);
            if (configChange[1] != null) {
                dataOutput.writeUTF(configChange[1]);
            }
        }
        dataOutput.flush();
    }

    public String toString() {
        return this.getIndex() + "t" + this.getTerm() + (this.configChange != null ? (this.configChange[1] != null ? "+" + this.configChange[0] + "@" + this.configChange[1] : "-" + this.configChange[0]) : "");
    }

    static class Data {
        private final Writes writes;
        private final String[] configChange;

        Data(Writes writes, String[] configChange) {
            Preconditions.checkArgument((writes != null ? 1 : 0) != 0, (Object)"null writes");
            Preconditions.checkArgument((configChange == null || configChange.length == 2 && configChange[0] != null ? 1 : 0) != 0);
            this.writes = writes.immutableSnapshot();
            this.configChange = configChange;
        }

        public Writes getWrites() {
            return this.writes;
        }

        public String[] getConfigChange() {
            return this.configChange;
        }
    }
}

