/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import java.util.HashMap;
import java.util.Map;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.mvcc.MutableView;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.raft.LogEntry;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.util.PrefixKVStore;

class MostRecentView {
    private final CloseableKVStore snapshot;
    private final long term;
    private final long index;
    private final HashMap<String, String> config;
    private final MutableView view;

    MostRecentView(RaftKVDatabase raft) {
        this(raft, -1L);
    }

    MostRecentView(RaftKVDatabase raft, long maxIndex) {
        assert (raft != null);
        assert (Thread.holdsLock(raft));
        assert (maxIndex >= -1L);
        this.snapshot = raft.kv.snapshot();
        PrefixKVStore kview = PrefixKVStore.create((KVStore)this.snapshot, (byte[])raft.getStateMachinePrefix());
        this.config = new HashMap<String, String>(raft.lastAppliedConfig);
        long viewIndex = raft.lastAppliedIndex;
        long viewTerm = raft.lastAppliedTerm;
        for (LogEntry logEntry : raft.raftLog) {
            if (maxIndex != -1L && logEntry.getIndex() > maxIndex) break;
            Writes writes = logEntry.getWrites();
            if (!writes.isEmpty()) {
                kview = new MutableView((KVStore)kview, null, writes);
            }
            logEntry.applyConfigChange(this.config);
            viewIndex = logEntry.getIndex();
            viewTerm = logEntry.getTerm();
        }
        this.view = new MutableView((KVStore)kview);
        this.term = viewTerm;
        this.index = viewIndex;
    }

    public long getTerm() {
        return this.term;
    }

    public long getIndex() {
        return this.index;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public CloseableKVStore getSnapshot() {
        return this.snapshot;
    }

    public MutableView getView() {
        return this.view;
    }
}

