/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.jsimpledb.kv.raft.FileWriter;
import org.jsimpledb.kv.raft.LogEntry;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.RaftKVTransaction;

class NewLogEntry {
    private final LogEntry.Data data;
    private final File tempFile;
    private boolean tempFileReset;

    NewLogEntry(RaftKVTransaction tx, File tempFile) throws IOException {
        this(new LogEntry.Data(tx.view.getWrites(), tx.getConfigChange()), tempFile);
    }

    NewLogEntry(RaftKVTransaction tx) throws IOException {
        this(tx.raft, new LogEntry.Data(tx.view.getWrites(), tx.getConfigChange()));
    }

    NewLogEntry(RaftKVDatabase raft, LogEntry.Data data) throws IOException {
        this(data, NewLogEntry.writeDataToFile(data, raft, raft.disableSync));
    }

    NewLogEntry(LogEntry.Data data, File tempFile) {
        assert (data != null);
        assert (tempFile != null);
        this.data = data;
        this.tempFile = tempFile;
    }

    public LogEntry.Data getData() {
        return this.data;
    }

    public File getTempFile() {
        Preconditions.checkState((!this.tempFileReset ? 1 : 0) != 0);
        return this.tempFile;
    }

    public void resetTempFile() {
        assert (!this.tempFile.exists());
        this.tempFileReset = true;
    }

    public void cleanup(RaftKVDatabase raft) {
        if (!this.tempFileReset) {
            raft.deleteFile(this.tempFile, "new log entry temp file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File writeDataToFile(LogEntry.Data data, RaftKVDatabase raft, boolean disableSync) throws IOException {
        File tempFile = raft.getTempFile();
        boolean success = false;
        try (FileWriter output = new FileWriter(tempFile, disableSync);){
            LogEntry.writeData(output, data);
            success = true;
        }
        finally {
            if (!success) {
                raft.deleteFile(tempFile, "new log entry temp file");
            }
        }
        return tempFile;
    }
}

