/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import org.dellroad.stuff.io.ByteBufferInputStream;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.kv.raft.msg.InstallSnapshot;
import org.jsimpledb.kv.util.KeyListEncoder;

class SnapshotReceive {
    private final AtomicKVStore kv;
    private final byte[] prefix;
    private final long snapshotTerm;
    private final long snapshotIndex;
    private final Map<String, String> snapshotConfig;
    private long pairIndex;
    private byte[] previousKey;

    SnapshotReceive(AtomicKVStore kv, byte[] prefix, long snapshotTerm, long snapshotIndex, Map<String, String> snapshotConfig) {
        Preconditions.checkArgument((kv != null ? 1 : 0) != 0, (Object)"null kv");
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"null prefix");
        Preconditions.checkArgument((snapshotTerm > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((snapshotIndex > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((snapshotConfig != null ? 1 : 0) != 0);
        this.kv = kv;
        this.prefix = prefix;
        this.snapshotTerm = snapshotTerm;
        this.snapshotIndex = snapshotIndex;
        this.snapshotConfig = snapshotConfig;
    }

    public long getSnapshotTerm() {
        return this.snapshotTerm;
    }

    public long getSnapshotIndex() {
        return this.snapshotIndex;
    }

    public Map<String, String> getSnapshotConfig() {
        return this.snapshotConfig;
    }

    public void applyNextChunk(ByteBuffer buf) {
        Preconditions.checkArgument((buf != null ? 1 : 0) != 0, (Object)"null buf");
        PutMutations mutations = new PutMutations(buf, this.prefix, this.previousKey);
        this.kv.mutate((Mutations)mutations, false);
        assert (mutations.getEndKey() != null || this.pairIndex == 0L && mutations.getNumPuts() == 0);
        this.pairIndex += (long)mutations.getNumPuts();
        this.previousKey = mutations.getEndKey();
    }

    public boolean matches(InstallSnapshot msg) {
        return this.snapshotTerm == msg.getSnapshotTerm() && this.snapshotIndex == msg.getSnapshotIndex() && this.pairIndex == msg.getPairIndex();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[snapshotTerm=" + this.snapshotTerm + ",snapshotIndex=" + this.snapshotIndex + ",snapshotConfig=" + this.snapshotConfig + ",pairIndex=" + this.pairIndex + "]";
    }

    private static class PutIterator
    extends AbstractIterator<Map.Entry<byte[], byte[]>> {
        private final PutMutations mutations;
        private final ByteBuffer buf;
        private final ByteBufferInputStream input;
        private final byte[] prefix;
        private byte[] previousKey;
        private int numPuts;

        PutIterator(PutMutations mutations, ByteBuffer buf, byte[] prefix, byte[] startKey) {
            this.mutations = mutations;
            this.buf = buf;
            this.input = new ByteBufferInputStream(buf);
            this.prefix = prefix;
            this.previousKey = startKey;
        }

        protected Map.Entry<byte[], byte[]> computeNext() {
            byte[] value;
            byte[] key;
            if (!this.buf.hasRemaining()) {
                this.mutations.setEndKey(this.previousKey);
                this.mutations.setNumPuts(this.numPuts);
                return (Map.Entry)this.endOfData();
            }
            try {
                key = KeyListEncoder.read((InputStream)this.input, (byte[])this.previousKey);
                value = KeyListEncoder.read((InputStream)this.input, null);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("invalid encoded key/value data", e.getCause());
            }
            this.previousKey = key;
            ++this.numPuts;
            return new AbstractMap.SimpleImmutableEntry<byte[], byte[]>(Bytes.concat((byte[][])new byte[][]{this.prefix, key}), value);
        }
    }

    private static class PutMutations
    implements Mutations {
        private final ByteBuffer buf;
        private final byte[] prefix;
        private final byte[] startKey;
        private byte[] endKey;
        private int numPuts;

        PutMutations(ByteBuffer buf, byte[] prefix, byte[] startKey) {
            this.buf = buf;
            this.prefix = prefix;
            this.startKey = startKey;
        }

        public Iterable<KeyRange> getRemoveRanges() {
            return Collections.emptySet();
        }

        public Iterable<Map.Entry<byte[], byte[]>> getPutPairs() {
            return () -> new PutIterator(this, this.buf.asReadOnlyBuffer(), this.prefix, this.startKey);
        }

        public Iterable<Map.Entry<byte[], Long>> getAdjustPairs() {
            return Collections.emptySet();
        }

        public byte[] getEndKey() {
            return this.endKey;
        }

        public void setEndKey(byte[] endKey) {
            this.endKey = endKey;
        }

        public int getNumPuts() {
            return this.numPuts;
        }

        public void setNumPuts(int numPuts) {
            this.numPuts = numPuts;
        }
    }
}

