/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.Service;
import org.jsimpledb.kv.raft.Timestamp;
import org.slf4j.Logger;

class Timer {
    private final RaftKVDatabase raft;
    private final Logger log;
    private final String name;
    private final Service service;
    private ScheduledFuture<?> future;
    private PendingTimeout pendingTimeout;
    private Timestamp timeoutDeadline;

    Timer(RaftKVDatabase raft, String name, Service service) {
        assert (raft != null);
        assert (name != null);
        assert (service != null);
        this.raft = raft;
        this.log = this.raft.log;
        this.name = name;
        this.service = service;
    }

    public void cancel() {
        assert (Thread.holdsLock(this.raft));
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        this.pendingTimeout = null;
        this.timeoutDeadline = null;
    }

    public void timeoutAfter(int delay) {
        block8: {
            assert (Thread.holdsLock(this.raft));
            assert (Thread.holdsLock(this.raft));
            Preconditions.checkArgument((delay >= 0 ? 1 : 0) != 0, (Object)"delay < 0");
            this.cancel();
            assert (this.future == null);
            assert (this.pendingTimeout == null);
            assert (this.timeoutDeadline == null);
            this.timeoutDeadline = new Timestamp().offset(delay);
            if (this.log.isTraceEnabled()) {
                this.raft.trace("rescheduling " + this.name + " for " + this.timeoutDeadline + " (" + delay + "ms from now)");
            }
            this.pendingTimeout = new PendingTimeout();
            try {
                this.future = this.raft.serviceExecutor.schedule(this.pendingTimeout, (long)delay, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                if (this.raft.shuttingDown) break block8;
                this.raft.warn("can't restart timer", e);
            }
        }
    }

    public void timeoutNow() {
        this.timeoutAfter(0);
    }

    public Timestamp getDeadline() {
        return this.timeoutDeadline;
    }

    public boolean pollForTimeout() {
        assert (Thread.holdsLock(this.raft));
        if (this.pendingTimeout == null || !this.timeoutDeadline.hasOccurred()) {
            return false;
        }
        if (this.log.isTraceEnabled()) {
            this.raft.trace(this.name + " expired " + -this.timeoutDeadline.offsetFromNow() + "ms ago");
        }
        this.cancel();
        return true;
    }

    public boolean isRunning() {
        return this.pendingTimeout != null;
    }

    private class PendingTimeout
    implements Runnable {
        private PendingTimeout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RaftKVDatabase raftKVDatabase = Timer.this.raft;
            synchronized (raftKVDatabase) {
                if (Timer.this.pendingTimeout != this) {
                    return;
                }
                Timer.this.raft.requestService(Timer.this.service);
            }
        }
    }
}

