/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.slf4j.LoggerFactory;

final class Util {
    public static final long MIN_MAP_SIZE = 0x100000L;
    public static final int MIN_DIRECT_BUFFER_SIZE = 128;

    private Util() {
    }

    public static void closeIfPossible(Object obj) {
        if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ByteBuffer allocateByteBuffer(int capacity) {
        return capacity >= 128 ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    public static long getLength(File file) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"null file");
        return (Long)Files.getAttribute(file.toPath(), "size", new LinkOption[0]);
    }

    public static ByteBuffer readFile(File file, long length) throws IOException {
        if (length < 0L) {
            length = Util.getLength(file);
        }
        try (FileInputStream input = new FileInputStream(file);){
            if (length >= 0x100000L || length != (long)((int)length)) {
                MappedByteBuffer mappedByteBuffer = input.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, length);
                return mappedByteBuffer;
            }
            ByteBuffer buf = Util.allocateByteBuffer((int)length);
            while (buf.hasRemaining()) {
                int numRead = input.getChannel().read(buf);
                if (numRead != -1) continue;
                throw new IOException("file length was " + length + " but only read " + buf.position() + " bytes");
            }
            ByteBuffer byteBuffer = (ByteBuffer)buf.flip();
            return byteBuffer;
        }
    }

    public static void delete(File file, String description) {
        block2: {
            Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"null file");
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                if (description == null) break block2;
                LoggerFactory.getLogger(Util.class).warn("error deleting " + description + " " + file + " (proceeding anyway): " + e);
            }
        }
    }
}

