/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.cmd;

import java.util.Collections;
import java.util.Map;
import org.jsimpledb.Session;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.raft.Consistency;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.RaftKVTransaction;
import org.jsimpledb.kv.raft.cmd.AbstractRaftCommand;
import org.jsimpledb.kv.raft.fallback.FallbackKVTransaction;

public abstract class AbstractTransactionRaftCommand
extends AbstractRaftCommand {
    protected AbstractTransactionRaftCommand(String spec) {
        super(spec);
    }

    protected abstract class RaftTransactionAction
    extends AbstractRaftCommand.RaftAction
    implements Session.RetryableAction,
    Session.HasTransactionOptions {
        protected RaftTransactionAction() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void run(CliSession session, RaftKVDatabase db) throws Exception {
            RaftKVTransaction raftTX;
            KVTransaction kvt = session.getKVTransaction();
            if (kvt instanceof RaftKVTransaction) {
                raftTX = (RaftKVTransaction)kvt;
            } else {
                if (!(kvt instanceof FallbackKVTransaction)) throw new Exception("key/value store is not Raft or Raft fallback");
                if (!((kvt = ((FallbackKVTransaction)kvt).getKVTransaction()) instanceof RaftKVTransaction)) throw new Exception("Raft Fallback key/value store is currently in standalone mode");
                raftTX = (RaftKVTransaction)kvt;
            }
            this.run(session, raftTX);
        }

        public Map<String, ?> getTransactionOptions() {
            return Collections.singletonMap("consistency", this.getConsistency());
        }

        protected Consistency getConsistency() {
            return Consistency.LINEARIZABLE;
        }

        protected abstract void run(CliSession var1, RaftKVTransaction var2) throws Exception;
    }
}

