/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.cmd;

import java.util.Map;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.kv.raft.LeaderRole;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.cmd.AbstractRaftCommand;
import org.jsimpledb.util.ParseContext;

public class RaftStepDownCommand
extends AbstractRaftCommand {
    public RaftStepDownCommand() {
        super("raft-step-down");
    }

    public String getHelpSummary() {
        return "Step down as the Raft cluster leader";
    }

    public String getHelpDetail() {
        return "This command forces the local node, which must be the cluster leader, to step down, which (very likely) results in another node being elected leader for the new term. If the cluster only contains the local node, then the local node will just immediately become leader again.";
    }

    public CliSession.Action getAction(CliSession session, ParseContext ctx, boolean complete, Map<String, Object> params) {
        return new AbstractRaftCommand.RaftAction(){

            @Override
            protected void run(CliSession session, RaftKVDatabase db) throws Exception {
                LeaderRole leader;
                try {
                    leader = (LeaderRole)db.getCurrentRole();
                }
                catch (ClassCastException e) {
                    throw new Exception("current role is not leader; try `raft-status' for more info");
                }
                session.getWriter().println("Stepping down as Raft cluster leader");
                leader.stepDown();
            }
        };
    }
}

