/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.fallback;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.StaleTransactionException;
import org.jsimpledb.kv.raft.fallback.FallbackKVDatabase;
import org.jsimpledb.kv.util.ForwardingKVStore;

public class FallbackKVTransaction
extends ForwardingKVStore
implements KVTransaction {
    private final FallbackKVDatabase db;
    private final KVTransaction kvt;
    private final int migrationCount;
    private ArrayList<FallbackKVDatabase.FallbackFuture> futureList;
    private boolean stale;

    FallbackKVTransaction(FallbackKVDatabase db, KVTransaction kvt, int migrationCount) {
        this.db = db;
        this.kvt = kvt;
        this.migrationCount = migrationCount;
    }

    public KVTransaction getKVTransaction() {
        return this.kvt;
    }

    protected KVStore delegate() {
        return this.kvt;
    }

    public KVDatabase getKVDatabase() {
        return this.db;
    }

    public void setTimeout(long timeout) {
        this.kvt.setTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> watchKey(byte[] key) {
        ListenableFuture innerFuture;
        FallbackKVDatabase fallbackKVDatabase = this.db;
        synchronized (fallbackKVDatabase) {
            if (this.stale) {
                throw new StaleTransactionException((KVTransaction)this);
            }
        }
        try {
            innerFuture = (ListenableFuture)this.kvt.watchKey(key);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("nested transaction does not support ListenableFuture's", e);
        }
        FallbackKVDatabase fallbackKVDatabase2 = this.db;
        fallbackKVDatabase2.getClass();
        FallbackKVDatabase.FallbackFuture outerFuture = fallbackKVDatabase2.new FallbackKVDatabase.FallbackFuture((ListenableFuture<Void>)innerFuture);
        FallbackKVTransaction fallbackKVTransaction = this;
        synchronized (fallbackKVTransaction) {
            if (this.futureList == null) {
                this.futureList = new ArrayList();
            }
            this.futureList.add(outerFuture);
        }
        return outerFuture;
    }

    public CloseableKVStore mutableSnapshot() {
        return this.kvt.mutableSnapshot();
    }

    public boolean isReadOnly() {
        return this.kvt.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.kvt.setReadOnly(readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        ArrayList<FallbackKVDatabase.FallbackFuture> fallbackFutures;
        FallbackKVDatabase fallbackKVDatabase = this.db;
        synchronized (fallbackKVDatabase) {
            if (this.stale) {
                throw new StaleTransactionException((KVTransaction)this);
            }
            this.stale = true;
        }
        this.retryIfMigrating();
        this.kvt.commit();
        FallbackKVTransaction fallbackKVTransaction = this;
        synchronized (fallbackKVTransaction) {
            fallbackFutures = this.futureList;
            this.futureList = null;
        }
        this.retryIfMigrating();
        if (fallbackFutures != null && !this.db.registerFallbackFutures(fallbackFutures, this.migrationCount)) {
            for (FallbackKVDatabase.FallbackFuture future : fallbackFutures) {
                future.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        FallbackKVDatabase fallbackKVDatabase = this.db;
        synchronized (fallbackKVDatabase) {
            this.stale = true;
            this.kvt.rollback();
        }
    }

    private void retryIfMigrating() {
        if (!this.db.checkNoMigration(this.migrationCount)) {
            this.rollback();
            throw new RetryTransactionException((KVTransaction)this, "fallback migration in progress");
        }
    }
}

