/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.msg;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.msg.Message;
import org.jsimpledb.kv.raft.msg.MessageSwitch;
import org.jsimpledb.util.LongEncoder;

public class AppendResponse
extends Message {
    private final Timestamp leaderTimestamp;
    private final boolean success;
    private final long matchIndex;
    private final long lastLogIndex;

    public AppendResponse(int clusterId, String senderId, String recipientId, long term, Timestamp leaderTimestamp, boolean success, long matchIndex, long lastLogIndex) {
        super((byte)2, clusterId, senderId, recipientId, term);
        this.leaderTimestamp = leaderTimestamp;
        this.success = success;
        this.matchIndex = matchIndex;
        this.lastLogIndex = lastLogIndex;
        this.checkArguments();
    }

    AppendResponse(ByteBuffer buf, int version) {
        super((byte)2, buf, version);
        this.leaderTimestamp = Message.getTimestamp(buf, version);
        this.success = Message.getBoolean(buf);
        this.matchIndex = LongEncoder.read((ByteBuffer)buf);
        this.lastLogIndex = LongEncoder.read((ByteBuffer)buf);
        this.checkArguments();
    }

    @Override
    void checkArguments() {
        super.checkArguments();
        Preconditions.checkArgument((this.leaderTimestamp != null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.matchIndex >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.matchIndex <= this.lastLogIndex ? 1 : 0) != 0);
    }

    public Timestamp getLeaderTimestamp() {
        return this.leaderTimestamp;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public long getMatchIndex() {
        return this.matchIndex;
    }

    public long getLastLogIndex() {
        return this.lastLogIndex;
    }

    @Override
    public void visit(MessageSwitch handler) {
        handler.caseAppendResponse(this);
    }

    @Override
    public void writeTo(ByteBuffer dest, int version) {
        super.writeTo(dest, version);
        Message.putTimestamp(dest, this.leaderTimestamp, version);
        Message.putBoolean(dest, this.success);
        LongEncoder.write((ByteBuffer)dest, (long)this.matchIndex);
        LongEncoder.write((ByteBuffer)dest, (long)this.lastLogIndex);
    }

    @Override
    protected int calculateSize(int version) {
        return super.calculateSize(version) + Message.calculateSize(this.leaderTimestamp, version) + 1 + LongEncoder.encodeLength((long)this.matchIndex) + LongEncoder.encodeLength((long)this.lastLogIndex);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[\"" + this.getSenderId() + "\"->\"" + this.getRecipientId() + "\",clusterId=" + String.format("%08x", this.getClusterId()) + ",term=" + this.getTerm() + ",leaderTimestamp=" + this.leaderTimestamp + ",success=" + this.success + ",matchIndex=" + this.matchIndex + ",lastLogIndex=" + this.lastLogIndex + "]";
    }
}

