/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.msg;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jsimpledb.kv.mvcc.Reads;
import org.jsimpledb.kv.raft.msg.Message;
import org.jsimpledb.kv.raft.msg.MessageSwitch;
import org.jsimpledb.util.LongEncoder;

public class CommitRequest
extends Message {
    private final long txId;
    private final long baseTerm;
    private final long baseIndex;
    private final ByteBuffer readsData;
    private final boolean readOnly;
    private ByteBuffer mutationData;
    private boolean mutationDataInvalid;

    public CommitRequest(int clusterId, String senderId, String recipientId, long term, long txId, long baseTerm, long baseIndex, ByteBuffer readsData, ByteBuffer mutationData) {
        super((byte)3, clusterId, senderId, recipientId, term);
        this.txId = txId;
        this.baseTerm = baseTerm;
        this.baseIndex = baseIndex;
        this.readsData = readsData;
        this.mutationData = mutationData;
        this.readOnly = this.mutationData == null;
        this.checkArguments();
    }

    CommitRequest(ByteBuffer buf, int version) {
        super((byte)3, buf, version);
        this.txId = LongEncoder.read((ByteBuffer)buf);
        this.baseTerm = LongEncoder.read((ByteBuffer)buf);
        this.baseIndex = LongEncoder.read((ByteBuffer)buf);
        boolean readsOptional = version > 1;
        this.readsData = !readsOptional || Message.getBoolean(buf) ? Message.getByteBuffer(buf) : null;
        this.mutationData = Message.getBoolean(buf) ? Message.getByteBuffer(buf) : null;
        this.readOnly = this.mutationData == null;
        this.checkArguments();
    }

    @Override
    void checkArguments() {
        super.checkArguments();
        Preconditions.checkArgument((this.txId != 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.baseTerm >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.baseIndex >= 0L ? 1 : 0) != 0);
    }

    public long getTxId() {
        return this.txId;
    }

    public long getBaseTerm() {
        return this.baseTerm;
    }

    public long getBaseIndex() {
        return this.baseIndex;
    }

    public ByteBuffer getReadsData() {
        return this.readsData != null ? this.readsData.asReadOnlyBuffer() : null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public ByteBuffer getMutationData() {
        Preconditions.checkState((!this.mutationDataInvalid ? 1 : 0) != 0);
        ByteBuffer result = this.mutationData;
        this.mutationData = null;
        this.mutationDataInvalid = true;
        return result;
    }

    @Override
    public void visit(MessageSwitch handler) {
        handler.caseCommitRequest(this);
    }

    @Override
    public void writeTo(ByteBuffer dest, int version) {
        Preconditions.checkState((!this.mutationDataInvalid ? 1 : 0) != 0);
        super.writeTo(dest, version);
        LongEncoder.write((ByteBuffer)dest, (long)this.txId);
        LongEncoder.write((ByteBuffer)dest, (long)this.baseTerm);
        LongEncoder.write((ByteBuffer)dest, (long)this.baseIndex);
        if (version > 1) {
            Message.putBoolean(dest, this.readsData != null);
            if (this.readsData != null) {
                Message.putByteBuffer(dest, this.readsData);
            }
        } else {
            Message.putByteBuffer(dest, this.readsData != null ? this.readsData : this.getEmptyReadsByteBuffer());
        }
        Message.putBoolean(dest, this.mutationData != null);
        if (this.mutationData != null) {
            Message.putByteBuffer(dest, this.mutationData);
        }
    }

    @Override
    protected int calculateSize(int version) {
        Preconditions.checkState((!this.mutationDataInvalid ? 1 : 0) != 0);
        return super.calculateSize(version) + LongEncoder.encodeLength((long)this.txId) + LongEncoder.encodeLength((long)this.baseTerm) + LongEncoder.encodeLength((long)this.baseIndex) + (version > 1 ? 1 + (this.readsData != null ? Message.calculateSize(this.readsData) : 0) : Message.calculateSize(this.readsData != null ? this.readsData : this.getEmptyReadsByteBuffer())) + 1 + (this.mutationData != null ? Message.calculateSize(this.mutationData) : 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteBuffer getEmptyReadsByteBuffer() {
        Reads reads = new Reads();
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            reads.serialize((OutputStream)output);
            ByteBuffer byteBuffer = ByteBuffer.wrap(output.toByteArray());
            return byteBuffer;
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[\"" + this.getSenderId() + "\"->\"" + this.getRecipientId() + "\",clusterId=" + String.format("%08x", this.getClusterId()) + ",term=" + this.getTerm() + ",txId=" + this.txId + ",base=" + this.baseIndex + "t" + this.baseTerm + (this.readsData != null ? ",readsData=" + this.describe(this.readsData) : "") + (this.mutationData != null ? ",mutationData=" + this.describe(this.mutationData) : (this.mutationDataInvalid ? ",mutationData=invalid" : "")) + "]";
    }
}

