/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.msg;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.msg.Message;
import org.jsimpledb.kv.raft.msg.MessageSwitch;
import org.jsimpledb.util.LongEncoder;

public class CommitResponse
extends Message {
    private final long txId;
    private final long commitTerm;
    private final long commitIndex;
    private final Timestamp commitLeaderLeaseTimeout;
    private final String errorMessage;

    public CommitResponse(int clusterId, String senderId, String recipientId, long term, long txId, long commitTerm, long commitIndex) {
        this(clusterId, senderId, recipientId, term, txId, commitTerm, commitIndex, null);
    }

    public CommitResponse(int clusterId, String senderId, String recipientId, long term, long txId, long commitTerm, long commitIndex, Timestamp commitLeaderLeaseTimeout) {
        this(clusterId, senderId, recipientId, term, txId, commitTerm, commitIndex, commitLeaderLeaseTimeout, null);
    }

    public CommitResponse(int clusterId, String senderId, String recipientId, long term, long txId, String errorMessage) {
        this(clusterId, senderId, recipientId, term, txId, 0L, 0L, null, errorMessage);
        Preconditions.checkArgument((errorMessage != null ? 1 : 0) != 0, (Object)"null errorMessage");
    }

    private CommitResponse(int clusterId, String senderId, String recipientId, long term, long txId, long commitTerm, long commitIndex, Timestamp commitLeaderLeaseTimeout, String errorMessage) {
        super((byte)4, clusterId, senderId, recipientId, term);
        this.txId = txId;
        this.commitTerm = commitTerm;
        this.commitIndex = commitIndex;
        this.commitLeaderLeaseTimeout = commitLeaderLeaseTimeout;
        this.errorMessage = errorMessage;
        this.checkArguments();
    }

    CommitResponse(ByteBuffer buf, int version) {
        super((byte)4, buf, version);
        this.txId = LongEncoder.read((ByteBuffer)buf);
        this.commitTerm = LongEncoder.read((ByteBuffer)buf);
        this.commitIndex = LongEncoder.read((ByteBuffer)buf);
        this.commitLeaderLeaseTimeout = Message.getBoolean(buf) ? Message.getTimestamp(buf, version) : null;
        this.errorMessage = Message.getBoolean(buf) ? Message.getString(buf) : null;
        this.checkArguments();
    }

    @Override
    void checkArguments() {
        super.checkArguments();
        Preconditions.checkArgument((this.txId != 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.commitTerm >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.commitIndex >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.errorMessage == null || this.commitLeaderLeaseTimeout == null ? 1 : 0) != 0);
    }

    public long getTxId() {
        return this.txId;
    }

    public boolean isSuccess() {
        return this.errorMessage == null;
    }

    public long getCommitTerm() {
        return this.commitTerm;
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public Timestamp getCommitLeaderLeaseTimeout() {
        return this.commitLeaderLeaseTimeout;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean isLeaderMessage() {
        return true;
    }

    @Override
    public void visit(MessageSwitch handler) {
        handler.caseCommitResponse(this);
    }

    @Override
    public void writeTo(ByteBuffer dest, int version) {
        super.writeTo(dest, version);
        LongEncoder.write((ByteBuffer)dest, (long)this.txId);
        LongEncoder.write((ByteBuffer)dest, (long)this.commitTerm);
        LongEncoder.write((ByteBuffer)dest, (long)this.commitIndex);
        Message.putBoolean(dest, this.commitLeaderLeaseTimeout != null);
        if (this.commitLeaderLeaseTimeout != null) {
            Message.putTimestamp(dest, this.commitLeaderLeaseTimeout, version);
        }
        Message.putBoolean(dest, this.errorMessage != null);
        if (this.errorMessage != null) {
            Message.putString(dest, this.errorMessage);
        }
    }

    @Override
    protected int calculateSize(int version) {
        return super.calculateSize(version) + LongEncoder.encodeLength((long)this.txId) + LongEncoder.encodeLength((long)this.commitTerm) + LongEncoder.encodeLength((long)this.commitIndex) + 1 + (this.commitLeaderLeaseTimeout != null ? Message.calculateSize(this.commitLeaderLeaseTimeout, version) : 0) + 1 + (this.errorMessage != null ? Message.calculateSize(this.errorMessage) : 0);
    }

    @Override
    public String toString() {
        boolean success = this.errorMessage == null;
        return this.getClass().getSimpleName() + "[\"" + this.getSenderId() + "\"->\"" + this.getRecipientId() + "\",clusterId=" + String.format("%08x", this.getClusterId()) + ",term=" + this.getTerm() + ",txId=" + this.txId + (success ? ",commit=" + this.commitIndex + "t" + this.commitTerm + (this.commitLeaderLeaseTimeout != null ? "@" + this.commitLeaderLeaseTimeout : "") : ",error=\"" + this.errorMessage + "\"") + "]";
    }
}

