/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.msg;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.jsimpledb.kv.raft.msg.Message;
import org.jsimpledb.kv.raft.msg.MessageSwitch;
import org.jsimpledb.util.LongEncoder;

public class InstallSnapshot
extends Message {
    private final long snapshotTerm;
    private final long snapshotIndex;
    private final Map<String, String> snapshotConfig;
    private final long pairIndex;
    private final boolean lastChunk;
    private final ByteBuffer data;

    public InstallSnapshot(int clusterId, String senderId, String recipientId, long term, long snapshotTerm, long snapshotIndex, long pairIndex, Map<String, String> snapshotConfig, boolean lastChunk, ByteBuffer data) {
        super((byte)6, clusterId, senderId, recipientId, term);
        this.snapshotTerm = snapshotTerm;
        this.snapshotIndex = snapshotIndex;
        this.pairIndex = pairIndex;
        this.snapshotConfig = snapshotConfig;
        this.lastChunk = lastChunk;
        this.data = data;
        this.checkArguments();
    }

    InstallSnapshot(ByteBuffer buf, int version) {
        super((byte)6, buf, version);
        this.snapshotTerm = LongEncoder.read((ByteBuffer)buf);
        this.snapshotIndex = LongEncoder.read((ByteBuffer)buf);
        this.pairIndex = LongEncoder.read((ByteBuffer)buf);
        this.snapshotConfig = this.pairIndex == 0L ? InstallSnapshot.getSnapshotConfig(buf) : null;
        this.lastChunk = Message.getBoolean(buf);
        this.data = Message.getByteBuffer(buf);
        this.checkArguments();
    }

    @Override
    void checkArguments() {
        super.checkArguments();
        Preconditions.checkArgument((this.snapshotTerm > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.snapshotIndex > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.pairIndex >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.pairIndex == 0L == (this.snapshotConfig != null) ? 1 : 0) != 0);
        Preconditions.checkArgument((this.data != null ? 1 : 0) != 0);
    }

    public long getSnapshotTerm() {
        return this.snapshotTerm;
    }

    public long getSnapshotIndex() {
        return this.snapshotIndex;
    }

    public Map<String, String> getSnapshotConfig() {
        return this.snapshotConfig;
    }

    public long getPairIndex() {
        return this.pairIndex;
    }

    public boolean isLastChunk() {
        return this.lastChunk;
    }

    public ByteBuffer getData() {
        return this.data.asReadOnlyBuffer();
    }

    @Override
    public boolean isLeaderMessage() {
        return true;
    }

    @Override
    public void visit(MessageSwitch handler) {
        handler.caseInstallSnapshot(this);
    }

    @Override
    public void writeTo(ByteBuffer dest, int version) {
        super.writeTo(dest, version);
        LongEncoder.write((ByteBuffer)dest, (long)this.snapshotTerm);
        LongEncoder.write((ByteBuffer)dest, (long)this.snapshotIndex);
        LongEncoder.write((ByteBuffer)dest, (long)this.pairIndex);
        if (this.pairIndex == 0L) {
            InstallSnapshot.putSnapshotConfig(dest, this.snapshotConfig);
        }
        Message.putBoolean(dest, this.lastChunk);
        Message.putByteBuffer(dest, this.data);
    }

    @Override
    protected int calculateSize(int version) {
        return super.calculateSize(version) + LongEncoder.encodeLength((long)this.snapshotTerm) + LongEncoder.encodeLength((long)this.snapshotIndex) + LongEncoder.encodeLength((long)this.pairIndex) + (this.pairIndex == 0L ? InstallSnapshot.calculateSize(this.snapshotConfig) : 0) + 1 + Message.calculateSize(this.data);
    }

    private static Map<String, String> getSnapshotConfig(ByteBuffer buf) {
        int count = (int)LongEncoder.read((ByteBuffer)buf);
        HashMap<String, String> config = new HashMap<String, String>(count);
        for (int i = 0; i < count; ++i) {
            config.put(Message.getString(buf), Message.getString(buf));
        }
        return config;
    }

    private static void putSnapshotConfig(ByteBuffer dest, Map<String, String> config) {
        int count = config.size();
        LongEncoder.write((ByteBuffer)dest, (long)count);
        for (Map.Entry<String, String> entry : config.entrySet()) {
            Message.putString(dest, entry.getKey());
            Message.putString(dest, entry.getValue());
        }
    }

    private static int calculateSize(Map<String, String> config) {
        int total = LongEncoder.encodeLength((long)config.size());
        for (Map.Entry<String, String> entry : config.entrySet()) {
            total += Message.calculateSize(entry.getKey()) + Message.calculateSize(entry.getValue());
        }
        return total;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[\"" + this.getSenderId() + "\"->\"" + this.getRecipientId() + "\",clusterId=" + String.format("%08x", this.getClusterId()) + ",term=" + this.getTerm() + ",snapshot=" + this.snapshotIndex + "t" + this.snapshotTerm + ",pairIndex=" + this.pairIndex + (this.snapshotConfig != null ? ",snapshotConfig=" + this.snapshotConfig : "") + ",lastChunk=" + this.lastChunk + ",data=" + this.describe(this.data) + "]";
    }
}

