/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.msg;

import com.google.common.base.Preconditions;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.msg.AppendRequest;
import org.jsimpledb.kv.raft.msg.AppendResponse;
import org.jsimpledb.kv.raft.msg.CommitRequest;
import org.jsimpledb.kv.raft.msg.CommitResponse;
import org.jsimpledb.kv.raft.msg.GrantVote;
import org.jsimpledb.kv.raft.msg.InstallSnapshot;
import org.jsimpledb.kv.raft.msg.MessageSwitch;
import org.jsimpledb.kv.raft.msg.PingRequest;
import org.jsimpledb.kv.raft.msg.PingResponse;
import org.jsimpledb.kv.raft.msg.RequestVote;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.LongEncoder;
import org.jsimpledb.util.UnsignedIntEncoder;

public abstract class Message {
    static final byte APPEND_REQUEST_TYPE = 1;
    static final byte APPEND_RESPONSE_TYPE = 2;
    static final byte COMMIT_REQUEST_TYPE = 3;
    static final byte COMMIT_RESPONSE_TYPE = 4;
    static final byte GRANT_VOTE_TYPE = 5;
    static final byte INSTALL_SNAPSHOT_TYPE = 6;
    static final byte REQUEST_VOTE_TYPE = 7;
    static final byte PING_REQUEST_TYPE = 8;
    static final byte PING_RESPONSE_TYPE = 9;
    static final byte MAX_TYPE = 10;
    static final int VERSION_1 = 1;
    static final int VERSION_2 = 2;
    static final int VERSION_3 = 3;
    private static final int MIN_DIRECT_BUFFER_SIZE = 128;
    private final byte type;
    private final int clusterId;
    private final String senderId;
    private final String recipientId;
    private final long term;

    protected Message(byte type, int clusterId, String senderId, String recipientId, long term) {
        this.type = type;
        this.clusterId = clusterId;
        this.senderId = senderId;
        this.recipientId = recipientId;
        this.term = term;
    }

    protected Message(byte type, ByteBuffer buf, int version) {
        this.type = type;
        this.clusterId = buf.getInt();
        this.senderId = Message.getString(buf);
        this.recipientId = Message.getString(buf);
        this.term = LongEncoder.read((ByteBuffer)buf);
    }

    void checkArguments() {
        Preconditions.checkArgument((this.type > 0 && this.type < 10 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.clusterId != 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.senderId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.recipientId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.term > 0L ? 1 : 0) != 0);
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getRecipientId() {
        return this.recipientId;
    }

    public long getTerm() {
        return this.term;
    }

    public boolean isLeaderMessage() {
        return false;
    }

    public abstract void visit(MessageSwitch var1);

    static void checkVersion(int version) {
        switch (version) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized message format version " + version);
            }
        }
    }

    public static int getCurrentProtocolVersion() {
        return 3;
    }

    public static int decodeProtocolVersion(ByteBuffer buf) {
        return buf.get() & 0xFF;
    }

    public static Message decode(ByteBuffer buf, int version) {
        Message msg;
        Message.checkVersion(version);
        byte type = buf.get();
        switch (type) {
            case 1: {
                msg = new AppendRequest(buf, version);
                break;
            }
            case 2: {
                msg = new AppendResponse(buf, version);
                break;
            }
            case 3: {
                msg = new CommitRequest(buf, version);
                break;
            }
            case 4: {
                msg = new CommitResponse(buf, version);
                break;
            }
            case 5: {
                msg = new GrantVote(buf, version);
                break;
            }
            case 6: {
                msg = new InstallSnapshot(buf, version);
                break;
            }
            case 7: {
                msg = new RequestVote(buf, version);
                break;
            }
            case 8: {
                msg = new PingRequest(buf, version);
                break;
            }
            case 9: {
                msg = new PingResponse(buf, version);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid message type " + type);
            }
        }
        if (buf.hasRemaining()) {
            throw new IllegalArgumentException("buffer contains " + buf.remaining() + " bytes of extra garbage after " + msg);
        }
        return msg;
    }

    public ByteBuffer encode(int version) {
        Message.checkVersion(version);
        int size = this.calculateSize(version);
        ByteBuffer buf = size >= 128 ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
        this.writeTo(buf, version);
        if (buf.hasRemaining()) {
            throw new RuntimeException("internal error: " + buf.remaining() + " remaining bytes in buffer from " + this);
        }
        return (ByteBuffer)buf.flip();
    }

    public void writeTo(ByteBuffer buf, int version) {
        Message.checkVersion(version);
        buf.put((byte)version);
        buf.put(this.type);
        buf.putInt(this.clusterId);
        Message.putString(buf, this.senderId);
        Message.putString(buf, this.recipientId);
        LongEncoder.write((ByteBuffer)buf, (long)this.term);
    }

    protected int calculateSize(int version) {
        Message.checkVersion(version);
        return 6 + Message.calculateSize(this.senderId) + Message.calculateSize(this.recipientId) + LongEncoder.encodeLength((long)this.term);
    }

    public abstract String toString();

    protected static void putByteBuffer(ByteBuffer dest, ByteBuffer buf) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        Preconditions.checkArgument((buf != null ? 1 : 0) != 0, (Object)"null buf");
        UnsignedIntEncoder.write((ByteBuffer)dest, (int)buf.remaining());
        dest.put(buf.asReadOnlyBuffer());
    }

    protected static ByteBuffer getByteBuffer(ByteBuffer buf) {
        Preconditions.checkArgument((buf != null ? 1 : 0) != 0, (Object)"null buf");
        int numBytes = UnsignedIntEncoder.read((ByteBuffer)buf);
        if (numBytes > buf.remaining()) {
            throw new IllegalArgumentException("bogus buffer length " + numBytes + " > " + buf.remaining());
        }
        ByteBuffer result = (ByteBuffer)buf.slice().limit(numBytes);
        buf.position(buf.position() + numBytes);
        return result;
    }

    protected static int calculateSize(ByteBuffer buf) {
        return UnsignedIntEncoder.encodeLength((int)buf.remaining()) + buf.remaining();
    }

    protected static void putString(ByteBuffer dest, String string) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"null string");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                dest.put((byte)c);
                continue;
            }
            if (c < '\u0800') {
                dest.put((byte)(0xC0 | c >> 6 & 0x1F));
                dest.put((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            dest.put((byte)(0xE0 | c >> 12 & 0xF));
            dest.put((byte)(0x80 | c >> 6 & 0x3F));
            dest.put((byte)(0x80 | c >> 0 & 0x3F));
        }
        dest.put((byte)0);
    }

    protected static String getString(ByteBuffer buf) {
        int b1;
        Preconditions.checkArgument((buf != null ? 1 : 0) != 0, (Object)"null buf");
        StringWriter writer = new StringWriter();
        while ((b1 = buf.get() & 0xFF) != 0) {
            int b2;
            if ((b1 & 0x80) == 0) {
                writer.append((char)b1);
                continue;
            }
            if ((b1 & 0xE0) == 192) {
                b2 = buf.get() & 0xFF;
                if ((b2 & 0xC0) != 128) {
                    throw new IllegalArgumentException("invalid UTF-8 sequence: " + b1 + " " + b2);
                }
                writer.append((char)((b1 & 0x1F) << 6 | b2 & 0x3F));
                continue;
            }
            if ((b1 & 0xF0) == 224) {
                b2 = buf.get() & 0xFF;
                int b3 = buf.get() & 0xFF;
                if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                    throw new IllegalArgumentException("invalid UTF-8 sequence: " + b1 + " " + b2 + " " + b3);
                }
                writer.append((char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F));
                continue;
            }
            throw new IllegalArgumentException("invalid UTF-8 sequence: " + b1);
        }
        return writer.toString();
    }

    protected static int calculateSize(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"null string");
        int total = 1;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            total += ch != '\u0000' && ch < '\u0080' ? 1 : (ch < '\u0800' ? 2 : 3);
        }
        return total;
    }

    protected static void putBoolean(ByteBuffer dest, boolean value) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        dest.put(value ? (byte)1 : 0);
    }

    protected static boolean getBoolean(ByteBuffer buf) {
        Preconditions.checkArgument((buf != null ? 1 : 0) != 0, (Object)"null buf");
        switch (buf.get()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IllegalArgumentException("read invalid boolean value");
    }

    protected static void putTimestamp(ByteBuffer dest, Timestamp timestamp, int version) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        Preconditions.checkArgument((timestamp != null ? 1 : 0) != 0, (Object)"null timestamp");
        Message.checkVersion(version);
        if (version > 2) {
            LongEncoder.write((ByteBuffer)dest, (long)timestamp.getMillis());
        } else {
            UnsignedIntEncoder.write((ByteBuffer)dest, (int)timestamp.getMillis());
        }
    }

    protected static Timestamp getTimestamp(ByteBuffer buf, int version) {
        Preconditions.checkArgument((buf != null ? 1 : 0) != 0, (Object)"null buf");
        Message.checkVersion(version);
        return new Timestamp(version > 2 ? (int)LongEncoder.read((ByteBuffer)buf) : UnsignedIntEncoder.read((ByteBuffer)buf));
    }

    protected static int calculateSize(Timestamp timestamp, int version) {
        Preconditions.checkArgument((timestamp != null ? 1 : 0) != 0, (Object)"null timestamp");
        Message.checkVersion(version);
        int millis = timestamp.getMillis();
        return version > 2 ? LongEncoder.encodeLength((long)millis) : UnsignedIntEncoder.encodeLength((int)millis);
    }

    String describe(ByteBuffer buf) {
        if (buf == null) {
            return null;
        }
        int size = buf.remaining();
        if (size <= 32) {
            byte[] data = new byte[size];
            buf.asReadOnlyBuffer().get(data);
            return ByteUtil.toString((byte[])data);
        }
        return size + " bytes";
    }
}

