/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.simple;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.util.KeyWatchTracker;

abstract class Mutation
extends KeyRange {
    protected Mutation(byte[] min, byte[] max) {
        super(min, max);
        Preconditions.checkArgument((max == null || !Arrays.equals(min, max) ? 1 : 0) != 0, (Object)"empty range");
    }

    protected Mutation(byte[] value) {
        super(value);
    }

    public abstract void apply(KVStore var1);

    public boolean trigger(KeyWatchTracker keyWatchTracker) {
        return keyWatchTracker.trigger((KeyRange)this);
    }

    public static Mutation key(byte[] value) {
        return new Mutation(value){

            @Override
            public void apply(KVStore kv) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

