/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.simple;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.StaleTransactionException;
import org.jsimpledb.kv.TransactionTimeoutException;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.mvcc.LockManager;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.kv.simple.Del;
import org.jsimpledb.kv.simple.Mutation;
import org.jsimpledb.kv.simple.Put;
import org.jsimpledb.kv.simple.SimpleKVTransaction;
import org.jsimpledb.kv.util.KeyWatchTracker;
import org.jsimpledb.kv.util.NavigableMapKVStore;
import org.jsimpledb.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleKVDatabase
implements KVDatabase,
Serializable {
    public static final long DEFAULT_WAIT_TIMEOUT = 500L;
    public static final long DEFAULT_HOLD_TIMEOUT = 5000L;
    private static final long serialVersionUID = -6960954436594742251L;
    protected final KVStore kv;
    protected transient Logger log = LoggerFactory.getLogger(this.getClass());
    private transient LockManager lockManager = new LockManager((Object)this);
    private transient KeyWatchTracker keyWatchTracker;
    private long waitTimeout;

    public SimpleKVDatabase() {
        this((KVStore)new NavigableMapKVStore());
    }

    public SimpleKVDatabase(KVStore kv) {
        this(kv, 500L, 5000L);
    }

    public SimpleKVDatabase(long waitTimeout, long holdTimeout) {
        this(null, waitTimeout, holdTimeout);
    }

    public SimpleKVDatabase(KVStore kv, long waitTimeout, long holdTimeout) {
        this.kv = kv != null ? kv : new NavigableMapKVStore();
        this.setWaitTimeout(waitTimeout);
        this.setHoldTimeout(holdTimeout);
    }

    public synchronized long getWaitTimeout() {
        return this.waitTimeout;
    }

    public synchronized void setWaitTimeout(long waitTimeout) {
        Preconditions.checkArgument((waitTimeout >= 0L ? 1 : 0) != 0, (Object)"waitTimeout < 0");
        this.waitTimeout = waitTimeout;
    }

    public long getHoldTimeout() {
        return this.lockManager.getHoldTimeout();
    }

    public void setHoldTimeout(long holdTimeout) {
        this.lockManager.setHoldTimeout(holdTimeout);
    }

    @PostConstruct
    public synchronized void start() {
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.keyWatchTracker != null) {
            this.keyWatchTracker.close();
            this.keyWatchTracker = null;
        }
    }

    public SimpleKVTransaction createTransaction(Map<String, ?> options) {
        return this.createTransaction();
    }

    public synchronized SimpleKVTransaction createTransaction() {
        return new SimpleKVTransaction(this, this.waitTimeout);
    }

    synchronized ListenableFuture<Void> watchKey(byte[] key) {
        if (this.keyWatchTracker == null) {
            this.keyWatchTracker = new KeyWatchTracker();
        }
        return this.keyWatchTracker.register(key);
    }

    protected void preCommit(SimpleKVTransaction tx) {
    }

    protected void postCommit(SimpleKVTransaction tx, boolean successful) {
    }

    void applyMutations(final Iterable<Mutation> mutations) {
        if (this.kv instanceof AtomicKVStore) {
            ((AtomicKVStore)this.kv).mutate(new Mutations(){

                public Iterable<Del> getRemoveRanges() {
                    return Iterables.filter((Iterable)mutations, Del.class);
                }

                public Iterable<Map.Entry<byte[], byte[]>> getPutPairs() {
                    return Iterables.transform((Iterable)Iterables.filter((Iterable)mutations, Put.class), Put::toMapEntry);
                }

                public Iterable<Map.Entry<byte[], Long>> getAdjustPairs() {
                    return Collections.emptySet();
                }
            }, true);
        } else {
            for (Mutation mutation : mutations) {
                mutation.apply(this.kv);
            }
        }
    }

    protected void checkState(SimpleKVTransaction tx) {
        assert (Thread.holdsLock(this));
    }

    private void checkUsable(SimpleKVTransaction tx) {
        if (tx.stale) {
            throw new StaleTransactionException((KVTransaction)tx);
        }
        if (this.lockManager.checkHoldTimeout(tx.lockOwner) == -1L) {
            this.rollback(tx);
            throw new TransactionTimeoutException((KVTransaction)tx, "transaction taking too long: hold timeout of " + this.lockManager.getHoldTimeout() + "ms has expired");
        }
    }

    synchronized byte[] get(SimpleKVTransaction tx, byte[] key) {
        Preconditions.checkArgument((key.length == 0 || key[0] != -1 ? 1 : 0) != 0, (Object)"key starts with 0xff");
        this.checkUsable(tx);
        this.checkState(tx);
        Mutation mutation = tx.findMutation(key);
        if (mutation != null) {
            return mutation instanceof Put ? ((Put)mutation).getValue() : null;
        }
        this.getLock(tx, key, ByteUtil.getNextKey((byte[])key), false);
        return this.kv.get(key);
    }

    synchronized KVPair getAtLeast(SimpleKVTransaction tx, byte[] minKey, byte[] maxKey) {
        KVPair entry;
        block12: {
            Mutation mutation;
            block13: {
                SortedSet<Mutation> mutations;
                Mutation overlap;
                if (minKey == null) {
                    minKey = ByteUtil.EMPTY;
                }
                this.checkUsable(tx);
                this.checkState(tx);
                if (maxKey != null && ByteUtil.compare((byte[])minKey, (byte[])maxKey) >= 0) {
                    return null;
                }
                byte[] originalMinKey = minKey;
                if (minKey.length > 0 && (overlap = tx.findMutation(minKey)) != null) {
                    if (overlap instanceof Put) {
                        Put put = (Put)overlap;
                        assert (Arrays.equals(put.getKey(), minKey));
                        return new KVPair(put.getKey(), put.getValue());
                    }
                    assert (overlap instanceof Del);
                    byte[] max = overlap.getMax();
                    if (max == null || maxKey != null && ByteUtil.compare((byte[])max, (byte[])maxKey) >= 0) {
                        return null;
                    }
                    minKey = max;
                }
                this.getLock(tx, originalMinKey, maxKey, false);
                SortedSet<Mutation> sortedSet = mutations = maxKey != null ? tx.mutations.headSet(Mutation.key(maxKey)) : tx.mutations;
                do {
                    assert (minKey != null);
                    mutation = !(mutations = mutations.tailSet(Mutation.key(minKey))).isEmpty() ? mutations.first() : null;
                    entry = this.kv.getAtLeast(minKey, maxKey);
                    assert (entry == null || ByteUtil.compare((byte[])entry.getKey(), (byte[])minKey) >= 0);
                    assert (entry == null || maxKey == null || ByteUtil.compare((byte[])entry.getKey(), (byte[])maxKey) < 0);
                    if (mutation == null && entry == null) {
                        return null;
                    }
                    if (mutation == null || entry != null && mutation.compareTo(entry.getKey()) > 0) break block12;
                    if (!(mutation instanceof Del)) break block13;
                } while ((minKey = mutation.getMax()) != null && (maxKey == null || ByteUtil.compare((byte[])minKey, (byte[])maxKey) < 0));
                return null;
            }
            Put put = (Put)mutation;
            return new KVPair(put.getKey(), put.getValue());
        }
        return entry;
    }

    synchronized KVPair getAtMost(SimpleKVTransaction tx, byte[] maxKey, byte[] minKey) {
        KVPair entry;
        block9: {
            Mutation mutation;
            block10: {
                if (minKey == null) {
                    minKey = ByteUtil.EMPTY;
                }
                this.checkUsable(tx);
                this.checkState(tx);
                if (maxKey != null && ByteUtil.compare((byte[])minKey, (byte[])maxKey) >= 0) {
                    return null;
                }
                this.getLock(tx, minKey, maxKey, false);
                SortedSet<Mutation> mutations = tx.mutations;
                do {
                    if (maxKey != null) {
                        mutations = mutations.headSet(Mutation.key(maxKey));
                    }
                    mutation = !mutations.isEmpty() ? (Mutation)((Object)mutations.last()) : null;
                    entry = this.kv.getAtMost(maxKey, minKey);
                    assert (entry == null || ByteUtil.compare((byte[])entry.getKey(), (byte[])minKey) >= 0);
                    assert (entry == null || maxKey == null || ByteUtil.compare((byte[])entry.getKey(), (byte[])maxKey) < 0);
                    if (mutation == null && entry == null) {
                        return null;
                    }
                    if (mutation == null || entry != null && mutation.compareTo(entry.getKey()) < 0) break block9;
                    if (!(mutation instanceof Del)) break block10;
                } while ((maxKey = mutation.getMin()) != null && ByteUtil.compare((byte[])minKey, (byte[])maxKey) < 0);
                return null;
            }
            Put put = (Put)mutation;
            if (ByteUtil.compare((byte[])put.getKey(), (byte[])minKey) < 0) {
                assert (entry == null);
                return null;
            }
            return new KVPair(put.getKey(), put.getValue());
        }
        return entry;
    }

    synchronized void put(SimpleKVTransaction tx, byte[] key, byte[] value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Preconditions.checkArgument((key.length == 0 || key[0] != -1 ? 1 : 0) != 0, (Object)"key starts with 0xff");
        this.checkUsable(tx);
        this.checkState(tx);
        byte[] keyNext = ByteUtil.getNextKey((byte[])key);
        Mutation mutation = tx.findMutation(key);
        if (mutation instanceof Put) {
            assert (Arrays.equals(((Put)mutation).getKey(), key));
            tx.mutations.remove((Object)mutation);
            tx.mutations.add(new Put(key, value));
        } else if (mutation instanceof Del) {
            Del del = (Del)mutation;
            byte[] delMin = del.getMin();
            byte[] delMax = del.getMax();
            tx.mutations.remove((Object)del);
            if (KeyRange.compare((byte[])delMin, (byte[])key) < 0) {
                tx.mutations.add(new Del(delMin, key));
            }
            if (KeyRange.compare((byte[])keyNext, (byte[])delMax) < 0) {
                tx.mutations.add(new Del(keyNext, delMax));
            }
            tx.mutations.add(new Put(key, value));
        } else {
            this.getLock(tx, key, keyNext, true);
            tx.mutations.add(new Put(key, value));
        }
    }

    synchronized void remove(SimpleKVTransaction tx, byte[] key) {
        Preconditions.checkArgument((key.length == 0 || key[0] != -1 ? 1 : 0) != 0, (Object)"key starts with 0xff");
        this.checkUsable(tx);
        this.checkState(tx);
        byte[] keyNext = ByteUtil.getNextKey((byte[])key);
        Mutation mutation = tx.findMutation(key);
        if (mutation instanceof Put) {
            assert (Arrays.equals(((Put)mutation).getKey(), key));
            tx.mutations.remove((Object)mutation);
            tx.mutations.add(new Del(key));
        } else if (mutation == null) {
            this.getLock(tx, key, keyNext, true);
            tx.mutations.add(new Del(key));
        }
    }

    synchronized void removeRange(SimpleKVTransaction tx, byte[] minKey, byte[] maxKey) {
        Del del2;
        int diff;
        if (minKey == null) {
            minKey = ByteUtil.EMPTY;
        }
        Preconditions.checkArgument(((diff = KeyRange.compare((byte[])minKey, (byte[])maxKey)) <= 0 ? 1 : 0) != 0, (Object)"minKey > maxKey");
        this.checkUsable(tx);
        this.checkState(tx);
        if (diff == 0) {
            return;
        }
        byte[] originalMinKey = minKey;
        byte[] originalMaxKey = maxKey;
        if (minKey.length > 0) {
            Mutation leftMutation = tx.findMutation(minKey);
            if (leftMutation instanceof Put) {
                assert (Arrays.equals(((Put)leftMutation).getKey(), minKey));
                tx.mutations.remove((Object)leftMutation);
            } else if (leftMutation instanceof Del) {
                del2 = (Del)leftMutation;
                tx.mutations.remove((Object)del2);
                minKey = del2.getMin();
                if (KeyRange.compare((byte[])del2.getMax(), (byte[])maxKey) > 0) {
                    maxKey = del2.getMax();
                }
            }
        }
        if (maxKey != null) {
            Mutation rightMutation = null;
            try {
                rightMutation = minKey != null ? tx.mutations.subSet(Mutation.key(minKey), Mutation.key(maxKey)).last() : tx.mutations.headSet(Mutation.key(maxKey)).last();
            }
            catch (NoSuchElementException del2) {
                // empty catch block
            }
            if (rightMutation instanceof Put) {
                tx.mutations.remove((Object)rightMutation);
            } else if (rightMutation instanceof Del) {
                del2 = (Del)rightMutation;
                tx.mutations.remove((Object)del2);
                if (KeyRange.compare((byte[])del2.getMax(), (byte[])maxKey) > 0) {
                    maxKey = del2.getMax();
                }
            }
        }
        if (originalMinKey.length == 0 && originalMaxKey == null) {
            tx.mutations.clear();
        } else if (originalMinKey.length == 0) {
            tx.mutations.headSet(Mutation.key(originalMaxKey)).clear();
        } else if (originalMaxKey == null) {
            tx.mutations.tailSet(Mutation.key(originalMinKey)).clear();
        } else {
            tx.mutations.subSet(Mutation.key(originalMinKey), Mutation.key(originalMaxKey)).clear();
        }
        this.getLock(tx, minKey, maxKey, true);
        tx.mutations.add(new Del(minKey, maxKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void commit(SimpleKVTransaction tx, boolean readOnly) {
        if (tx.stale) {
            throw new StaleTransactionException((KVTransaction)tx);
        }
        tx.stale = true;
        boolean allMutationsWereLocked = true;
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsEnabled) {
            for (Mutation mutation : tx.mutations) {
                if (this.lockManager.isLocked(tx.lockOwner, mutation.getMin(), mutation.getMax(), true)) continue;
                allMutationsWereLocked = false;
                break;
            }
        }
        if (!this.lockManager.release(tx.lockOwner)) {
            throw new TransactionTimeoutException((KVTransaction)tx, "transaction taking too long: hold timeout of " + this.lockManager.getHoldTimeout() + "ms has expired");
        }
        assert (allMutationsWereLocked);
        this.checkState(tx);
        if (readOnly || tx.mutations.isEmpty()) {
            return;
        }
        this.preCommit(tx);
        boolean successful = false;
        try {
            this.applyMutations(tx.mutations);
            successful = true;
            if (this.keyWatchTracker != null && this.keyWatchTracker.getNumKeysWatched() > 0) {
                for (Mutation mutation : tx.mutations) {
                    mutation.trigger(this.keyWatchTracker);
                }
            }
        }
        finally {
            tx.mutations.clear();
            this.postCommit(tx, successful);
        }
    }

    synchronized void rollback(SimpleKVTransaction tx) {
        if (tx.stale) {
            return;
        }
        tx.stale = true;
        this.lockManager.release(tx.lockOwner);
    }

    private void getLock(SimpleKVTransaction tx, byte[] minKey, byte[] maxKey, boolean write) {
        LockManager.LockResult lockResult;
        try {
            lockResult = this.lockManager.lock(tx.lockOwner, minKey, maxKey, write, tx.waitTimeout);
        }
        catch (InterruptedException e) {
            this.rollback(tx);
            Thread.currentThread().interrupt();
            throw new RetryTransactionException((KVTransaction)tx, "transaction interrupted while waiting to acquire lock", (Throwable)e);
        }
        switch (lockResult) {
            case SUCCESS: {
                break;
            }
            case WAIT_TIMEOUT_EXPIRED: {
                this.rollback(tx);
                throw new RetryTransactionException((KVTransaction)tx, "could not acquire lock after " + tx.waitTimeout + "ms");
            }
            case HOLD_TIMEOUT_EXPIRED: {
                this.rollback(tx);
                throw new TransactionTimeoutException((KVTransaction)tx, "transaction taking too long: hold timeout of " + this.lockManager.getHoldTimeout() + "ms has expired");
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.log = LoggerFactory.getLogger(this.getClass());
        this.lockManager = new LockManager((Object)this);
    }
}

