/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.simple;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVPairIterator;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.mvcc.LockOwner;
import org.jsimpledb.kv.mvcc.MutableView;
import org.jsimpledb.kv.simple.Mutation;
import org.jsimpledb.kv.simple.SimpleKVDatabase;
import org.jsimpledb.kv.util.CloseableForwardingKVStore;
import org.jsimpledb.kv.util.NavigableMapKVStore;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;
import org.slf4j.LoggerFactory;

public class SimpleKVTransaction
extends AbstractKVStore
implements KVTransaction {
    final SimpleKVDatabase kvdb;
    final TreeSet<Mutation> mutations = new TreeSet(KeyRange.SORT_BY_MIN);
    final LockOwner lockOwner = new LockOwner();
    boolean stale;
    long waitTimeout;
    private volatile boolean readOnly;

    protected SimpleKVTransaction(SimpleKVDatabase kvdb, long waitTimeout) {
        Preconditions.checkArgument((kvdb != null ? 1 : 0) != 0, (Object)"null kvdb");
        this.kvdb = kvdb;
        this.setTimeout(waitTimeout);
    }

    public SimpleKVDatabase getKVDatabase() {
        return this.kvdb;
    }

    public void setTimeout(long timeout) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout < 0");
        this.waitTimeout = timeout;
    }

    public ListenableFuture<Void> watchKey(byte[] key) {
        return this.kvdb.watchKey(key);
    }

    public byte[] get(byte[] key) {
        return this.kvdb.get(this, key);
    }

    public KVPair getAtLeast(byte[] min, byte[] max) {
        return this.kvdb.getAtLeast(this, min, max);
    }

    public KVPair getAtMost(byte[] max, byte[] min) {
        return this.kvdb.getAtMost(this, max, min);
    }

    public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        if (minKey == null) {
            minKey = ByteUtil.EMPTY;
        }
        return new KVPairIterator((KVStore)this, new KeyRange(minKey, maxKey), null, reverse);
    }

    public void put(byte[] key, byte[] value) {
        this.kvdb.put(this, key, value);
    }

    public void remove(byte[] key) {
        this.kvdb.remove(this, key);
    }

    public void removeRange(byte[] minKey, byte[] maxKey) {
        this.kvdb.removeRange(this, minKey, maxKey);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void commit() {
        this.kvdb.commit(this, this.readOnly);
    }

    public void rollback() {
        this.kvdb.rollback(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableKVStore mutableSnapshot() {
        CloseableForwardingKVStore kvstore;
        AtomicKVStore kv;
        if (this.kvdb.kv instanceof NavigableMapKVStore) {
            SimpleKVDatabase simpleKVDatabase = this.kvdb;
            synchronized (simpleKVDatabase) {
                kv = ((NavigableMapKVStore)this.kvdb.kv).clone();
            }
            kvstore = new CloseableForwardingKVStore((KVStore)kv.clone());
        } else if (this.kvdb.kv instanceof AtomicKVStore) {
            kv = (AtomicKVStore)this.kvdb.kv;
            CloseableKVStore snapshot = kv.snapshot();
            MutableView view = new MutableView((KVStore)snapshot);
            view.disableReadTracking();
            kvstore = new CloseableForwardingKVStore((KVStore)view, (Closeable)snapshot);
        } else {
            throw new UnsupportedOperationException("underlying KVStore " + this.kvdb.kv.getClass().getSimpleName() + " is not an AtomicKVStore");
        }
        SimpleKVDatabase simpleKVDatabase = this.kvdb;
        synchronized (simpleKVDatabase) {
            for (Mutation mutation : this.mutations) {
                mutation.apply((KVStore)kvstore);
            }
        }
        return kvstore;
    }

    Mutation findMutation(byte[] key) {
        Mutation last;
        assert (Thread.holdsLock(this.kvdb));
        assert (!this.hasOverlaps() && !this.hasEmpties());
        SortedSet<Mutation> left = this.mutations.headSet(Mutation.key(ByteUtil.getNextKey((byte[])key)));
        if (!left.isEmpty() && (last = left.last()).contains(key)) {
            return last;
        }
        return null;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.stale) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn((Object)((Object)this) + " leaked without commit() or rollback()");
            }
            this.rollback();
        }
        finally {
            super.finalize();
        }
    }

    private boolean hasEmpties() {
        for (Mutation mutation : this.mutations) {
            byte[] minKey = mutation.getMin();
            byte[] maxKey = mutation.getMax();
            if (minKey == null || maxKey == null || !Arrays.equals(minKey, maxKey)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOverlaps() {
        Mutation previous = null;
        for (Mutation mutation : this.mutations) {
            if (previous != null && mutation.overlaps(previous)) {
                return true;
            }
            previous = mutation;
        }
        return false;
    }
}

