/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.simple;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import org.dellroad.stuff.io.AtomicUpdateFileOutputStream;
import org.dellroad.stuff.io.FileStreamRepository;
import org.dellroad.stuff.io.StreamRepository;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVDatabaseException;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.simple.SimpleKVDatabase;
import org.jsimpledb.kv.simple.SimpleKVTransaction;
import org.jsimpledb.kv.simple.XMLKVTransaction;
import org.jsimpledb.kv.util.XMLSerializer;

public class XMLKVDatabase
extends SimpleKVDatabase {
    private static final long serialVersionUID = 5699298282473179002L;
    private StreamRepository repository;
    private final File file;
    private int generation;
    private long timestamp;
    private File initialContentFile;

    public XMLKVDatabase(File file) {
        this((StreamRepository)new FileStreamRepository(file), 500L, 5000L);
    }

    public XMLKVDatabase(File file, long waitTimeout, long holdTimeout) {
        this((StreamRepository)(XMLKVDatabase.isWindows() ? XMLKVDatabase.buildWindowsStreamRepository(file) : new FileStreamRepository(file)), waitTimeout, holdTimeout, file);
    }

    public XMLKVDatabase(StreamRepository repository) {
        this(repository, 500L, 5000L);
    }

    public XMLKVDatabase(StreamRepository repository, long waitTimeout, long holdTimeout) {
        this(repository, waitTimeout, holdTimeout, repository instanceof FileStreamRepository ? ((FileStreamRepository)repository).getFile() : null);
    }

    private XMLKVDatabase(StreamRepository repository, long waitTimeout, long holdTimeout, File file) {
        super(waitTimeout, holdTimeout);
        Preconditions.checkArgument((repository != null ? 1 : 0) != 0, (Object)"null repository");
        this.repository = repository;
        this.file = file;
    }

    protected InputStream getInitialContent() throws IOException {
        return this.initialContentFile != null ? new FileInputStream(this.initialContentFile) : null;
    }

    public void setInitialContentFile(File initialContentFile) {
        this.initialContentFile = initialContentFile;
    }

    @Override
    public synchronized void start() {
        super.start();
        this.reload();
    }

    @Override
    public synchronized XMLKVTransaction createTransaction() {
        this.checkForOutOfBandUpdate();
        return new XMLKVTransaction(this, this.getWaitTimeout(), this.generation);
    }

    public synchronized void reload() {
        this.readXML();
    }

    public synchronized int getGeneration() {
        return this.generation;
    }

    public synchronized boolean checkForOutOfBandUpdate() {
        if (this.file == null) {
            return false;
        }
        long fileTime = this.file.lastModified();
        if (fileTime == 0L) {
            return false;
        }
        if (this.timestamp != 0L) {
            if (fileTime <= this.timestamp) {
                return false;
            }
            this.log.info("detected out-of-band update of XMLKVDatabase file `" + this.file + "'; reloading");
        }
        this.readXML();
        return true;
    }

    @Override
    protected synchronized void checkState(SimpleKVTransaction tx) {
        this.checkForOutOfBandUpdate();
        int txGeneration = ((XMLKVTransaction)tx).getGeneration();
        if (txGeneration != this.generation) {
            throw new RetryTransactionException((KVTransaction)tx, "XML file changed since transaction started (generation number changed from " + txGeneration + " to " + this.generation + ")");
        }
    }

    @Override
    protected void postCommit(SimpleKVTransaction tx, boolean successful) {
        if (!successful) {
            this.readXML();
            return;
        }
        this.writeXML();
    }

    protected synchronized void readXML() {
        InputStream input;
        this.kv.removeRange(null, null);
        long newTimestamp = this.file != null ? this.file.lastModified() : 0L;
        try {
            input = this.repository.getInputStream();
        }
        catch (FileNotFoundException e) {
            String desc;
            if (this.generation != 0) {
                throw new KVDatabaseException((KVDatabase)this, "error reading XML content: file not longer available", (Throwable)e);
            }
            try {
                input = this.getInitialContent();
            }
            catch (IOException e2) {
                throw new KVDatabaseException((KVDatabase)this, "error opening initial XML content", (Throwable)e2);
            }
            String string = desc = this.file != null ? "file `" + this.file + "'" : "database file";
            if (input == null) {
                this.log.info(desc + " not found and no initial content is configured; creating new, empty database");
            } else {
                this.log.info(desc + " not found; applying default initial content");
            }
        }
        catch (IOException e) {
            throw new KVDatabaseException((KVDatabase)this, "error opening XML content", (Throwable)e);
        }
        if (input != null) {
            try {
                new XMLSerializer(this.kv).read((InputStream)new BufferedInputStream(input));
            }
            catch (XMLStreamException e) {
                throw new KVDatabaseException((KVDatabase)this, "error reading XML content", (Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (newTimestamp != 0L) {
            this.timestamp = newTimestamp;
        }
        ++this.generation;
    }

    protected synchronized void writeXML() {
        boolean successful = false;
        try {
            OutputStream output = this.repository.getOutputStream();
            try {
                new XMLSerializer(this.kv).write(output, true);
                if (output instanceof FileOutputStream) {
                    ((FileOutputStream)output).getFD().sync();
                }
                output.close();
                if (this.file != null) {
                    this.timestamp = this.file.lastModified();
                }
                successful = true;
            }
            finally {
                if (!successful && output instanceof AtomicUpdateFileOutputStream) {
                    ((AtomicUpdateFileOutputStream)output).cancel();
                }
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new KVDatabaseException((KVDatabase)this, "error writing XML content", (Throwable)e);
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH).contains("win");
    }

    private static StreamRepository buildWindowsStreamRepository(final File file) {
        final Object lock = new Object();
        return new StreamRepository(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public InputStream getInputStream() throws IOException {
                Object object = lock;
                synchronized (object) {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    try (FileInputStream input = new FileInputStream(file);){
                        int r;
                        byte[] buf = new byte[1024];
                        while ((r = input.read(buf)) != -1) {
                            data.write(buf, 0, r);
                        }
                    }
                    return new ByteArrayInputStream(data.toByteArray());
                }
            }

            public OutputStream getOutputStream() {
                return new ByteArrayOutputStream(){
                    private boolean closed;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void close() throws IOException {
                        Object object = lock;
                        synchronized (object) {
                            if (this.closed) {
                                return;
                            }
                            try (FileOutputStream output = new FileOutputStream(file);){
                                output.write(this.toByteArray());
                                output.getChannel().force(false);
                            }
                            this.closed = true;
                        }
                    }
                };
            }
        };
    }
}

